package Revision::FC_DISK;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use strict;
use base 'Revision';
use System;
use Util;
use TO;

# $disk->{LogicalPath} $disk->{Revision} $disk->{VendorID} $disk->{ProductID}

#
#  PASS, LOW, HIGH, NI (not installed), ERR

sub description {"Sun Internal Fibre Channel Disk Firmware"}
sub class {"internal disk"}
sub type {"internal"}

sub RUN {
  my($class, $Matrix, $InstalledPatches) = @_;
  my @R;

  my $to = TO->readExistingTopo();
  my $storages = $to->storageList();

  my ($renv, $devices, $hosts, $notifs, $Config) = PDM::ConfigFile->read();

  foreach my $st (@$storages) {
     #if ($st->type() eq "internal") {
     if ($st->type() eq "hbastorage") {
        my $disks = $st->diskInfo();
        foreach my $ctd (keys %$disks) {
              my $d = $disks->{$ctd};

	      # check to see if this entry has been discovered as an Internal disk
	      foreach my $dev (@$devices) {
	         next if($dev->{class} !~ /internal/);
		 if($dev->{wwn2} =~ /$d->{NodeWWN}/){
                    my $disk_key = "$d->{VendorID}:$d->{ProductID}:INTERNAL_DISK_FW";
                    push(@R, $class->check_internal_disk_fw($Matrix, $InstalledPatches, 
                      $disk_key, $d->{LogicalPath}, $d->{Revision} )); 
		 }
	      }
        }
        #last;
      }
  }
  return \@R;
}

sub check_internal_disk_fw{

    my ($class, $Matrix, $InstalledP, $key, $dev, $curr_fw) = @_;
    my $disk_fw = $Matrix->{INTERNAL_DISK_FW};
    my $category = "Internal Disk FW";
    my $info = "FC disk";
    print "Key = $key\n";
    if ( $disk_fw->{$key} ){
         my $d = $disk_fw->{$key};
         my $req_fw = $d->[0];
         my $req_patch = $d->[2];
         my $comp = $class->compareFwLevels($curr_fw, $req_fw);
         if ( $comp==0) {
            return [$category, $dev,'PASS',$curr_fw, $req_fw,undef,undef,$info];
         } elsif ($comp>0) {
            return [$category, $dev,'UPREV',$curr_fw, $req_fw,undef,undef,$info];
         } elsif ($comp<0){
            return [$category, $dev,'DOWNREV',$curr_fw, $req_fw,undef,$req_patch,$info];
         }

    } else {
       return [$category, $dev, 'INFO', undef, undef,undef,undef,"The disk drive type is not shown in config matrix, please contact your sun representative"];
    }

}

1;
