package NWS::NTC;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name: bld61_002 $ 
#  $Id: NTC.pm,v 1.1 2006/05/12 19:37:28 mckenney Exp $

use Report;
use CIM::Instance;
use Data::Dumper;
use strict;
use Ilist;
use PDM;
use NWS;

sub revision {'$Revision: 1.1 $'}

sub newSystem {
  my ($class, $rep) = @_;
  my(@pil, $i, $dd, $a, $j, $k, $k1, $v);
  my $wwn  = $rep->get('id.wwn'); # really the key now
  my $renv = System->get_renv();
  my $rev = $rep->get('info.firmwareLevel');

  my($p1) = CIM::Instance->new('NWS_System',[
                    [Name 		=> $wwn ],
                    [OtherIdentifyingInfo  => $rep->{display} ],
                    [SystemName         => $rep->get('id.name')],
                    [IP 		=> $rep->get('id.ipno')],
                    [SerialNo           => $renv->{cust_no} ],
                    [SolutionModel      => $rep->get('info.model')],
                ]);

  my($p2) = CIM::Instance->new('CIM_PhysicalFrame', [
                  [Tag 			=> $wwn],
                  [Name			=> $wwn],
                  [Manufacturer 	=> "SUN"],
                  [Model 		=> "NTC"],
                  ]);

  my($a2) = CIM::Instance->new('CIM_ComputerSystemPackage', [
                  [Antecedent            => $p1],
                  [Dependent             => $p2],
                  ]);

  my($l1) = NWS->location($rep);
  
  my($al1) = CIM::Instance->new('NWS_PhysicalFrameLocation', [
                  [Element		=> $p2],
                  [PhysicalLocation 	=> $l1],
                  ]);
               
  push (@pil, $p1, $p2, $a2, $l1, $al1);
  


  return Ilist->new(\@pil);

}









1;
