package Logic::SE;
use Logic;
use strict;
use MIME::Base64;

#  host => , ip => , name => , 
#  return ($err_object, $nodes_list);

sub addToConfig {
  my ($class, $q) = @_;
  my ($err, $nodes);

  while (1) {
     if ($q->{name} eq "") {
        $err = Error->error("se.101");
        last;
     } elsif (!$q->{ip}) {
        $err = Error->error("se.102");
        last;
     } else {
        my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
        my(%F);
        foreach my $d (@$devs) {
          if ($d->{type} =~ /^se\d*/) {
             $F{$d->{wwn}} = 1;
          }
        }
        ($err, $nodes) = $class->add($q, $devs, \%F);
        if (!$err && $nodes) {
           Logic->clearSlave($q->{host}, $hosts);
           if (!PDM::ConfigFile->write( $renv, $devs, $hosts,$notifs)) {
              $err = Error->error("101", "");
           }
        }
     }
     last;
  }
  return ($err, $nodes);
}

sub add {
  my($class, $q, $devs, $F) = @_;
  my (@nodes, $err);
  my($ipno, $python, $msg, $adding);
  my $host = $q->{host};
  my $ip   = $q->{ip};
  my $name = $q->{name};

  if (!($ipno = Util->testIp($ip))) {
      my $err = Error->error("se.104", $ip);
      return ($err, []);
  }
  my($solution, $wwn, $model, $hostname, $used_port, $version);
  ($solution, $wwn, $model, $hostname, $used_port, $version) = $class->find_solution($ipno, {try_rashttp => 1});

  if ($used_port && index($ip, ":") < 0) {
    $ip   .= ":$used_port";
  }
  if ($used_port && index($ipno, ":") < 0) {
    $ipno .= ":$used_port";
  }

  require Agent::SE_MODULE;
  my $dev = { mgmtLevel => "D", ip => $ip };
  my $LINKS = Agent::SE_MODULE->getLinks($dev, 10);
  my ($p,$wwns);

  for ($p=0; $p < $LINKS->{'info.portTotal'} ; $p++) {
    $wwns .= $LINKS->{"fcPort.$p.LocalPortWWN"} . "|";
  }

 
  $solution = "se" if (!$solution); # se,se2, nothing

  if (!$wwn) {
      my $err = Error->error("se.105", $ipno);
      return ($err, []);

  } elsif (!$F->{$wwn} ) {
      $F->{$wwn} = 1;
      my($new_dev) = $#$devs  + 1;
      my $encode = MIME::Base64::encode("$q->{login}:$q->{password}");
      chomp($encode);

      PDM::ConfigFile->addDevice($devs, {
        type     => $solution,
        class    => "storage.$solution",
        name     => $name || $wwn,
        ip       => $ip,
        wwns     => $wwns,
        saVersion=> $version,
        ipName   => $hostname,
        login    => $q->{login},
        password => $q->{password},
        LID      => $encode,
        wwn      => $wwn,
        mgmtLevel=> "D",
        key      => $wwn,
        model    => $model,
        ipno     => $ipno,
        host     => $host,
        active   => "Y",
      });
      push(@nodes, $devs->[$new_dev]);
      Util::Http->saveFile($ip, "SA2IP", Util->name2ip(), 8);
      

  } else {
      my $err = Error->error("se.106", $wwn);
      return ($err, []);
  }
  return (undef, \@nodes);
}

# accept port or no port
# returns 7443 in the port# or nothing if it's 7654

sub find_solution {
  my($class, $ip, $arg) = @_;
  my($wwn, $type, $i);

  my ($ip0, $port0) = split(/\:/, $ip);
  if ($port0) {
    $i = Util->rasInfo($ip);
  } else {
    $i = Util->rasInfo("$ip0:6789", $arg);
    if (!$i->{solutionModel}) {
      $i = Util->rasInfo("$ip0:7443");
      if (!$i->{solutionModel}) {
        $i = Util->rasInfo("$ip0:7654");
        $port0 = "7654";
      } else {
        $port0 = "7443";
      }
    } else {
      $port0 = "6789";
    }
  }

  if ($i->{solutionModel}) {
     my $version = $i->{version};
     $version =~ s/version=//;
     return ($i->{solution}, $i->{solutionModel} . "." . $i->{hostid}, 
             $i->{solutionModel},
             $i->{hostname}, $port0, $version
            );
  } else {
     return ();
  }
}

1;
