package Health::5210;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#Name:  Keyur Desai
#  $Id:

use base 'Health';
use NWS::5210;
use Ilist;
use Message;
use Catalog;
use Report;
use System;
use Events;
use strict;
use Debug;

sub revision {'$Revision: 1.15 $'}

#####################################################
sub all_logic {
  my($hm, $report) = @_;
  my($ev, $ed, $pertains, $x ,$y, $contain, $sd);
  my($orep, $key);
  my($rep)     = $report->content;
  my($oreport) = PDM->getOldReport($report->fileKey);
  my($ip)      = $report->id('ip');
  $DB::single = 1;
  my $sn      = $report->id('deviceName');
  my($id)      = $report->id('display');
  my($shortid) = $report->name();
  my($log)     = $report->log();
  my($renv)    = System->get_renv();
  my $mgmtLevel = $report->value('id.mgmtLevel') || 'D';
  my $type     = $report->id('category');

  CIM->version("1.1");

  # CHECK FOR COMM-LOST EVENTS: this event will trigger the appropriate
  # commLost/commRegained at the right time using it's own persistence.
  # this health module should return when this function returns non-null value.
  if ($hm->connectionEvent($sn, $report, {method => 2, threshold_severity => 1} )) {  # IB / OOB
     return;
  }

  my($tran, $reps) = Transition->getTransition({ key => $sn,
                                         code => 'ethernet',
                                        value => $report->value("info.ethernet_status"),
                             transition_value => "ping_failed",
                                       repeat => '12h',
                                 });
  $hm->connection("ethernet", $sn, $tran, $report, "Ethernet", $reps, 
                         {connect_errs => $report->value("info.ethernet_errs"),
                                method => 2});

  # GENERATE A DISCOVERY/AUDIT EVENT
  my $freq = $renv->{audit_freq} || 7;
  my $audit = System->get_audit() ? "YES" : Timer->isXdays("Audit$sn", $freq);

  if (!$oreport || $audit eq "YES" ) {  # new 5210 NAS device or audit time.
     my($etype) = $audit eq "YES" ? "$type.AuditEvent" : "$type.DiscoveryEvent";
     my($title) = $audit eq "YES" ? "Auditing a":"Discovered a new";

     my($dt)    = "A" if (!$audit);
     Grid->setCode($etype);

     $ev = CIM::Instance->new('NWS_Event', [
                  [ EventType   => $etype  ],
                  [ Target      => "$type:$sn"    ],
                  [ TargetName  => $id     ],
                  [ SourceIP    => $ip     ],
                  [ MgmtLevel   => $mgmtLevel ],
                  [ EventId     => PDM->getEventSequence  ],
                  [ Description => "$title $type called $id"],
                  [ Data        => $hm->serial($rep) ],
                         ]);

     $sd = Events->sourceDetector({ event => $ev , host => 1, rep => $rep});
      
     my($p) = NWS::5210->newSystem($rep);

     $pertains = CIM::Instance->new('NWS_EventPertainsToSystem', [
                  [ Event       => $ev  ],
                  [ Element     => $p->[0] ],
                  [ DiscoveryType => $dt],
                    ]);
     my($monitors) = CIM::Instance->new('NWS_AgentMonitors', [
                  [ Agent       => $sd->[0]  ],
                  [ Element     => $p->[0] ],
                    ]);

     $ed = Message->new( {  id        => $report->id,
                            instances => [$ev, @$sd, @$p, $monitors, $pertains ],
                            severity  => Message::SEVERITY_NORMAL });

     PDM->saveMessage($ed);
  }

  # SET $OREP
  $orep = ($oreport)? $oreport->content() : $rep; # same report if new disco.

  # LOCATION CHANGE EVENT
  $hm->locationChangeEvent($report, $rep, $orep, $sn);

  # DEFINE PHYSICAL FRAME
  my($physicalFrame) = CIM::Key->new( ['CIM_PhysicalFrame',   # key of the frame
                        Tag               => "$type.$sn",
                        CreationClassName => 'CIM_PhysicalFrame' ]);

  # System Reboot/uptime events
  my $uptime = $rep->get("info.SysUpTime");
  my $ouptime = $orep->get("info.SysUpTime");
  my ($uptimeinSec, $ouptimeinSec);

  if ($uptime =~ /((\d+))/) {
     $uptimeinSec = $1;  
  }
  if ($ouptime =~ /((\d+))/) {
     $ouptimeinSec = $1;  
  } 

  if ($uptimeinSec && $ouptimeinSec && ($uptimeinSec < $ouptimeinSec)) {
       Grid->setCode("$type.AlarmEvent.system_reboot");
       $hm->alarmEvent("SysUpTime", "", $report, $sn, "$type reboot, uptime decreased on $id from $ouptime to $uptime", 1, "system_reboot");
  }

################################################
# FRUS - Power Supply, Fan, Battery, Disk Drive.
################################################

   # Insert and State change of FRU's section
   my $ototalDiskDrive =  $orep->{"info.totalPhysicalDiskDrive"};
   foreach my $e (keys %$rep) {
      
      if (($ototalDiskDrive) && ($ototalDiskDrive ne "0")) {
        if (($e =~ /physicaldrive.(\d)-(\d+).RaidPhysicalDriveSerial/) ||
            ($e =~ /physicaldrive.(\d)-(\d)-(\d+).RaidPhysicalDriveSerial/))   {   # PhysicalDiskDrive    
	 
          my ($controllerID, $channelID, $targetID, $ix);

	  if ($3) {
	    $controllerID = $1;
 	    $channelID = $2;
            $targetID = $3;
	    $ix = $controllerID."-".$channelID ."-" .$targetID;	    	    
	  } else {
 	    $channelID = $1;
            $targetID = $2;
	    $ix = $channelID ."-" .$targetID;
	  }

          my $comp = "physicaldrive.$ix";
          my $oserial = NWS::5210->getKey($orep, $comp); 
	  #my $oserial = $orep->{"$comp.RaidPhysicalDriveSerial"};
          my $nserial = NWS::5210->getKey($rep, $comp);
	  #my $nserial = $rep->{"$comp.RaidPhysicalDriveSerial"};
 	  my $drvstatus = $rep->{"$comp.RaidPhysicalDriveStatus"};
	  my $odrvstatus = $orep->{"$comp.RaidPhysicalDriveStatus"};

          next if (!exists($rep->{"$comp.RaidPhysicalDriveSerial"}) && !exists($orep->{"$comp.RaidPhysicalDriveSerial"}));
	  if ($oserial eq $nserial) {
            Grid->setCode("$type.StateChangeEvent.disk");
            my $e2 = $hm->stateEvent($comp, $report, $rep, $orep, 'CIM_Card', $nserial, $sn);

	    # For 5310 Disk Removal only
	    if (($drvstatus ne 'absent') && ($odrvstatus eq 'absent')) {
	      Grid->setCode("$type.ComponentInsertEvent.disk");
	      my $part = NWS::5210->newDiskDrive($rep, $comp);	      
              $hm->insertCompEvent($comp,$physicalFrame, $report, $orep, $part, $nserial, $sn); 
	    }
	    # End for 5310 Disk Removal only.

          } else {	 

	    if ($nserial && (!exists($orep->{"$comp.RaidPhysicalDriveSerial"})) ) {  # For 5310
           
              # Put an additional check for time out on Disk Drives
	      next if ($orep->{"$comp.RaidPhysicalDriveType"});
	      # End of additional check

	      Grid->setCode("$type.ComponentInsertEvent.disk");
	      my $part = NWS::5210->newDiskDrive($rep, $comp);	      
              $hm->insertCompEvent($comp,$physicalFrame, $report, $orep, $part, $nserial, $sn); 
	    }
	  }
        } 
      } 
      
      if (($e =~ /controller\.(\d)\.RaidControllerFirmwareVersion/) ||
          ($e =~ /controller\.(\d)\.RaidCtlrFirmwareVersion/)) {  # Firmware
       
         my $comp = "controller.$1";
         my $ostatus = $orep->{"$comp.RaidControllerStatus"};
	 my $nstatus = $rep->{"$comp.RaidControllerStatus"}; 	 
	 my $ofirm = $orep->{"$comp.RaidControllerFirmwareVersion"};
         my $nfirm = $rep->{"$comp.RaidControllerFirmwareVersion"};

	 if ($ostatus && $nstatus && ($ostatus ne $nstatus)) {
           Grid->setCode("$type.StateChangeEvent.controller");
           my $e2 = $hm->stateEvent($comp, $report, $rep, $orep, 'CIM_Card', "$type.$sn.$comp", $sn);
         } 

         if ($ofirm && $nfirm && ($ofirm ne $nfirm)) {
             Grid->setCode("$type.AlarmEvent.firmware_version");  # firmware_version, revision
             $hm->alarmEvent($comp,"",$report, $sn,
                   "$id: $comp changed from '$ofirm' to '$nfirm'", undef, $comp);
         }

	 # For 5310 Specific
	 next if (!exists($rep->{"$comp.RaidControllerStatus"}) && !exists($orep->{"$comp.RaidControllerStatus"}));
         if ($nstatus && (!exists($orep->{"$comp.RaidControllerStatus"})) ) {

	      Grid->setCode("$type.ComponentInsertEvent.controller");
	      my $part = NWS::5210->newFru($rep, $comp);	      
              $hm->insertCompEvent($comp,$physicalFrame, $report, $orep, $part, "$type.$sn.$comp", $sn);
  
         }
	 # End for 5310 specific

      }  elsif ($e =~ /logicaldrive\.(\d+)\.RaidSystemDriveRaidLevel/)  {  # Logical Drive
         
	 my $comp = "logicaldrive.$1";
	
	 my $ostatus = $orep->{"$comp.RaidSystemDriveStatus"};
	 my $nstatus = $rep->{"$comp.RaidSystemDriveStatus"}; 

         #Insert-Removal of LUNs
	 next if (!exists($rep->{"$comp.RaidSystemDriveStatus"}) && !exists($orep->{"$comp.RaidSystemDriveStatus"}));
 	 if ($ostatus eq $nstatus) {
           Grid->setCode("$type.StateChangeEvent.lun");
           my $e2 = $hm->stateEvent($comp, $report, $rep, $orep, 'CIM_Card', $nstatus, $sn);
         } else {	 
 
	   if ($nstatus && (!exists($orep->{"$comp.RaidSystemDriveStatus"})) ) {

	      Grid->setCode("$type.ComponentInsertEvent.lun");
	      my $part = NWS::5210->newLun($rep, $comp);	      
              $hm->insertCompEvent($comp,$physicalFrame, $report, $orep, $part, "$type.$sn.$comp", $sn, {logicalDevice => 1} );
  
	   }
	 }

         # RAID Status from online to offline
	 if ($ostatus && $nstatus && ($ostatus ne $nstatus)) {
              Grid->setCode("$type.StateChangeEvent.lun");
              my $e2 = $hm->stateEvent($comp, $report, $rep, $orep, 'CIM_Card', $nstatus, $sn);
         }

         # RAID Cache Policy
	 my $oraidPolicy = $orep->{"$comp.RaidSystemDriveCachePolicy"};
	 my $nraidPolicy = $rep->{"$comp.RaidSystemDriveCachePolicy"};
	 if ($oraidPolicy && $nraidPolicy && ($oraidPolicy ne $nraidPolicy)) {
            Grid->setCode("$type.AlarmEvent.RaidSystemDriveCachePolicy");
	    my $argin;
            $argin->{old_status} = $oraidPolicy;
            $argin->{new_status} = $nraidPolicy;

            $hm->mapValueChangeEvent($report, $orep, $type, $comp, "RaidSystemDriveCachePolicy", $shortid, $id,
                         $sn, "RaidSystemDriveCachePolicy", $argin);
         }

	 # Raid Level
	 my $orl = $orep->{"$comp.RaidSystemDriveRaidLevel"};
         my $nrl = $rep->{"$comp.RaidSystemDriveRaidLevel"};
 
         if ($orl && $nrl && ($orl ne $nrl)) {
            Grid->setCode("$type.AlarmEvent.raid_level");
            $hm->alarmEvent($comp,"",$report,$sn,"$id: Raid level has been changed on $comp from '$orl' to '$nrl'", undef, $comp);
         }

      }	 elsif ($e =~ /port\.(\d+)\.OperStatus/)  {  # Port
         
	 my $comp = "port.$1";
	 
	 my $ostatus = $orep->{"$comp.OperStatus"};
         my $nstatus = $rep->{"$comp.OperStatus"};
	 my $portName = $rep->{"$comp.Descr"};
 
         if ($ostatus && $nstatus && ($ostatus ne $nstatus)) {

           Grid->setCode("$type.StateChangeEvent.port");
           $hm->stateEvent($comp, $report, $rep, $orep, 'CIM_PhysicalPackage', 
                 $portName, $comp);
         } 

      }	 elsif (($e =~ /powersupply\.(\d+)\.RaidPowerSupplyStatus/) ||
                ($e =~ /powersupply\.(\d+)-(\d+)\.RaidPowerSupplyStatus/)) {  # Power Supply

         my $fid;
	 if ($2) {
	   $fid = "$1-$2"; 
	 } else {
	   $fid = $1;
	 }
	 
	 my $comp = "powersupply.$fid";
	 
	 # Right now use status, change it to serial after its available.
	 my $ostatus = $orep->{"$comp.RaidPowerSupplyStatus"};
         my $nstatus = $rep->{"$comp.RaidPowerSupplyStatus"};
 
         next if (!exists($orep->{"$comp.RaidPowerSupplyStatus"}) && !exists($rep->{"$comp.RaidPowerSupplyStatus"}));
	 if ($ostatus ne $nstatus) {

           Grid->setCode("$type.StateChangeEvent.powersupply");
           my $e2 = $hm->stateEvent($comp, $report, $rep, $orep, 'CIM_Card', "$type.$sn.$comp", $sn);
         } 
  	 if (($nstatus eq "absent") && ($ostatus eq "normal")) {  
         
	   Grid->setCode("$type.ComponentRemoveEvent.powersupply");
           my $comp_info = NWS::5210->fruKey($orep, $comp);
           $hm->removeCompEvent($comp,$physicalFrame,$report, $orep, 'CIM_PhysicalPackage',"$type.$sn.$comp", $sn, { comp_info => $comp_info });

	 }  
	 if (($ostatus eq "absent") && ($nstatus eq "normal")) {
	   
	   Grid->setCode("$type.ComponentInsertEvent.powersupply");
	   my $part = NWS::5210->newFru($rep, $comp);	      
           $hm->insertCompEvent($comp,$physicalFrame, $report, $orep, $part, undef, $sn);

	 }
	

      }  elsif (($e =~ /environment_ps\.(\d+)\.EnvPowerStatus/) ||
      	        ($e =~ /environment_ps\.(\d+)-(\d+)\.EnvPowerStatus/)) {  # Power Supply
         
         my $fid;
	 if ($2) {
	   $fid = "$1-$2"; 
	 } else {
	   $fid = $1;
	 }

	 my $comp = "environment_ps.$fid";
	 
	 # Right now use status, change it to serial after its available.
	 my $ostatus = $orep->{"$comp.EnvPowerStatus"};
         my $nstatus = $rep->{"$comp.EnvPowerStatus"};
 
         next if (!exists($orep->{"$comp.EnvPowerStatus"}) && !exists($rep->{"$comp.EnvPowerStatus"}));
	 if ($ostatus ne $nstatus) {
           Grid->setCode("$type.StateChangeEvent.env_powersupply");
           my $e2 = $hm->stateEvent($comp, $report, $rep, $orep, 'CIM_Card', "$type.$sn.$comp", $sn);
         }	 
  	 if (($nstatus eq "failed") && ($ostatus eq "normal")) {  
         
	   Grid->setCode("$type.ComponentRemoveEvent.env_powersupply");
           my $comp_info = NWS::5210->fruKey($orep, $comp);
           $hm->removeCompEvent($comp,$physicalFrame,$report, $orep, 'CIM_PhysicalPackage', "$type.$sn.$comp", $sn, { comp_info => $comp_info });
         
	 }  
	 if (($ostatus eq "failed") && ($nstatus eq "normal")) {

	   Grid->setCode("$type.ComponentInsertEvent.env_powersupply");
	   my $part = NWS::5210->newFru($rep, $comp);	      
           $hm->insertCompEvent($comp,$physicalFrame, $report, $orep, $part, undef, $sn);
  
	 }

      }  elsif (($e =~ /fan\.(\d+)\.RaidFanStatus/) ||
      		($e =~ /fan\.(\d+)-(\d+)\.RaidFanStatus/)) {  # Fan
         
         my $fid;
	 if ($2) {
	   $fid = "$1-$2"; 
	 } else {
	   $fid = $1;
	 }

	 my $comp = "fan.$fid";
	 
	 my $ostatus = $orep->{"$comp.RaidFanStatus"};
         my $nstatus = $rep->{"$comp.RaidFanStatus"};
 
         if ( $ostatus ne $nstatus) {

           Grid->setCode("$type.StateChangeEvent.fan");
           $hm->stateEvent($comp, $report, $rep, $orep, 'CIM_PhysicalPackage', 
                 "$type.$sn.$comp", $sn);
         } 

      }	 elsif (($e =~ /environment_fn\.(\d+)\.EnvFanStatus/) ||
                ($e =~ /environment_fn\.(\d+)-(\d+)\.EnvFanStatus/))  {  # Fan
         
	 my $fid;
	 if ($2) {
	   $fid = "$1-$2"; 
	 } else {
	   $fid = $1;
	 }
	 
	 my $comp = "environment_fn.$fid";
	 
	 my $ostatus = $orep->{"$comp.EnvFanStatus"};
         my $nstatus = $rep->{"$comp.EnvFanStatus"};
 
         if ( $ostatus ne $nstatus) {

           Grid->setCode("$type.StateChangeEvent.env_fan");
           $hm->stateEvent($comp, $report, $rep, $orep, 'CIM_PhysicalPackage', 
                 "$type.$sn.$comp", $sn);
         } 
      }	 
      
   }

   
   # Remove FRU's Section
   my $ntotalDiskDrive =  $rep->{"info.totalPhysicalDiskDrive"};
   foreach my $e (keys %$orep) {
       if (($ntotalDiskDrive) && ($ntotalDiskDrive ne "0")) {
         if (($e =~ /physicaldrive.(\d)-(\d+).RaidPhysicalDriveSerial/) ||
	     ($e =~ /physicaldrive.(\d)-(\d)-(\d+).RaidPhysicalDriveSerial/)) {   # PhysicalDiskDrive    


           my ($controllerID, $channelID, $targetID, $ix);
           if ($3) {
             $controllerID = $1;
 	     $channelID = $2;
             $targetID = $3;
	     $ix = $controllerID."-".$channelID ."-" .$targetID;	    	    
	   } else {
 	     $channelID = $1;
             $targetID = $2;
	     $ix = $channelID ."-" .$targetID;
	   }

           my $comp = "physicaldrive.$ix";
	   my $oserial = NWS::5210->getKey($orep, $comp);
	   #my $oserial = $orep->{"$comp.RaidPhysicalDriveSerial"};
	   my $drvstatus = $rep->{"$comp.RaidPhysicalDriveStatus"};
	   my $odrvstatus = $orep->{"$comp.RaidPhysicalDriveStatus"};


	   next if (!exists($rep->{"$comp.RaidPhysicalDriveSerial"}) && !exists($orep->{"$comp.RaidPhysicalDriveSerial"}));
	   if ($oserial && ( (!exists($rep->{"$comp.RaidPhysicalDriveSerial"})) || 
              (($odrvstatus ne 'absent') && ($drvstatus eq 'absent')) ) ) {  # For 5310
     
             # Put an additional check for time out on Disk Drives
	     if (!exists($rep->{"$comp.RaidPhysicalDriveSerial"})) {
	     	next if ($rep->{"$comp.RaidPhysicalDriveType"});
	     }
	     # End of additional check

	     Grid->setCode("$type.ComponentRemoveEvent.disk");
             my $comp_info = NWS::5210->getKey($orep, $comp);
             $hm->removeCompEvent($comp,$physicalFrame,$report, $orep, 'CIM_PhysicalPackage',$comp_info, $sn, { comp_info => $comp_info });  
	   }
	 }
       } 
       
       if ($e =~ /logicaldrive\.(\d+)\.RaidSystemDriveRaidLevel/)  {  # Logical Drive
	 
	 my $comp = "logicaldrive.$1";	
	 my $ostatus = $orep->{"$comp.RaidSystemDriveStatus"}; 

	 next if (!exists($rep->{"$comp.RaidSystemDriveStatus"}) && !exists($orep->{"$comp.RaidSystemDriveStatus"}));
	 if ($ostatus && (!exists($rep->{"$comp.RaidSystemDriveStatus"})) ) {            
     
	   Grid->setCode("$type.ComponentRemoveEvent.lun");
           my $comp_info = $orep->{"$comp.RaidSystemDriveName"}; #put this line in NWS
           $hm->removeCompEvent($comp,$physicalFrame,$report, $orep, 'CIM_PhysicalPackage',"$type.$sn.$comp", $sn, { comp_info => $comp_info });         
	 } 
       }

       # Controller remove for 5310
       if (($e =~ /controller\.(\d)\.RaidControllerFirmwareVersion/) ||
          ($e =~ /controller\.(\d)\.RaidCtlrFirmwareVersion/))  {  # Controller
	 
	 my $comp = "controller.$1";	
	 my $ostatus = $orep->{"$comp.RaidControllerStatus"}; 

	 next if (!exists($rep->{"$comp.RaidControllerStatus"}) && !exists($orep->{"$comp.RaidControllerStatus"}));
	 if ($ostatus && (!exists($rep->{"$comp.RaidControllerStatus"})) ) {            
     
	   Grid->setCode("$type.ComponentRemoveEvent.controller");
           my $comp_info = $orep->{"$comp.RaidControllerStatus"}; #put this line in NWS
           $hm->removeCompEvent($comp,$physicalFrame,$report, $orep, 'CIM_PhysicalPackage',"$type.$sn.$comp", $sn, { comp_info => $comp_info });         
	 } 
       }
       # End of Controller remove for 5310

   }

   # Partition inserts and deletes
   my($INSERTS, $DELETES, $UPDATES) = $hm->idu_map($rep, $orep, 
                                        "partition", "PartitionMountPoint");

   foreach my $el (keys %$INSERTS) {
        my $ix = $INSERTS->{$el}; # el is the _name value.
        my $comp = "$ix";
        # CREATE THE NEW FRU...
        Grid->setCode("$type.ComponentInsertEvent.partition");
        my $part = NWS::5210->newLun($rep, $comp);	
        $hm->insertCompEvent($comp,$physicalFrame, $report, $orep, $part, "$type.$sn.$comp", $sn, {logicalDevice => 1});
   }

   foreach my $el (keys %$DELETES) {
        my $ix = $DELETES->{$el}; # el is the _name value.
        my $comp = "$ix";
        # DELETE OLD FRU...
    	Grid->setCode("$type.ComponentRemoveEvent.partition");
        my $comp_info = $orep->{"$comp.PartitionMountPoint"}; #put this line in NWS
        $hm->removeCompEvent($comp,$physicalFrame,$report, $orep, 'CIM_PhysicalPackage',"$type.$sn.$comp", $sn, { comp_info => $comp_info });
   }
 
   # end of partition inserts and delete

}

sub status {
  my($hm, $rep, $orep, $comp) = @_;

  my $map = PDM->getDeviceStateMap("5210.availability");

   my($oav, $av, $sev, $act);
   my $status;
   my $ostatus;
   $sev =-9;  # default value
   if ($comp =~ /powersupply/) {
       $status  = $rep->get("$comp.RaidPowerSupplyStatus");
       $ostatus = $orep->get("$comp.RaidPowerSupplyStatus");
       ($oav, $av, $sev, $act) =  $map->transition("fru_status.$ostatus", "fru_status.$status", $orep, $rep);
       return ($ostatus, $status, $oav, $av, $sev, $act);
   } if ($comp =~ /environment_ps/) {
       $status  = $rep->get("$comp.EnvPowerStatus");
       $ostatus = $orep->get("$comp.EnvPowerStatus");
       ($oav, $av, $sev, $act) =  $map->transition("fru_status.$ostatus", "fru_status.$status", $orep, $rep);
       return ($ostatus, $status, $oav, $av, $sev, $act);
   } elsif ($comp =~ /fan/) {
       $status  = $rep->get("$comp.RaidFanStatus");
       $ostatus = $orep->get("$comp.RaidFanStatus");
       ($oav, $av, $sev, $act) =  $map->transition("fru_status.$ostatus", "fru_status.$status", $orep, $rep);
       return ($ostatus, $status, $oav, $av, $sev, $act);
   } elsif ($comp =~ /environment_fn/) {
       $status  = $rep->get("$comp.EnvFanStatus");
       $ostatus = $orep->get("$comp.EnvFanStatus");
       ($oav, $av, $sev, $act) =  $map->transition("fru_status.$ostatus", "fru_status.$status", $orep, $rep);
       return ($ostatus, $status, $oav, $av, $sev, $act);
   } elsif ($comp =~ /port/) {
       $status  = $rep->get("$comp.OperStatus");
       $ostatus = $orep->get("$comp.OperStatus");
       ($oav, $av, $sev, $act) =  $map->transition("port_status.$ostatus", "port_status.$status", $orep, $rep);
       return ($ostatus, $status, $oav, $av, $sev, $act);
   } elsif ($comp =~ /logicaldrive/) {
       $status  = $rep->get("$comp.RaidSystemDriveStatus");
       $ostatus = $orep->get("$comp.RaidSystemDriveStatus");
       ($oav, $av, $sev, $act) =  $map->transition("lun_status.$ostatus", "lun_status.$status", $orep, $rep);
       return ($ostatus, $status, $oav, $av, $sev, $act);
   } elsif ($comp =~ /physicaldrive/) {
       $status  = $rep->get("$comp.RaidPhysicalDriveStatus");
       $ostatus = $orep->get("$comp.RaidPhysicalDriveStatus");
       ($oav, $av, $sev, $act) =  $map->transition("disk_status.$ostatus", "disk_status.$status", $orep, $rep);
       return ($ostatus, $status, $oav, $av, $sev, $act);
   } elsif ($comp =~ /controller/) {
       $status  = $rep->get("$comp.RaidControllerStatus");
       $ostatus = $orep->get("$comp.RaidControllerStatus");
       ($oav, $av, $sev, $act) =  $map->transition("controller_status.$ostatus", "controller_status.$status", $orep, $rep);
       return ($ostatus, $status, $oav, $av, $sev, $act);
   }

}


1;

