package Discover::QLOGICSW;
use Agent::QLOGICSW;
use System;
use strict;
use DiscoveryObject;
use Logic::SWITCH;
use Discover;

#  $Id: QLOGICSW.pm,v 1.1 2004/12/08 20:53:12 bkeslin Exp $

sub REGISTER {
  my($class) = @_;

  return { types  => "qlogicsw",
          sysDesc => 1,
          fromIP  => 0,
          };
}

sub discoverFromSysDesc {
  my($class, $ip, $sysDesc, $args) = @_;

  if ($sysDesc =~ /switch/i || $sysDesc =~ /sanbox/i) {
     return $class->discoverFromIP($ip, $args);
  }
  return undef;
}


sub discoverFromIP {
  my($class, $ipno, $args) = @_;

  my $password = $args->{password};

  my($wwn, $type, $label) = Logic::SWITCH->find_wwn($ipno);
  my $dname = Logic::SWITCH->find_name($ipno);

  if ($type =~ /^qlogicsw/) {
    my $o = DiscoveryObject->newFromString(
       "switch.$type|$type|$ipno|$wwn|$wwn|$wwn||$dname|$label") ;
    Discover->updateTopoDevice($o);
    return [$o];
  }
  return undef;
}

1;
