package Discover::A3500FC;
use Agent::A3500FC;
use System;
use strict;
use DiscoveryObject;
use RM6;
use Discover;
use HBAApi;

sub REGISTER {
  my($class) = @_;

  return { types  => "a3500fc",
          sysDesc => 0,   # cannot use snmp
          fromIP  => 0,   # can call discoverFromIP directly
          inBand  => 1,   # inband || broadcast discovery (no ip)
    disco_level   => 2,
    merge_devices => 0, # merge proxy_ip
          };
}


#  was called get_discover
#  $q = { callback => &function }
#  callback is what saves the device discovered
#  what is returned is not used.  
#  RETURN: LIST OF DiscoveryObject(s)

sub discoverInBand {
  my($class, $q) = @_;

  my $renv = System->get_renv();
  my $rc = RM6->get_devices({});
  my @lines = split(/\n/, substr($rc, 3));
  my (@object_list);
  my $master = Util->findMaster();
  my $hname = $master ? $renv->{hostname} : "";

  foreach my $l (@lines) {
     my($name, $dev, $wwn1, $wwn2, $type) = split(/\=/, $l);
     next if (!$type);
     

     # Find Node WWN and portWWN's
     my($err, $L) = HBAApi->run1({
             cache_delay => 1,
                 command => "dis_luxadm" ,
             });
     my ($hba_list, $switch_list) = HBAApi->parse($L);
     my $portwwn;
     my $nodewwn;
     $portwwn = $wwn1;

     foreach my $hba (@$hba_list) {
        my $devs = $hba->{deviceInfo};
        foreach my $dev (@$devs) {
	    if ($wwn1 eq $dev->{uniqueName}) {
               $portwwn = $dev->{PortWWN};
	       $nodewwn = $dev->{NodeWWN};
           }
        }
     }
     my $key = "$type.$wwn1";
      #my($class,  $type, $ip, $wwn, $key, $wwn2, $ctrl0,
      #$devname, $label, $username, $host) 

     my $o = DiscoveryObject->newFromString(
                 "storage.$type|$type||$portwwn|$key|".
                 "||$name|$name||$hname");


     Discover->updateTopoDevice($o);
     push(@object_list, $o);
  }
  return \@object_list;
}


1;
