package DeviceReport::NTC;
use System;
use strict;
use DeviceReport;
use base 'DeviceReport';


# xml for GUI Interface

sub xmlSummary {
   my($class, $report, $q) = @_;

  my $rep = $report->content();
  my $summary = $q->{summary};
  my (%S);

  my $out = "<REPORT>\n";
  $out .= " <CONTENT>\n";

  my $name   = $report->id("name") ;
  my $ip     = Util->name2ip($name);
  my $hostid = $rep->{"location.hostId"};
  my $key0   = $report->id("deviceName") ;
  my $version = $rep->{"info.firmwareRevision"};

  my $state = $rep->{"info.ping"};


  $S{HEADER} =   {
                  device_key   => { order => 1 , value => $hostid },
                  device_name  => { order => 2 , value => $name   },
                  device_ip    => { order => 3 , value => $ip     },
                  status       => { order => 4 , value => $state },
		  version      => { order => 5 , value => $version},
                 };

  $S{SAN} = $class->san_info($report);

  foreach my $el (sort keys %$rep) 
  {
     my @L = split(/\./, $el);
     my $x  = "$L[0].$L[1]";
     if (!$summary) 
     {
        if ($L[0] eq "power") {
            $S{LOGICAL}{"$x"} = {  name  => "Power Supply",
                               id  => "Power $L[1]",
                            state  => $rep->{"${x}.status"},
                           status  => $rep->{"${x}.status"},
                          revision => "NA",
                          serial   => "NA",
                             type  => "power",
                         keyLabel  => "Power Supply",
                         keyValue  => $rep->{"id.wwn"} . ".$x",
                          };

        }elsif(($L[0] eq "pccard") && ($el =~ /CardType/)) {
            $S{COMPONENT}{"$x"} = {  name  => "Slot $L[1] " . $rep->{"${x}.CardType"},
                               id  => $rep->{"${x}.CardType"},
                            state  => $rep->{"${x}.ModemState"},
                           status  => $rep->{"${x}.ModemState"},
                          revision => "NA",
                          serial   => "NA",
                             type  => $rep->{"${x}.CardType"},
                         keyLabel  => $rep->{"${x}.CardType"},
                         keyValue  => $rep->{"id.wwn"} . ".$x",
                          };

        }
	
	else {
            #$S{OTHER}{$x} = 1;
        }
     } elsif (substr($el,0, length($summary)) eq $summary) {
	my $safe = Client->xmlEncode($rep->{$el});
        $out .= "   <VALUE ID=\"$el\">$safe</VALUE>\n";
     }
  }

  if (!$summary) {
    $out .= DeviceReport->xml(\%S, "ID,SYSTEM");
  }
  $out .= " </CONTENT>\n";
  $out .= "</REPORT>\n";
  return (\%S, $out);
}



1;
