package DeviceReport::HBASWITCH;
use strict;

use DeviceReport::COMMON;
use base 'DeviceReport::COMMON';

sub fruList  { "" }
sub compList { "fcport" }


#--------------------------------------------
#  fruList(): return a list of the sections of 
#  the instrumentation_report that shoud be in
#  the FRU section.
#--------------------------------------------


sub xmlHeader {
  my($class, $rep) = @_;
  my $name = $rep->{'info.InterLogicalName'};
  my $key  = $rep->{'info.InterNodeWWN'};
  return  {
      device_name            => {order => 1, value => $name },
      device_key             => {order => 3, value => $key  },
      device_ip              => {order => 4, value => $rep->{'info.IPAddress'} },
      system_revision        => {order => 5, value => $rep->{"fru.0._Firmware"}},
      model                  => {order => 6, value => $rep->{"fru.0._Model"}},
      vendor                 => {order => 6, value => $rep->{"fru.0._Vendor"}},
      port_count             => {order => 6, value => $rep->{"fcport.count"} },
      };
}



1;
