package DeviceReport::D2;
use System;
use strict;
use DeviceReport;
use base 'DeviceReport';


sub xmlSummary {
  my($class, $report, $q) = @_;

  my $summary = $q->{summary}; # summary
  my $rep = $report->content();

  my $normal  = $q->{normal};  # normalized
  my (%S, %VD);
  my $out = "<REPORT>\n";
  $out .= " <CONTENT>\n";

  $S{HEADER} = {
      device_name            => {order => 1, value => $rep->{'id.device_name'} },
      device_type            => {order => 2, value => $rep->{'id.device_type'} },
      device_key             => {order => 3, value => $rep->{'id.device_key'}  },
      device_path            => {order => 4, value => $rep->{'id.device_wwn'}  },
  };
  $S{SAN} = $class->san_info($report);


  foreach my $el (sort keys %$rep) {
       my @L = split(/\./, $el);
       my $k = "$L[0].$L[1]";
       if (!$summary) {
          if ( $L[0] eq "esm" && $L[2] eq "frutype") {

              $S{FRU}{$k}            = { name    => $k,
                                           id    => $k,
                                         state   => "",
                                         status  => "",
                                         type    => $rep->{"$k.frutype"},
                                         revision=> $rep->{"$k.revision"},
                                           model => $rep->{"$k.product"},
                                           vendor=> $rep->{"$k.vendor"},
                                          serial => $rep->{"$k.product"} . "-" . $rep->{"$k.serial"},
                                         keyLabel=> "serial",
                                         keyValue=> $rep->{"$k.serial"},
                                       };

          } elsif ( $L[0] eq "midplane" && $L[1] eq "frutype") {

              $S{FRU}{"midplane"}    = { name    => "midplane",
                                           id    => "midplane",
                                         state   => "",
                                         status  => "",
                                         type    => $rep->{"midplane.frutype"},
                                         revision=> $rep->{"midplane.date"},
                                           model => $rep->{"midplane.product"},
                                           vendor=> $rep->{"midplane.vendor"},
                                          serial => $rep->{"midplane.product"} . "-" . $rep->{"midplane.serial"},
                                         keyLabel=> "serial",
                                         keyValue=> $rep->{"$k.serial"},
                                       };

          } elsif ( ($L[0] eq "power" || $L[0] eq "fan") && $L[2] eq "status") {
	      my $avail = "Not Installed" if
	               ( ($rep->{$el} =~ /not_present/)||( $rep->{$el} =~ /not installed/));

				 ($rep->{"$k.RaidPowerSupplyStatus"} eq "absent"); 
              $S{FRU}{$k}            = { name    => $k,
                                           id    => $k,
                                         state   => "",
                                         status  => $rep->{$el},
                                         type    => $L[0],
                                         revision=> "",
                                           model => "",
                                           vendor=> "",
                                          serial => "",
			            availability => $avail,
                                       };

          } elsif ($L[0] eq "slot" && $L[3] eq "status") {
              $k= "$L[0].$L[1].$L[2]";
	      my $namek = sprintf("disk.%2.2d", $L[2]);
	      my $avail = "Not Installed" if($rep->{$el} =~ /drive_removed/);

              $S{FRU}{$k}            = { name    => $namek,
                                           id    => $k,
                                         state   => "",
                                         status  => $rep->{"$k.status"},
                                         type    => "disk",
                                          vendor => $rep->{"$k.vendor"},
                                         revision=> $rep->{"$k.revision"},
                                           model => $rep->{"$k.vendor"} . "." . $rep->{"$k.model"},
                                          serial => $rep->{"$k.serial"},
                                         keyLabel=> "serial",
                                         keyValue=> $rep->{"$k.serial"},
					 availability => $avail,

                                       };


          } elsif ($L[0] eq "info") {
              $S{SYSTEM}{$k} = { value => $rep->{$el} };

          } elsif ($L[0] eq "id") {
              $S{ID}{$k} =  { value => $rep->{$el} };

          } else {
              #$S{OTHER}{"$L[0].$L[1]"} = 1;
          }
       } elsif (substr($el,0, length($summary)) eq $summary) {
          $out .= "   <VALUE ID=\"$el\">$rep->{$el}</VALUE>\n";
       }
  }

  if (!$summary) {
    $out .= DeviceReport->xml(\%S, "ID,SYSTEM");
  }

  $out .= " </CONTENT>\n";
  $out .= "</REPORT>\n";
  return (\%S, $out);
}




1;
