package DeviceReport::5210;
use System;
use strict;
use DeviceReport;
use base 'DeviceReport';

   
# no $q->{summary}                    # only frus,vols, system, id
# $q->{summary} = "controller.u1ctr." # this controller
# $q->{summary} = "controller."       # all controllers
# Main sections:
# <FRU> <LOGICAL> <SYSTEM> <ID>

sub xmlSummary {
  my($class, $report, $q) = @_;

  my $summary = $q->{summary}; # summary
  my $rep = $report->content();

  my $normal  = $q->{normal};  # normalized
  my (%S, %VD);
  my $fru_list  = ",fan,physicaldrive,powersupply,environment_fn,environment_ps,controller,";
  my $comp_list = ",processor,battery,channel,environment_ts,port,thermalsensor,mirror,ups,";
  my $logical   = ",logicaldrive,partition,";
  my $out = "<REPORT>\n";
  $out .= " <CONTENT>\n";
  my $cnt = 0;
 
  $S{SAN} = $class->san_info($report);
  
  $S{HEADER} = {
      device_name            => {order => 1, value => $rep->{'id.device_name'}},
      device_type            => {order => 2, value => $rep->{'id.device_type'}},
      device_key             => {order => 3, value => $rep->{'id.device_key'}},
      device_ip              => {order => 4, value => $rep->{'id.ipno'}},
      communication_status   => {order => 5,
                             value => ($report->{_status} eq "CC") ? "Management-Path Lost!" : "OK"},      
  };

  # get the disks in the volume first
  foreach my $el (sort keys %$rep) {
       my @L = split(/\./, $el);
       my $k = "$L[0].$L[1]";

       if (!$summary) {
          if ($L[0] eq "physicaldrive" && $L[2] eq "RaidPhysicalDriveLunName")  {
              $VD{$rep->{$el}} .= $L[1] . ",";
          }
       }
  }


 
  foreach my $el (sort keys %$rep) {

       my @L = split(/\./, $el);

       #next if (index($el, "fruDiskPerf") >= 0);
       if (!$summary) {
          if (index($fru_list, ",$L[0],") >= 0) {                        
              my $k = "$L[0].$L[1]";
	      my $value = "$L[2]";
	      
	      if ($L[0] eq "physicaldrive") {
	      	      $S{FRU}{$k} = { 		 
	      			name    => $k,
                                  id    => $k,
                                state   => $rep->{"$k.RaidPhysicalDriveStatus"},
                                status  => $rep->{"$k.RaidPhysicalDriveStatus"},
                                type    => $rep->{"$k.RaidPhysicalDriveType"},
                               revision => $rep->{"$k.RaidPhysDriveFwRevision"},
                                  model => $rep->{"$k.RaidPhysicalDriveModel"},
                                 vendor => $rep->{"$k.RaidPhysicalDriveVendor"},
                                 serial => $rep->{"$k.RaidPhysicalDriveSerial"},
                                 keyLabel=> "serialno",
                                 keyValue=> $rep->{"$k.RaidPhysicalDriveSerial"},
              	      };                                     
	      } elsif ($L[0] eq "powersupply") {
	              my $avail = "Not Installed" if 
				 ($rep->{"$k.RaidPowerSupplyStatus"} eq "absent");  

	              $S{FRU}{$k} = { 		 
	      			name    => $k,
                                  id    => $k,
                                state   => $rep->{"$k.RaidPowerSupplyStatus"},
                                status  => $rep->{"$k.RaidPowerSupplyStatus"},
                                type    => "JBOD Power Supply",
                               revision => "-",
                                  model => "-",
                                 vendor => "-",
                                 serial => "-",
                                keyLabel=> "componentid",
                                keyValue=> $k,
			   availability => $avail,
              	      }; 
	      
	      } elsif ($L[0] eq "fan") {
	              $S{FRU}{$k} = { 		 
	      			name    => $k,
                                  id    => $k,
                                state   => $rep->{"$k.RaidFanStatus"},
                                status  => $rep->{"$k.RaidFanStatus"},
                                type    => "JBOD Fan",
                               revision => "-",
                                  model => "-",
                                 vendor => "-",
                                 serial => "-",
                                keyLabel=> "componentid",
                                keyValue=> $k,
              	      }; 
	      
	      } elsif ($L[0] eq "environment_ps") {	        
		next if ($L[1] eq "EnvPowerCount"); 	              		
		      
		      my $avail = "Not Installed" if 
				 ($rep->{"$k.EnvPowerStatus"} eq "failed"); 
		      
		      $S{FRU}{$k} = { 		 
	      			name    => $k,
                                  id    => $k,
                                state   => $rep->{"$k.EnvPowerStatus"},
                                status  => $rep->{"$k.EnvPowerStatus"},
                                type    => "NAS Head Power Supply",
                               revision => "-",
                                  model => "-",
                                 vendor => "-",
                                 serial => "-",
                                keyLabel=> "componentid",
                                keyValue=> $k,
			   availability => $avail,
              	      }; 
	      
	      } elsif ($L[0] eq "environment_fn") {
	        next if ($L[1] eq "EnvFanCount");
	              $S{FRU}{$k} = { 		 
	      			name    => $k,
                                  id    => $k,
                                state   => $rep->{"$k.EnvFanStatus"},
                                status  => $rep->{"$k.EnvFanStatus"},
                                type    => "NAS Head Fan",
                               revision => "-",
                                  model => "-",
                                 vendor => "-",
                                 serial => "-",
                                keyLabel=> "componentid",
                                keyValue=> $k,
              	      }; 
	      
	      } elsif ($L[0] eq "controller") {
	              $S{FRU}{$k} = { 		 
	      			name    => $k,
                                  id    => $k,
                                state   => $rep->{"$k.RaidControllerStatus"},
                                status  => $rep->{"$k.RaidControllerStatus"},
                                type    => "RAID Controller",
                               revision => $rep->{"$k.RaidCtlrFirmwareVersion"},
                                  model => $rep->{"$k.RaidControllerModel"},
                                 vendor => $rep->{"$k.RaidControllerVendor"},
                                 serial => $rep->{"id.device_key"},
                                keyLabel=> "componentid",
                                keyValue=> $k,

              	      }; 
	      
	      } 
          } elsif (index($comp_list, ",$L[0],") >= 0) {                        
              my $k = "$L[0].$L[1]";
	      my $value = "$L[2]";

	      if ($L[0] eq "processor") {
			$S{COMPONENT}{$k} = {    
	                         name => $k,
                                   id => $k,
                               state  => "-",
                               status => "-",
                             revision => "-",
                             keyLabel => "componentid",
                             keyValue => $k,
                                 type => $rep->{"$k.ProcessorType"},
                               serial => "-",
                         };
	       }  elsif ($L[0] eq "battery") {
			$S{COMPONENT}{$k} = {    
	                         name => $k,
                                   id => $k,
                               state  => $rep->{"$k.RaidBBUStatus"},
                               status => $rep->{"$k.RaidBBUStatus"},
                             revision => "-",
                             keyLabel => "componentid",
                             keyValue => $k,
                                 type => $rep->{"$k.RaidBatteryType"},
                               serial => "-",
                         };
	       }  elsif ($L[0] eq "channel") {
			$S{COMPONENT}{$k} = {    
	                         name => $k,
                                   id => $k,
                               state  => "-",
                               status => "-",
                             revision => "-",
                             keyLabel => "componentid",
                             keyValue => $k,
                                 type => "Channel",
                               serial => "-",
                         };
	       }  elsif ($L[0] eq "port") {
	          my $name = $rep->{"$k.Descr"};
		  next if ($name =~ /lo0/);
		  next if (!$name); 
			$S{COMPONENT}{$k} = {    
	                         name => $name,
                                   id => $k,
                               state  => $rep->{"$k.OperStatus"},
                               status => $rep->{"$k.OperStatus"},
                             revision => "-",
                             keyLabel => "componentid",
                             keyValue => $k,
                                 type => $rep->{"$k.Type"},
                               serial => "-",
                         };
	       }  elsif ($L[0] eq "environment_ts") {
			$S{COMPONENT}{$k} = {    
	                         name => $k,
                                   id => $k,
                               state  => "-",
                               status => "-",
                             revision => "-",
                             keyLabel => "componentid",
                             keyValue => $k,
                                 type => "JBOD Temperature Sensor",
                               serial => "-",
                         };
	       }  elsif ($L[0] eq "thermalsensor") {
			$S{COMPONENT}{$k} = {    
	                         name => $k,
                                   id => $k,
                               state  => $rep->{"$k.RaidThermalSensorStatus"},
                               status => $rep->{"$k.RaidThermalSensorStatus"},
                             revision => "-",
                             keyLabel => "componentid",
                             keyValue => $k,
                                 type => "NAS Head Temperature Sensor",
                               serial => "-",
                         };
	       }  elsif ($L[0] eq "mirror") {
			$S{COMPONENT}{$k} = {    
	                         name => $k,
                                   id => $k,
                               state  => $rep->{"$k.MirrorStatus"},
                               status => $rep->{"$k.MirrorStatus"},
                             revision => "-",
                             keyLabel => "componentid",
                             keyValue => $k,
                                 type => "Mirroring",
                               serial => "-",
                         };
	       } elsif ($L[0] eq "ups") {
			my $k = "ups";
			
			$S{COMPONENT}{$k} = {    
	                         name => $k,
                                   id => $k,
                               state  => $rep->{"$k.UpsStatus"},
                               status => $rep->{"$k.UpsStatus"},
                             revision => "-",
                             keyLabel => "componentid",
                             keyValue => $k,
                                 type => "External Uninterruptible Power Supply",
                               serial => "-",
                         };
	       }                               
          } elsif (index($logical, ",$L[0],") >= 0) {                        
              my $k = "$L[0].$L[1]";
	      my $value = "$L[2]";
	      
	      if ($L[0] eq "logicaldrive") {

	              # do we have disks associated with this volume?
              	      my $disks;
              	      foreach my $v (sort keys %VD) {
                	my $volumeName = $rep->{"$k.RaidSystemDriveName"};
	                if ($volumeName eq $v) {
	                  $disks = $VD{$v};
	                }
	              }
	      		      
		      $S{LOGICAL}{$k} =  { 
		                   name    => $rep->{"$k.RaidSystemDriveName"}, 
                                    id     => $k,
                                  type     => "LUN",
                                  state    => $rep->{"$k.RaidSystemDriveStatus"},
                                 status    => $rep->{"$k.RaidSystemDriveStatus"},
                                 raidLevel => $rep->{"$k.RaidSystemDriveRaidLevel"},
                                  capacity => $rep->{"$k.RaidSystemDriveSize"},
                                     disks => $disks,
                      };
	      } elsif ($L[0] eq "partition") {

      		      $S{LOGICAL}{$k} =  { 
		                   name    => $rep->{"$k.PartitionMountPoint"}, 
                                    id     => $k,
                                  type     => $rep->{"$k.PartitionFSType"},
                                  state    => $rep->{"$k.PartitionMode"},
                                 status    => $rep->{"$k.PartitionMode"},
                                  capacity => $rep->{"$k.PartitionSize"},
                      };
	      }                                     

          } elsif ($L[0] eq "info") {
              my $x = "$L[0].$L[1]";
              $S{SYSTEM}{$x} = { value => $rep->{$el} };

          } elsif ($L[0] eq "id") {
              my $x = "$L[0].$L[1]";
              $S{ID}{$x} = { value => $rep->{$el} };

          } else {
              #$S{OTHER}{"$L[0]"} = { "$L[1]" => $rep->{$el} };
          }
       } elsif (substr($el,0, length($summary)) eq $summary) {
          $out .= "   <VALUE ID=\"$el\">$rep->{$el}</VALUE>\n";
       }
  }
  if (!$summary) {
    $out .= DeviceReport->xml(\%S, "ID,SYSTEM");
  }

  $out .= " </CONTENT>\n";
  $out .= "</REPORT>\n";
  return (\%S, $out);
}

1;

