package COMMON;
use System;
use strict;


sub fruMap {
  my($class, $rep) = @_;

  my (%FRU);
  foreach my $el (sort keys %$rep) {
       my @L = split(/\./, $el);
       my $k = "$L[0].$L[1]";
       if ($L[0] eq "fru" && $L[2] eq "_Key") {
          $FRU{$rep->{$el}} = {
                            _id   => $L[1],
                            type  => $rep->{"$k._Type"},
                          vendor  => Util->trim($rep->{"$k._Vendor"}),
                          model   => $rep->{"$k._Model"},
                          serial  => $rep->{"$k._SerialNumber"},
                          fwRev   => $rep->{"$k._Firmware"},
                          hwRev   => $rep->{"$k._Model"},
                              };
       }
  }
  return \%FRU;
}

# List the volumes in the report
sub volumeMap {
  my($class, $rep) = @_;

  my (%VOLUME);
  foreach my $el (sort keys %$rep) {
       my @L = split(/\./, $el);
       my $k = "$L[0].$L[1]";
       if ($L[0] eq "volume" && $L[2] eq "_DeviceID") {
          $VOLUME{$rep->{$el}} = {
                              idx  => $L[1],
                         deviceID  => $rep->{"$k._DeviceID"},
                              name => $rep->{"$k._Name"},
#                            source => $rep->{"$k._SourcePool"},
                            source => $rep->{"$k._SourceVdisk"},
                        blockCount => $rep->{"$k._NumberOfBlocks"},
                         blockSize => $rep->{"$k._BlockSize"},
                                 };
       }
  }
  return \%VOLUME;
}

1;
