package Tests::Brocade;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use strict;
use base "Tests";
use Tests::General;
use PDM::ConfigFile;

#
# brocadetest
# preform executes right before the form is displayed, 
# used to set field values.
#
sub brocadetest_preForm {
  my($class, $command, $to, $node, $q) = @_;
  my($err, $t);
  my $config = PDM::ConfigFile->read();
  
  my $key = $node->key();
  my $dev = $config->deviceByKey($key);

  if (!$dev) {
     $err .= "Cannot find ($key) in Config. ";
     return ($err);
  }
  if($dev->{userLabel} =~ /^4100/){
    $err .= "Diags are not supported on this switch.\n";
    return ($err);

  }
  my $pass = $class->getPassword($dev, \$err , 'brocade');

  my(%DATA) = ('#PASSWD' =>  $pass);

  my($gen_err, $get_data) = Tests::General->preForm($command,$to, $node, $q);

  $err .= $gen_err if ($gen_err);

  return ($err, \%DATA);
}

#
# runs after the used submit the test form
# used to validate the test, refuse to run it etc..
#
sub brocadetest_postForm {
  my($class, $command, $to, $node, $q) = @_;
  my($t, $err);
  my $config = PDM::ConfigFile->read();
  my $key = $node->key();

  my $dev = $config->deviceByKey($key);

  if (!$dev) {
     $err .= "Cannot find ($key) in Config. ";
     return ($err);
  }
  if($dev->{userLabel} =~ /^4100/){
    $err .= "Diags are not supported on this switch.\n";
    return ($err);

  }

  if (($t = $class->testRunning("*", $key))) {
     return "A test on $key already exists";
  }

  if ($q->{"opt_passwd"} eq "#PASSWD" ) {
     $err .= "Must enter a valid password to run this test.";
  }
  

  return $err;
}



1;
