package TO::QLOGICSW;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2004, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use strict;
use TO;
use TO::FCSWITCH;
use base 'TO::FCSWITCH';

sub leaf { 1 }
sub type { "qlogicsw"};

sub getDevStatus {
  my($class, $dev) = @_;
  require Agent::QLOGICSW;
  return Agent::QLOGICSW->getDevStatus($dev);
}

sub getLocalPortWWN {
  my($class, $V, $dev, $x) = @_;
  return sprintf("20%2.2x%s", $x, substr($dev->{wwn},4));
}

sub getZones {
   my($class, $dev, $ZO) = @_;
   my $ip = $dev->{ipno};
   my($renv) = System->get_renv();
   my($TO) = $renv->{'timeout.snmp'} || 10;
   require Agent::QLOGICSW;
   my $err = Agent::QLOGICSW->getZones(System->get_home() . "/sbin", $ip, $TO, $ZO, $dev);
}



sub statusFunc {
  my($class, $name, $State, $arg, $node) = @_;

  my $Comp = $State->components($name);
  my $i = $Comp->value("e");
  my $enc = $i->[0];
  my $encInfo = $i->[1];
  my ($disk, $diskInfo, @t1, @f1, @p1, $x);
  my($other, $otherInfo);

  $Comp->other([], \$other, \$otherInfo);

  my($port, $portInfo);
  my $pi = $node->portInfo();

  for ($x=0; $x <= $#$pi; $x++) {
       $port     .=  $Comp->value("port.$x*",0) . ",";
       $portInfo .=  $Comp->value("port.$x*",1) . ",";
  }

  return ($enc, $port, $disk, $other, $encInfo,
          $portInfo, $diskInfo, $otherInfo);

}



1;

