package TO::BROCADE;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use strict;
use TO;
use TO::FCSWITCH;
use base 'TO::FCSWITCH';

sub type {"brocade"}
sub leaf { 1 }

sub getDevStatus {
   my($class, $dev) = @_;
   require Agent::BROCADE;
   return Agent::BROCADE->getDevStatus($dev);
}
sub getLocalPortWWN {
   my($class, $V, $dev, $x) = @_;
   return sprintf("20%2.2x%s", $x, substr($dev->{wwn},4));
}

sub getZones {
   my($class, $dev, $ZO) = @_;
   my $ip = $dev->{ip};
   my($renv) = System->get_renv();
   my($TO) = $renv->{'timeout.snmp'} || 30;

   require Agent::BROCADE;
   my $err = Agent::BROCADE->getZones(System->get_home() . "/sbin", $ip, $TO, $ZO, $dev);
   if($err){
      $err .= " in Agent::BROCADE->getZones on IP($ip)\n";
   }
   return $err;
}


sub statusFunc {
  my($class, $name, $State, $arg, $node) = @_;

  my $Comp = $State->components($name);
  my $i = $Comp->value("e");
  my $enc = $i->[0];
  my $encInfo = $i->[1];
  my ($disk, $diskInfo, @t1, @f1, @p1, $x);

  my ($other, $otherInfo);
  $Comp->other([], \$other, \$otherInfo);

  my($port, $portInfo);
  my $pi = $node->portInfo();

  for ($x=0; $x <= $#$pi; $x++) {
       my $p1 = $Comp->value("port.$x");
       my $p2 = $Comp->value("port.$x.statistics");
       $port     .= TO->val($p1->[0], $p2->[0]) . ",";
       $portInfo .= TO->val2(1,$p1, $p2) . "," ;
  }

  return ($enc, $port, $disk, $other, $encInfo,
          $portInfo, $diskInfo, $otherInfo);

}

sub iconLayout {
  my($sw, $orient) = @_;
  return "F0D8D8/brocade.gif,_,,$orient" ; # ,h = horiz switch
}





1;
