package Revision::SAMFS;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Id: SAMFS.pm,v 1.3 2005/10/20 20:21:17 mckenney Exp $
use strict;
use base 'Revision';
use System;
use Util;
use Agent;
use Agent::SAMFS;
use PDM::ConfigFile;
use Report;

#
#  PASS, LOW, HIGH, NI (not installed), ERR

sub description {"Sun SAM-QFS Patches and Device Firmware"}
sub class {"oob.SAMFS"}
sub type {"samfs"}

sub RUN {
  my($class, $Matrix, $InstalledPatches) = @_;
  my $rc2 = $class->checkSAMlevels($Matrix, $InstalledPatches);
  return $rc2;
}

sub checkSAMlevels {
   my($class, $Matrix, $InstalledP) = @_;
   my $samMatrix = $Matrix->{SAMFS};
   my $category = "SAM-QFS";
   my $key;
   my @L;
   my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
   my $found =0;
   my $sam_info;
   my $err;
   my $sam_name;
   my $rev_found;
   foreach my $dev (@$devs){
      if ( $dev->{type} =~ /samfs/) {
         $found =1;
	 $rev_found = 0;
         $sam_name = $dev->{name};
         ($err, $sam_info) = Revision::SAMFS->getSamInfo($dev);
         if ($err == 1) {
            my $info = " Could not get data from SAM-QFS FM API.";
            push(@L, [$category, $sam_name,'ERR',undef, undef,undef,undef,$info]);
            next;
         } elsif ($err == 2){
              my $info = " Only local SAM-QFS Version 4.2 and higher support revision checking.";
              push(@L, [$category, $sam_name,'PASS','N/A','N/A','N/A','N/A',$info]);
              next;
         } else {
            foreach my $e (sort keys %$sam_info) {
               if ($e =~ /samfm.devent.(\d+).name/) { 
	          $rev_found = 1;
                  my $no = $1;
                  my $deviceNumber = "samfm.devent.$no";
                  $key = $sam_info->{"samfm.devent.$no.product"};
                  $key =~ s/\s+$//;
                  my $name = $sam_info->{"samfm.devent.$no.name"};
                  my $device = $samMatrix->{$key};
                  my $req_fw = $device->[0];
                  my $curr_fw = $sam_info->{"samfm.devent.$no.revision"};
                  $curr_fw =~ s/\s+$//;
                  if (!$curr_fw) {
                     push(@L, [$name, "SAM-QFS.$key",'ERR','N/A','N/A',undef,undef,"Can not get the firmware revision."]);
                  }

                  my $comp;
                  $comp = $class->compareFwLevels($curr_fw, $req_fw);
                  if ( $comp==0) {
                     push(@L, ["SAM-QFS $key", $name, 'PASS',$curr_fw, $req_fw,'N/A','N/A',undef]);
                  }
                  elsif ($comp>0) {
                     push(@L, ["SAM-QFS $key", $name, 'UPREV',$curr_fw, $req_fw,'N/A','N/A',undef]);
                  }
                  elsif ($comp<0){
                     push(@L, ["SAM-QFS $key", $name, 'DOWNREV',$curr_fw, $req_fw,"N/A","N/A","No patch available, please contact your SUN representative"]);
                  }
               } # end if name
            } # END THE LOOP HERE
	    if($rev_found == 0){
	       my $info = " Didn't detect the SAM-QFS hardware devices. Ensure devices are working correctly.";
               push(@L, [$category, $sam_name,'ERR','N/A','N/A','N/A','N/A',$info]);
	    }
	       
         }# if else ERR
      } # if samfs
   } #for each device
   if ($found == 0)
   {
      push(@L, [$category, 'N/A', 'ERR', undef, undef,undef,undef, "No SAM-QFS are present, please check system"]);
   }

return \@L; 
}
 
sub getSamInfo {
   my ($class, $dev) = @_;
   my $sys_report=  {};

   my $local_ip = Util->name2ip();
   my $samfs_ip = $dev->{ipno};
   if ($local_ip eq $samfs_ip) {
      my $package_v = System->getPackageInfo("", "SUNWsamfsr", "VERSION");
      if ($package_v !~ /^4.1/) {
         my $prefix     = "";
         my $array_list = ",devent,ident_data";
         my $word_map = { "samfs" => "CAPACITY" };
         $ENV{LD_LIBRARY_PATH} = "/opt/SUNWsamfs/lib";
         my($command) = "/opt/SUNWsamfs/sbin/samstorade";
         my ($err, $lines) = Util->run_command("$command");
         # remove the first 2 lines until xml2report undertands them.
         $lines->[0] = "";
         $lines->[1] = "";
         my $error = Report->xml2report( $sys_report, "@$lines", $prefix, 
                                    $array_list, $word_map);
     }else {
        return ("2", $sys_report);              
     }
   }else {
      return ("2", $sys_report); 
   }

   if (%$sys_report) {
      return ("", $sys_report);
   }else {
      return ("1", $sys_report);
   }
}

1;

