package Revision::A3500;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use strict;
use base 'Revision';
use System;
use Util;

#
#  PASS, LOW, HIGH, NI (not installed), ERR

sub description {"Sun StorEdge A3500FC Patches and Disk Firmware"}
sub class {"host.driver"}
sub type {"a3500fc"}

sub RUN {
  my($class, $Matrix, $InstalledPatches) = @_;
  my($rc, $L);
  if ($class->a3500Present()) {
    $rc = $class->checkHostPatch('STORAGE_PATCH', 'A3500', $Matrix,  $InstalledPatches);
  } 

  my $rc2 = $class->checkDiskFirmware_3500($Matrix, $InstalledPatches);
  my $rc1 = $class->checkFirmware_3500($Matrix, $InstalledPatches);
  if ( $rc ) {
    return [@$rc, @$rc2, @$rc1];
  } else {
    return [@$rc2, @$rc1];
  }
}

sub checkDiskFirmware_3500 {
        my($class, $Matrix, $InstalledP) = @_;
        my($line, @L);

        my $di = $class->runDiskInquiry(0);
        my $disk_fw = $Matrix->{A3500FC};
        my $category = "A3500FC_Product_Revision";
        my $found=0;
        my $desc ="Please contact your SUN representative";
        foreach $line (@$di) {
            next if ($line !~ /A3500/);
            $found =1;
            my($dev,$vp,$vp2) = split(/\t+/,Util->ltrim($line));
            my($vendor,$prod) = split(/\s+/,$vp,2);
            my($curr_fw,$serial) = split(/\s+/,$vp2,2);
            $prod = Util->rtrim($prod);
            my $key ="ctrl";
         
            if ($disk_fw->{$key}) {
                 my $d = $disk_fw->{$key};
                 my $req_fw = $d->[0];
		 		 
		 my $comp = $class->compareDiskFwLevels($curr_fw, $req_fw);
                 if ( $comp ==0) {
                     push(@L, [$category, $dev,'PASS',$curr_fw, $req_fw,undef,undef,undef]);
                 }
                 if ( $comp >0) {
                     push(@L, [$category, $dev,'UPREV',$curr_fw, $req_fw,undef,undef,undef]);
                 }
                 elsif ( $comp <0){
                     push(@L, [$category, $dev,'DOWNREV',$curr_fw, $req_fw,undef,undef,$desc]);
                 }
            } else {
              push(@L, [$category, $dev, 'INFO', undef, undef,undef,undef, "No Key in Matrix/DISK_FW"]);
            }
       }
       if ($found==0)
       {
           push(@L, [$category, 'N/A', 'ERR', undef, undef,undef,undef, "No A3500FC device are present, please check system "]);
       }
       return \@L;
}


sub checkFirmware_3500{
        my($class, $Matrix, $InstalledP) = @_;
        my ($line, @L);
        my $category = " A3500FC_Firmware";
        my $key ="firm";
        my $disk_fw = $Matrix->{A3500FC};
        my $d = $disk_fw->{$key};
        my $req_fw = $d->[0];
	my $req_patch = $d->[1];
        # my($err, $com) = Util->run_command("/usr/lib/osa/bin/lad","lad_temp.txt");
        my $di = $class->runDiskInquiry(0);
        foreach $line (@$di) {
                      next if ($line !~ /A3500/);
                      my ($ctd_dev, $restpart) = split(/\t+/,Util->ltrim($line));
                      my($err1, $result) = Util->run_command("/usr/lib/osa/bin/raidutil -c $ctd_dev -i", "raid_temp.txt");
                      my $l;
                      if ( $err1){
                         push(@L, [$category, 'N/A', 'ERR', undef, undef,undef,undef, "Can not run /usr/lib/osa/bin/raid util cmd, please install SUNWosar package or contact your SUN representative"]);
                      }
                      foreach $l (@$result) {
                             next if ( $l !~ /Firmware Level/) ;
                             my ( $tem1, $tem2, $curr_fw ) = split (/\s+/, $l);
                             my ( $comp) = $class->compareFwLevels($curr_fw, $req_fw);

                             if ( $comp ==0) {
                                   push(@L, [$category, $ctd_dev,'PASS',$curr_fw, $req_fw,undef,undef,undef]);
                             } elsif ( $comp >0) {
                                   push(@L, [$category, $ctd_dev,'UPREV',$curr_fw, $req_fw,undef,undef,undef]);
                             } elsif ( $comp <0){
                                   push(@L, [$category, $ctd_dev,'DOWNREV',$curr_fw, $req_fw,undef,$req_patch,"please check SUNWosar package installed and use Raid Manager 6 to update the firmware, or contact your SUN representative"]);
                             }
                      }
        }
        return \@L;
}


1;


