package Reports::Event;
use strict;
use vars qw($ERR);

sub new {
  my($class, $new, $arg) = @_;
  my ($REP, $out, @LIST);
  
  my $filename = $arg->{filename} || "event_report";
  my $F  = "/tmp/$filename";
  my $F1 = System->get_home() . "/DATA/$F";
  
  if (!$new) {
     $REP = Util->deserialize($F);
     return $REP;
  }
  unlink $F1;
  $ERR = ""; 
  my (%R, $l);
  open(W, ">" . System->get_home() . "/DATA/tmp/Events.log1");
  foreach my $FILE ('Events.log','Events.log.2','Events.log.3') {
    if (open(O, System->get_home(). "/DATA/$FILE")) {
      $R{action} = $arg->{actionable};
      while ($l = <O>) {
        chop($l);
        next if (substr($l,0,1) eq "L");
        my($dt, $event, $comp, $desc, $sev, $action, $enc) = split(/\t/, $l);
        next if ($dt !~ /^\d\d\d\d/);
        next if (substr($action,0,7) ne "Action:");
        next if ($arg->{actionable} && $action ne "Action:TRUE");
        $sev = substr($sev,4);
        my $ix = index($event,".");
        my $type = substr($event,0,$ix);
        next if (!$type);
        my $date = substr($dt,0,8); # yyyymmdd
        my $mth  = substr($dt,0,4) . "-" . substr($dt,4,2);
        my $hour = substr($dt,8,2); # hhmmss
        my ($jd, $dow) = Util->julian(substr($dt,0,4), substr($dt,4,2), substr($dt,6,2));
        my($sun_y,$sun_m, $sun_d) = Util->findSunday($jd);
        my $sunday = sprintf("%4.4d-%2.2d-%2.2d", $sun_y, $sun_m, $sun_d);
        $enc       = substr($enc, 4);

        $R{ym}{"$mth\t$type\t$sev"}++;
        $R{yweek}{"$sunday\t$type\t$sev"}++;
        $R{dow}{"$dow\t$type\t$sev"}++;
        print W "$l\tDow:$dow\tYweek:$sunday\n";
      }
      close(O); 
    }
  }
  close(W);
  $REP = \%R;
  bless($REP, 'Reports::Event');
  Util->serialize($F, \%R);
  return $REP;
}

sub log1 {
  my($l) = @_;
  open(OO1, ">>/tmp/ev"); print OO1 "$l\n"; close(OO1);
}


sub ymd {
  my($class, $arg) = @_;
  return $class->any_report($arg, "ym");
}
sub week {
  my($class, $arg) = @_;
  return $class->any_report($arg, "yweek");
}

sub dow {
  my($class, $arg) = @_;
  return $class->any_report($arg, "dow");
}

sub any_report {
  my($class, $arg, $subreport) = @_;
  my $interactive = $arg->{interactive};
  my $map         = $arg->{map};

  my $Y = $class->{$subreport};
  my %R1;
  foreach my $el (sort keys %$Y) {
     my($date, $type, $sev) = split(/\t/, $el);
     my $cnt = $Y->{$el};
     my @v0;
     $v0[$sev] = $cnt;
     my $r1 = $R1{"$date\t$type"};
     $R1{"$date\t$type"} = [$r1->[0] + $v0[0], $r1->[1] + $v0[1], $r1->[2] + $v0[2],
                            $r1->[3] + $v0[3] ];
  }
  my (@O, $i, @S, @T);
  foreach my $el (sort keys %R1) {
     my($ym, $type) = split(/\t/, $el);
     my $c = $R1{$el};
     for ($i=0; $i <= 3; $i++) {
         if ($c->[$i]) {
           my $v  = sprintf("%5d", $c->[$i]);
           my $v1 = sprintf("%5.5d", $c->[$i]);
           if ($arg->{interactive}) {
             $S[$i] = "<a href=\"javascript:openw('V=$v1&$subreport=$ym&type=$type&sev=$i')\">$v</a>";
           } else {
             $S[$i] = $v;
           }
         } else {
           $S[$i] = "";
         }
         $T[$i] += $c->[$i];
     }
     $ym .= " " . $map->{$ym} if ($map);
     push(@O, [$type , $ym, $S[0], $S[1], $S[2], $S[3]]);
  }
  return (\@O, \@T);
}



1;
  




