package Perf;

use strict;

sub new {
  my $perf ={};
  bless($perf, "Perf");
  return $perf;
}

sub getDate {
  my($class, $name) = @_;
  my $date = Util->get_file_created(System->get_home() ."/DATA/Perf/$name");
  return $date;
}

sub read {
  my($class, $name) = @_;

  my $DIR = System->get_home() . "/DATA/Perf";
  mkdir $DIR ,0777 if (!-d $DIR);

  my $stat1 = Util->deserialize("Perf/$name") || {};
  bless($stat1, "Perf");
  return $stat1;
}


sub cleanOld {
  my($stat, $old_jd) = @_;
  my $cnt; 
  foreach my $el (keys %$stat) {
     my @a = split(/\./, $el);
     if ($a[0] < $old_jd) {
        delete $stat->{$el};
        $cnt++;
     }
  }
  return $cnt;
}

# only keep the current day
sub cleanHours {
  my($stat) = @_;

  my $today = Util->get_today();
  my $day =  substr($today,5,5);
  my $hour = substr($today,11,2);
  
  foreach my $el (keys %$stat) {
   my $oday = substr($el,5,5);
   my $ohour = substr($el,11,2);

   if (($ohour eq $hour) && ($oday ne $day)) {      
      delete $stat->{$el};
   }
  }
}

sub write {
  my($stat, $name) = @_;

  Util->serialize("Perf/$name", $stat);
}


1;
