package NWS::Host;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name: bld60_020 $ 
#  $Id: Host.pm,v 1.5 2004/09/13 18:26:25 ccadieux Exp $

use Agent;
use Report;
use CIM::Instance;
use Data::Dumper;
use strict;
use Ilist;
use PDM;
use NWS;
sub revision {'$Revision: 1.5 $'}

sub newSystem {
  my ($class, $rep1) = @_;

  my($rep) = Agent->hostInfo();
  my($renv) = System->get_renv();
  my $wwn =  $rep->{hostid}   ;

  my($p1) = CIM::Instance->new('NWS_Host',[
                    [Name 		  => $rep->{hostid}     ],
                    [OtherIdentifyingInfo => ""], 
                    [HostId 		  => $rep->{hostid}    ],
                    [SolutionModel        => $renv->{solution_model}   ],
                    [SysRevision          => $rep->{os}        ],
                    [Caption              => "Host"            ],
                    [IP                   => $rep->{ip}        ],
                    [HostName             => $rep->{hostname}  ],
                    [CPUCount             => $rep->{cpus}  ],
                    [MemorySize           => $rep->{memory}    ],
                    [Domain               => $rep->{domain}    ],
                    [HostInfo             => $rep->{hostinfo}  ],
                    [Model                => $rep->{model}     ],
                ]);

  my($p2) = CIM::Instance->new('CIM_OperatingSystem', [
                    [CSName 	 => $rep->{hostid}      ],
                    [Name   	 => $rep->{hostid}      ],
                    [OS          => $rep->{os}          ],
                    [Version     => $rep->{os_version}  ],
                    [CurrentTimeZone    => $rep->{tz}   ],
                    [TotalSwapSpaceSize => $rep->{swap} ],
                ]);
  my($site) = NWS->location($rep1, "NWS_Site");
 
  my($hostsite) = CIM::Instance->new('NWS_HostOnSite', [
                  [Host  => $p1],
                  [Site  => $site],
                  ]);
  

  my($a1) = CIM::Instance->new('CIM_RunningOS', [
                  [Dependent    => $p1],
                  [Antecedent   => $p2],
                  ]);

  my(@pil) = ($p1, $p2, $a1, $site, $hostsite);

# ADD HBA INFO FROM $REP1
#
  if (exists $rep1->{"hba.count"}) {
    my $p2 = CIM::Instance->new('CIM_PhysicalFrame', [
               [Tag          => $wwn],
               [Name         => $wwn],
               ]);

    my $a2 = CIM::Instance->new('CIM_ComputerSystemPackage', [
               [Antecedent   => $p1],
               [Dependent    => $p2],
               ]);
    push(@pil, $p2, $a2);


    my $PORTS = $rep1->{"hba.count"};
    my($i);
    for ($i = 0; $i < $PORTS; $i++) {
      next if (!$rep1->get("hba.$i.adapter_DriverName"));

      my $dd = $class->newHBA($rep1, "hba.$i");
      $a = CIM::Instance->new('CIM_Container', [
                   [GroupComponent          => $p2],
                   [PartComponent           => $dd->[1]],
                   [LocationWithinContainer => "hba.$i"],
                   ]);
      push (@pil, @$dd);
      push (@pil, $a);
    }
  }

  return Ilist->new(\@pil);

}


sub newHBA {
  my($class, $rep, $cd, $no) = @_;
  my(@il, $p1, $c1, $a1);

  my $status    = $rep->get("$cd.PortState");
  my $serial_no = $rep->get("$cd.NodeWWN");

  my $map    = PDM->getDeviceStateMap("host.availability");
  my $state  = $map->get("hbaStatus.$status");

  $p1 = CIM::Instance->new('NWS_HBA',  [
             [SystemName   => $rep->get("$cd.adapter_DriverName") ],
             [DeviceID     => $serial_no ],
             [Name         => $serial_no ],
             [StatusInfo   => $status],
             [Status       => $state ],
             [NodeWWN      => $rep->get("$cd.NodeWWN")   ],
             [PortWWN      => $rep->get("$cd.PortWWN")   ],
             [Speed        => $rep->get("$cd.PortSpeed") ],
             [Path         => $rep->get("$cd.path")      ],
             [FabricName   => $rep->get("$cd.FabricName")      ],
             [DriverVersion=> $rep->get("$cd.adapter_DriverVersion")   ],
           [FirmwareVersion=> $rep->get("$cd.adapter_FirmwareVersion") ],
             [Vendor       => $rep->get("$cd.adapter_Manufacture") ],
             [Model        => $rep->get("$cd.adapter_Model") ],
             [Serial       => $rep->get("$cd.adapter_SerialNumber") ],
               ]);

  push(@il,$p1);

  $c1 = CIM::Instance->new('CIM_Card', [
            [Removable        => "Yes"],
            [Replaceable      => "Yes"],
            [Tag              => $serial_no],
            [Name             => $serial_no],
            [SerialNumber     => $serial_no],
                    ]);

  push(@il, $c1);
  $a1 = CIM::Instance->new('CIM_Realizes', [
                [Antecedent => $c1],
                [Dependent => $p1],
                    ]);

  push(@il,$a1);

  return Ilist->new(\@il);

}



1;
