package NWS;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name: bld60_020 $ 
#  $Id: NWS.pm,v 1.3 2004/12/15 23:36:06 jkremer Exp $

use Util;
use System;
use CIM::Instance;
use strict;

use System;
use NWS::Schema;

use vars qw(%MAP);

%MAP = (S => 'string', B => 'boolean', I => 'uint32', I64 => 'uint32', E => 'uint32', D => 'datetime', R => 'reference');

sub check_type {
  my($class, $type) = @_;
  return (index(",boolean,string,char16,uint8,sint8,uint16,sint16,uint32,sint32,uint64,sint64,datetime,real32,real64,", ",$type,") >= 0) ;
}


sub cim_today {
  my($class) = @_;
  return System->cim_today;
}

sub todayValue {
  my($class, $date) = @_ ;
  return  CIM::Value->new(Value => System->cim_today, Type => 'datetime');
}


sub location {
  my($class, $rep, $cim) = @_;
  my($l1);

  $cim = "NWS_Location" if (!$cim);
  my $renv = System->get_renv();
  my $name = $renv->{customer} || System->hostname();
  if ($rep && $rep->get("location.customerName")){
	 $name = $rep->get("location.customerName");
  }

  $l1 = CIM::Instance->new($cim, [
                  [Name                 => $name                 ],
                  [PhysicalPosition     => System->hostid()      ],
                  [CustomerNo           => $renv->{cust_no}       ],
                  [ContractNo           => $renv->{contract}      ],
                  [SiteName             => $renv->{site_name}     ],
                  [SiteAddress          => $renv->{site_address}  ],
                  [SiteAddress2         => $renv->{site_address2}  ],
                  [SiteCity             => $renv->{site_city}     ],
                  [SiteState            => $renv->{site_state}    ],
                  [SiteCountry          => $renv->{site_country}  ],
                  [SiteZip              => $renv->{site_zip}      ],
                  [SiteContact          => $renv->{site_contact}  ],
                  [SiteEmail            => $renv->{site_email}    ],
                  [Ticker               => $renv->{ticker}        ],
                  [Production           => $renv->{production}    ],
                  [Model                => $renv->{solution_model}   ],
                  [Frequency            => $renv->{frequency}        ],
                  [Role                 => $renv->{role}          ],
                  [SA_Version           => $renv->{version}       ],
                  ]);

  return $l1;
}


1;
