package MaxEvents;
use System;
use Util;
use RasDB;
use strict;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>
#
# THe MaxEvents module is responsible for not repeating the same events
# more that X times per period . 
#  Current Default: 4 events per 24 hours.
# the period is increased by 6 hours every time the maximum is hit.
# the counters are reset after 5 days of inactivity.
#
#  $Id: MaxEvents.pm,v 1.8 2005/07/25 05:35:00 ccadieux Exp $

use vars qw ($MAX $MAX_DB);


sub clean {
  my($object) = @_;
  $MAX_DB = RasDB->new("MAXEVENTS");
  $MAX = $MAX_DB->hash();

  my $today = int(time / 60);
  $MAX_DB->Lock();

  foreach my $el (keys %$MAX) {
     my $val = $MAX->{$el};
     my $last = $val->[5] > $val->[1] ? $val->[5] : $val->[1];
     if ($today - $last > (7 * 24 * 60)) {   # clear 7 days with no activity
        delete $MAX->{$el};
     }
  }
  $MAX_DB->UnLock();
}

sub clear {
  my($class, $type) = @_;

  $MAX_DB = RasDB->new("MAXEVENTS");
  $MAX = $MAX_DB->hash();

  $MAX_DB->Lock();
  foreach my $el (keys %$MAX) {
     my($el_type, $rest) = split(/\:/, $el, 2);
     if ($el_type eq $type) {
        delete $MAX->{$el};
     }
  }
  $MAX_DB->UnLock();
}

sub delete {
   unlink System->get_home() . "/DATA/MAXEVENTS.db";
   unlink System->get_home() . "/DATA/MAXEVENTS.db.lock";
}
  


# if actionable ==1 , only count actionable events
sub maxEvents {
  my($object, $type, $ev, $user, $max, $hours) = @_;

  $MAX_DB = RasDB->new("MAXEVENTS");
  $MAX = $MAX_DB->hash();
  my $renv = System->get_renv();
  return (0,0) if ($renv->{send_all_events});

  $user =~ s/\:/_/g if ($user);
  return (0,0) if (System->get_eventMaxOff());

  my $target  = $ev->value('Target');
  my $et      = $ev->value('EventType');
  my $caption = $ev->value('Component') || $ev->value('Caption') || $et;
  my $act     = $ev->value('Severity');

  return (0,0) if ($et =~ /RegistrationEvent/);

  $hours = 24 if (!$hours);
  my $last_email;

  my $caption0 = $caption;
  if (substr($target,0,5) eq "host:" && index($caption, "lun.") >= 0) {
     $caption0 = "lun";

  } elsif (substr($caption0,0,2) eq "M." ||
           substr($caption0,0,2) eq "P." ||
           substr($caption0,0,2) eq "X.") {
     $caption0 = substr($caption0,2);
  }
  my $email_key = "$type:$user:$target:$caption0:$act"; # separate count for actionable and non-act.

  my $inc;
  if ($max) {
    $MAX_DB->Lock();
    my $today = int(time / 60);
    my $max1 = [];
    if ( exists($MAX->{$email_key}) ) {
       $max1 = $MAX->{$email_key};
       my $hours2 = $hours + $max1->[4];
       $inc = $max1->[4];
       # LAST ONE COUNTED WAS TOO FAR IN THE PAST, RESET:
       if ($today - $max1->[1] > ($hours2 * 60)) {  # compare to last counted event.
          if ($today - $max1->[5] < 4*60) {         # activity in the last 4 hours
             $max1->[4] += $hours;                  # increase the window.
          } else {
             $max1->[4] = 0;
          }
          $last_email = $max1->[0] if ($max1->[0] > 1);
          $max1->[0] = 0;
          $max1->[3] = 0;
          $max1->[5] = 0;

       # WINDOW HAS PASSWD AND THE MAX WAS NOT HIT YET: Events are coming in too slowly
       } elsif ($today - $max1->[3] > ($hours2 * 60) && ($max1->[0] < $max)) {  
          $max1->[0] = 0;                      # compare to first event
          $max1->[3] = 0;
          $max1->[4] = 0;                      # remove window-increment.
          $max1->[5] = 0;

       } elsif ($max1->[0] == $max-1) {
         $last_email = 1;
         $max1->[2] = Util->get_today();       # END OF WINDOW

       } elsif ( $max1->[0] >= $max) {  # INC counter, no DATA change
         $max1->[0]++;
         $max1->[5] = $today;                  # DATE OF LAST UN-COUNTED EVENT
         $MAX->{$email_key} = $max1;
         $MAX_DB->UnLock();
         return (1, 0, $inc);
       }
    }
    $max1->[1] = $today;                       # DATE OF LAST COUNTED EVENT
    $max1->[3] = $today if (!$max1->[3]);      # START OF WINDOW
    $max1->[0]++;
    $MAX->{$email_key} = $max1;
    $MAX_DB->UnLock();
  }
  return (0,$last_email, $inc);
}


1;
  

