package Health::Switch2;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name: bld60_020 $ 
#  $Id: Switch2.pm,v 1.9 2005/05/19 16:01:40 mckenney Exp $


use base 'Health';
use NWS::Switch2;
use Ilist;
use Message;
use Report;
use Catalog;
use Events;
use strict;
use Debug;

sub revision {'$Revision: 1.9 $'}

sub type { "switch2" }


sub all_logic {
  my($hm, $report) = @_;
  my($ev, $ed, $pertains, $x ,$y, $contain, $sd);
  my($orep, $key);
  my($rep)     = $report->content;
  my($oreport) = PDM->getOldReport($report->fileKey);
  my($ip)      = $report->id('ip');
  my($name)    = $report->name;
  my $wwn      = $report->id('deviceName');
  my($id)      = $report->id('display');
  my($log)     = $report->log();
  my $type     = $hm->type();
  if (!$wwn) {
    Debug->errNoRepeat(T3_NO_KEY => $ip, 24, "Switch ($name/$ip) cannot be identified");
     return;
  }

  CIM->version("1.1");
  $DB::single = 1;

  return if ($hm->connectionEvent($wwn, $report, {method => 2, threshold_severity => 1} ));
  my $freq  = System->get_renv()->{audit_freq} || 7;
  my $audit = System->get_audit() ? "YES" : Timer->isXdays("Audit$wwn", $freq);

  if (!$oreport || $audit eq "YES" ) {
     # new Switch or audit time.
     my($etype) = $audit eq "YES" ? "$type.AuditEvent" : "$type.DiscoveryEvent";
     my($title) = $audit eq "YES" ? "Auditing a":"Discovered a new";
     my($dt)    = "A" if (!$audit);
     Grid->setCode($etype);
     $ev = CIM::Instance->new('NWS_Event', [
                  [ EventType   => $etype ],
                  [ Target      => "$type:$wwn" ],
                  [ TargetName  => $id  ],
                  [ SourceIP    => $ip  ],
                  [ EventId     => PDM->getEventSequence  ],
                  [ Description => "$title Switch called $id"],
                  [ Data        => $hm->serial($rep) ],
                         ]);

     $sd = Events->sourceDetector({ event => $ev , host => 1, rep => $rep});
      
     my($p) = NWS::Switch2->newSystem($rep);

     $pertains = CIM::Instance->new('NWS_EventPertainsToSystem', [
                  [ Event       => $ev  ],
                  [ Element     => $p->[0] ],
                  [ DiscoveryType => $dt],
                    ]);

     my($monitors) = CIM::Instance->new('NWS_AgentMonitors', [
                  [ Agent       => $sd->[0]  ],
                  [ Element     => $p->[0] ],
                    ]);

     $ed = Message->new( { id        => $report->id,
                            instances => [$ev, @$sd,  @$p, $monitors, $pertains ],
                            severity  => Message::SEVERITY_NORMAL });

     PDM->saveMessage($ed);
  }

  
  my($PORTS) = $rep->get('port.count');
  $orep = ($oreport)? $oreport->content() : $rep; # same report if new disco.



#
# check sensors for changes
#
  my( $status, $ostatus, $val, $oval);
  for ($x=1; $x <= 20; $x++) {
    next if (!$rep->get("sensor.board.$x.status"));
    Grid->setCode("$type.AlarmEvent.chassis.board");
    $hm->mapValueChangeEvent($report, $orep, uc($type), "sensor.board.$x", "status", $id, $id, $wwn, "sensor.board.status");
  }

  my($userlabel)      = $report->value('id.device_userLabel');
  my $loop_count = 10;

  if($userlabel =~ /Switch2/){
     if($PORTS == 8){
        # 2 Gig 8 port switches don't have 2 fans/power supplies. Even though
	# snmp queries indicate so.
        $loop_count = 1;
     }
  }


  foreach my $el ('fan','power-supply') {
    if ($el eq "fan") {
      Grid->setCode("$type.AlarmEvent.chassis.fan"); 
    } else {
      Grid->setCode("$type.AlarmEvent.chassis.power"); 
    }
    for ($x=1; $x <= $loop_count; $x++) {
      next if (!$rep->get("sensor.$el.$x.status"));
      $hm->mapValueChangeEvent($report, $orep, uc($type), "sensor.$el.$x", "status", $id, "sensor.$el.$x", $wwn, "sensor.$el.status");
    }
  }





  return if (!$oreport);

  $hm->locationChangeEvent($report, $rep, $orep, $wwn);

  my($physicalFrame) = CIM::Key->new( ['CIM_PhysicalFrame',   # key of the frame
                        Tag               => $rep->get("id.wwn") ,
                        CreationClassName => 'CIM_PhysicalFrame' ]);

  $hm->fcEvent($rep->{FC_COUNTERS}, $orep->{FC_COUNTERS});


  my($comp);
  for ($x=0; $x <= $PORTS; $x++) {
     $comp = "port.$x"; # . sprintf("%3.3d", $x);
     Grid->setCode("$type.StateChangeEvent.port");
     my $extra;
     if (exists $rep->{"$comp.state.AdmStatus"}) {
     	$extra = "Admin-Status is '" . $rep->{"$comp.state.AdmStatus"} . "' use to be '" . $orep->{"$comp.state.AdmStatus"} . "'";
     }

     $hm->stateChangeEvent($comp, 'status', $report, $rep, $orep, 'CIM_Card', "$wwn.$comp", $wwn,
                   {info => $extra});
  }


  # Check counter values
  Grid->setCode("$type.AlarmEvent.port.statistics");
  $hm->portStatEvents($report, $PORTS, $rep, $orep);

  # Check switch up time
  my($olduptime) = $orep->get("system.uptime");
  my($newuptime) = $rep->get("system.uptime");
  if ($olduptime > $newuptime) {
     if($olduptime < 4286304000){
       # this isn't within a day of a counter wrap so report change
       Grid->setCode("$type.AlarmEvent.system_reboot"); # fan,power
       $hm->valueChangeEvent("system.uptime", "", $report, $wwn, "Switch uptime decreased on $id from $olduptime to $newuptime", 1, "system_reboot");
     }
  }



}

  
sub status {
   my($hm, $rep, $orep, $comp) = @_;
   my $type = $hm->type();
   my($map) = PDM->getDeviceStateMap("$type.availability");

   my $ostate  = $orep->getState("$comp.state");
   my $state   = $rep->getState("$comp.state");

   my $admin = $rep->getState("$comp.state.AdmStatus");
   my $oadmin = $orep->getState("$comp.state.AdmStatus");

   $state = $ostate if ($state eq '[undefined]');
   $admin = $oadmin if ($admin eq '[undefined]');

   my ($old, $new, $sev, $act) = $map->transition("state.${ostate}_${oadmin}", "state.${state}_${admin}", $orep, $rep);

   return ($ostate, $state, $old, $new, $sev, $act );

}



1;

