package Health::Message;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name: bld60_020 $ 
#  $Id: Message.pm,v 1.8 2005/03/29 17:45:09 edunning Exp $

use Health;
use base 'Health';
use Ilist;
use DevDB;
use Grid;
use Message;
use Report;
use Catalog;
use Events;
use strict;
use Debug;

sub revision {'$Revision: 1.8 $'}


sub all_logic {
  my($hm, $report) = @_;

  my $hostid   =  $report->deviceName(); 
  my($log)     = $report->log();
  my($logErr)  = $report->logError();
  my $rep      = $report->content();
  my $renv     = System->get_renv();
  my $Config   = PDM::ConfigFile->read();
  my($id)      = $report->id('display');
  my $event_name  = "LogEvent";
  $DB::single = 1;
  my @broke_list;
  my $HOST = $renv->{solution} eq "N" ? "host" : "sp";

# $log->[2]{key}{name}
# $log->[2]{key}{line}

  my($id_ip, $id_cat, $id_dev, $id_disp) = ($report->{_value}{'id.ipno'},
                                            $report->{_id}{category},
                                            $report->{_id}{deviceName},
                                            $report->{_id}{display});
  my %DONE ;
  if ($log) {  # so far, just t3/t4 messages;
    foreach my $sev0 (0,1,2,3) {
      my $el = $log->[$sev0];
      foreach my $target (keys %$el) {
         my $text   = $el->{$target}{line};
         my $disp   = $el->{$target}{name};
         my $count  = $el->{$target}{count};
         my $sev = $sev0;
         # INFORMATIONAL ONLY EVENT IF {total} is present and <= 0
         $sev = 0 if (exists $el->{$target}{total} && $el->{$target}{total} <= 0);

         my $ip     = $el->{$target}{ip};
         my $egrid  = $el->{$target}{egrid};
         my $priority= $el->{$target}{priority};
         my $policy;
         $policy = $el->{$target}{section} if ($renv->{fsa_debug});
         my $action = $el->{$target}{action};
         my $label  = $sev == 1 ? "device_warning" : ($sev == 2 ? "device_error": "device_notice");
         my($target0, $rest) = split(/\t/, $target);
         my ($t1, $wwn, $comp) = split(/\:/, $target0); # caption may say PATH
         my $caption = "M.$comp" if ($comp);
         $report->{_value}{'id.ipno'} = $ip;
         $report->{_id}{category}  = $t1;
         $report->{_id}{deviceName}= $target =~ /HOST/ ? $renv->{hostname} : $wwn;
         $report->{_id}{display}   = $disp;
         my $ix = index($text, "\n");
         my $extra = $ix > 0 ? substr($text,0,$ix) : substr($text,0,60);
         $report->{_value}{"id.mgmtLevel"} = $renv->{solution} =~ /^se/ ? "C" : "D"; # BUG
         my ($problo, $dev);
         my $lf = "logfile " . $report->id("logFile");
         if ($target =~ /HOST/) {
           $hostid = $report->{_id}{deviceName} = $renv->{hostname} if ($renv->{solution} eq "N");
           $report->{_id}{category}  = $HOST;
           $report->{_id}{display}   = "";

           Grid->setCode("$HOST.$event_name.$label");
           $hm->logEvent($text, $report, $hostid, 
             "$count ${label}(s) found in $lf on $id $policy: $extra:", $sev, $label, 
                  {actionable => $action} );

         } else {
           $report->{_id}{deviceName} = $wwn;
           ($dev, $problo) = &problem($t1, $wwn, $Config);
           if ($sev && $dev && !$DONE{$dev->{key}}) {
             push(@broke_list, $dev);
             $DONE{$dev->{key}} = 1;
           }
           # EGRID t3.LogEvent.t3_warning;
           # EGRID t3.LogEvent.t3_error;
           Grid->setCode("$t1.$event_name.$egrid");

           my $devdb = DevDB->read($wwn);
           my $tz = $devdb->{TimeZone};
           $tz = "(TimeZone $tz)" if ($tz);
           
           $hm->logEvent($text, $report, $wwn, 
                         "$count ${label}(s) found in $lf $problo $policy: $tz$extra:",
                          $sev, $caption || $label, 
                         {      egrid => $egrid, 
                           event_name => $event_name,
                           priority   => $priority, 
                            component => $comp, 
                           actionable => $action ,
                         });
         }
         $report->{_value}{'id.ipno'} = $id_ip;
         $report->{_id}{category}     = $id_cat;
         $report->{_id}{deviceName}   = $id_dev;
         $report->{_id}{display}      = $id_disp;
      }
    }
  }

  my $cnt;
  my $sev = 0;  # 0,1,2 => NOTICE, WARN, ERR
  foreach my $el ('notices', 'warnings', 'errors') {
    if (exists($rep->{$el})) {
      my $WARN = $rep->{$el};
      foreach my $cat0 (keys %$WARN) {
        next if ($cat0 =~ /^TOTAL-/);
        my($type, $enc, $cat) = split(/\:/, $cat0); # t3:key:mess_cat  or  DRIVER::mess_cat
        my ($dev, $target);
$DB::single=1;
        if (!$enc) {
           $enc = $hostid;
           $report->{_id}{category} = $HOST;
           Grid->setCode("$HOST.LogEvent.driver.$cat");
           push(@broke_list, PDM::ConfigFile->hostAsDevice($renv))
                  if ($sev && !$DONE{$renv->{hostname}});
           $DONE{$renv->{hostname}} = 1;
        } else {
           ($dev, $target) = &problem($type, $enc, $Config);
           push(@broke_list, $dev) if ($sev && $dev && !$DONE{$dev->{key}});
           $DONE{$dev->{key}} = 1;
           $report->{_id}{category} = $type;
           $report->{_id}{deviceName}= $enc;
           $report->{_id}{display}   = $dev->{name} || $enc;
           Grid->setCode("$type.LogEvent.driver.$cat");
        }
  
        my $data = $WARN->{$cat0};
        $cnt = $WARN->{"TOTAL-$cat0"};
        my $lf = "logfile " . $report->id("logFile");
        # EGRID host.LogEvent.driver.SSD_WARN
        # EGRID a5k.LogEvent.driver.SSD_WARN
        # EGRID t3.LogEvent.driver.SSD_WARN
     
        if ($cnt == 1) {
           $data =~ s/\tWWN:\t/ /;
           $data =~ s/\t/, /g;
           $hm->logEvent("", $report, $enc, 
                "Found in $lf on $id $target: $data", $sev, "driver.$cat");
        } else {
           $hm->logEvent($data, $report, $enc, 
               "Found $cnt 'driver.$cat' ${el}(s) in $lf on $id $target:", $sev, "driver.$cat");
        }
        $report->{_value}{'id.ipno'} = $id_ip;
        $report->{_id}{category}     = $id_cat;
        $report->{_id}{deviceName}   = $id_dev;
        $report->{_id}{display}      = $id_disp;
      }
    }
    $sev++;
  }
  $report->{_value}{'id.ipno'} = $id_ip;
  $report->{_id}{category}     = $id_cat;
  $report->{_id}{deviceName}   = $id_dev;
  $report->{_id}{display}      = $id_disp;
  
  return \@broke_list;
}

sub problem {
   my($type, $enc, $Config) = @_;
   my $d1 = $Config->deviceByKey($enc);
   if ($d1) {
     return ($d1, "(related to $type $d1->{name}/$d1->{ipno})");
   } else {
     return (undef, "(related to $type:$enc)");
   }
}
1;
