package Health::HBASwitch;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name: bld60_020 $ 
#  $Id: HBASwitch.pm,v 1.9 2005/05/10 21:40:50 mckenney Exp $


use base 'Health';
use NWS::HBASwitch;
use Ilist;
use Message;
use Catalog;
use Report;
use Events;
use strict;
use Debug;
sub revision {'$Revision: 1.9 $'}


sub all_logic {
  my($hm, $report) = @_;
  # Disable HBAswitch notifications for now.
  return;
  my($orep, $comp);
  $DB::single = 1;
  my $rep      = $report->content;
  my $oreport  = PDM->getOldReport($report->fileKey() );
  my $wwn      = $rep->{'id.device_key'};
  my $Config   = System->get_Config();

  my $id       = $report->id("display");
  CIM->version("1.1");
  my $type     = $report->id('category');
  my $shortid  = $report->name();

  my $freq  = System->get_renv()->{audit_freq} || 7;
  my $audit = System->get_audit() ? "YES" : Timer->isXdays("Audit$wwn", $freq);

  my $orep = $oreport->content() if ($oreport);

  my (@OLD_SWITCH, @NEW_SWITCH, %OLD_WWN, %NEW_WWN, $s);

#
# SAVE AN ARRAY OR REPORTS FOR NEW AND OLD REPORTS
# SAVE A HASH OF SWITCH WWN.
#
  foreach my $el (keys %$rep) {
      if ($el =~ /^switch\.(\d+)\.(.+)/) {
        $NEW_SWITCH[$1]{$2} = $rep->{$el};
      }
      if ($el =~ /^switch\.(\d+)\.info\.InterNodeWWN/) {
         my $ix = $1;
         my $wwn = $rep->{$el};
         $NEW_WWN{$wwn} = $ix;
      }
  }

  foreach my $el (keys %$orep) {
      if ($el =~ /^switch\.(\d+)\.(.+)/) {
        $OLD_SWITCH[$1]{$2} = $orep->{$el};
      }
      if ($el =~ /^switch\.(\d+)\.info\.InterNodeWWN/) {
         my $ix = $1;
         my $wwn = $rep->{$el};
         $OLD_WWN{$wwn} = $ix;
      }
  }

  for ($s=0; $s <= $#OLD_SWITCH; $s++) {
    my $sw = $OLD_SWITCH[$s];
    my $wwn = $sw->{'info.InterNodeWWN'};
    my $status = exists $NEW_WWN{$wwn} ? "OK" : "CC";
    my $report = Report->new($hm->id($sw), $OLD_SWITCH[$s], [], $status);

    $hm->connectionEvent($wwn, $report, {method => 1, threshold_severity => 0});
  }

  for ($s=0; $s <= $#NEW_SWITCH; $s++) {
    my $sw = $NEW_SWITCH[$s];
    my $wwn = $sw->{'info.InterNodeWWN'};
    # Don't monitor if device is in config file.
    # next if ($Config->deviceByKey($wwn));

    my $id = $sw->{'fru.0._Model'} . "/" . $sw->{'info.InterLogicalName'};
    my $report = Report->new($hm->id($sw), $NEW_SWITCH[$s], [], "OK");

    if (!exists($OLD_WWN{$wwn})) {  # added a switch (Discovery)
        $hm->discoveryEvent($report, "NWS::HBASwitch", 0);

    } else {
       my ($audit);
       if (($audit=$hm->auditTime($wwn)) eq "YES") {
         $hm->discoveryEvent($report, "NWS::HBASwitch", $audit);
       }
       # audit and changes in port WWN/revision/PortType
       my $old_sw = $OLD_SWITCH[$OLD_WWN{$wwn}];
       next if (!$old_sw);

       my $old_rev = $old_sw->{'fru.0._Firmware'};
       my $new_rev = $sw->{'fru.0._Firmware'};
       if ($new_rev && $new_rev ne $old_rev) {
           Grid->setCode("hbaswitch.AlarmEvent.revision");
           $hm->valueChangeEvent("fru.0", "", $report, $wwn,
                   "Revision of switch $id changed from '$old_rev' to '$new_rev'", 
                   1, "revision");
       }

       my $count = $sw->{'fcport.count'};
       my($p);
       for ($p=0; $p < $count; $p++) {
       }
    } 
  }
}

sub id {
  my($hm, $sw) = @_;

  my $name                = $sw->{'info.InterLogicalName'};
  my $wwn                 = "IB" . $sw->{'info.InterNodeWWN'};
  my $ip                  = $sw->{'info.IPAddress'};

  $sw->{'id.wwn'}         = $wwn;
  $sw->{'id.device_type'} = "hbaswitch";
  $sw->{'id.name'}        = $name;
  $sw->{'id.ip'}          = $ip;
  $sw->{'id.device_ipno'} = $ip;

  return { 
              deviceName =>  $wwn,
              name       =>  $name,
              category   => "hbaswitch",
              display    => "$name($ip)",
          };
}

1;
