package Discover::HBAApi;
use System;
use strict;
use DiscoveryObject;
use HBAApi;
use Discover;
#
#  Used for dis_hba, dis_luxadm and dis_devinfo
#

sub REGISTER {
  my($class) = @_;

  return { types  => "ALL",
          sysDesc => 0,
          fromIP  => 0,
          inBand  => 3,   # inband | broadcast | hba_api
     disco_level  => 0,
         };
}


# USED TO DISCOVER:
#  -  THE HOST (HBAS).
#  -  THE DEVICES ATTACHED (they are direct attached at this point).
#  -  THE SWITCHES.
#
sub discoverInBand {
  my($class, $q) = @_;

  my($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
  my $hostname = $renv->{hostname};
  $DB::single=1;

  my($hba_list, $switch_list) = HBAApi->run({ disco_level => $q->{disco_level}} );

#
# GET SWITCH IP
#
  my($list);
  Discover->updateTopoInterconnects($switch_list);
  foreach my $sw (@$switch_list) {
    my $ip = $sw->{info}{IPAddress};
    if ($ip) {
      if (index($list, "$ip,") < 0 ){
        $list .= "$ip,";
      }
    }
  }



#
#  GET HBA-DEVICE IP
#
  foreach my $hba (@$hba_list) {
    my $devs = $hba->{deviceInfo};
    foreach my $d (@$devs) {
      my $ip = $d->{IPAddress};
      if ($ip) {
        if (index($list, "$ip,") < 0 ){
          $list .= "$ip,";
        }
      }
      $ip = $d->{RackIPAddress};
      if ($ip) {
        if (index($list, "$ip,") < 0 ){
          $list .= "$ip,";
        }
      }
    }
  }
  chop($list) if ($list);

  my(@LIST);
  if ($q->{disco_level} > 0 ) {
    foreach my $ip (split(/,/, $list) ) {
       Debug->print2("");
       Debug->print2("HBAApi::discoverInBand: calling Discover->fromIP($ip)");
       my $disco_list = Discover->fromIP($ip);
       if ($#$disco_list >= 0) {
         push(@LIST, @$disco_list);
       } else {
         Debug->print2("  - Cannot identify $ip");   
       }
    }
  }

  Discover->updateTopoHost($hba_list);

  return \@LIST;
}



1;
