package Discover::D2;
use Agent::D2;
use System;
use strict;
use DiscoveryObject;
use RM6;
use Discover;

sub REGISTER {
  my($class) = @_;

  return { types  => "d2",
          sysDesc => 0,   # cannot use snmp
          fromIP  => 0,   # can call discoverFromIP directly
          inBand  => 1,   # inband || broadcast discovery (no ip)
    disco_level   => 2,
    merge_devices => 0, # merge proxy_ip
          };
}


#  was called get_discover
#  $q = { callback => &function }
#  callback is what saves the device discovered
#  what is returned is not used.  
#  RETURN: LIST OF DiscoveryObject(s)

sub discoverInBand {
  my($class, $q) = @_;

  my $renv = System->get_renv();
  my $hash = $class->get_Devices();

  my (@object_list);

  foreach my $key (keys %$hash) {
     my($path1, $path2) = split(/\|/, $hash->{$key});

     my $o = DiscoveryObject->new( { 
                             devname => $key, 
			     name    => $key,
                             wwn     => $path1,
                             wwn2    => $path2,
                             key     => $key,
                             type    => 'd2', 
                             class   => "storage.d2",
                             host    => $renv->{hostname},
                           });
     Discover->updateTopoDevice($o);
     push(@object_list, $o);
  }
  return \@object_list;
}

sub get_Devices {
  my($class) = @_;
  my(@out, $f, $l, $name, $hba, $in , $wwn);

  my($cnt) = 0;
  my($TO) = 20;
  my(%K, $sesdev, $i, $found);

  my($error,$out) = Util->run_command("/bin/ls -C1 /dev/es", "",20);
  my($lux) = System->find_luxadm();
  my $vpd = System->get_home() . "/bin/vpd";
  chdir System->get_home() . "/bin";

  foreach $sesdev (@$out) {
     my($err,$com) = Util->run_command("$lux inq /dev/es/$sesdev", "luxadm.txt" , $TO);
     if ("@$com" =~ / D2/) {
        my($err,$com) = Util->run_command("$vpd /dev/es/$sesdev 1", "luxadm.txt" , $TO);
        my $out;
        foreach my $l (@$com) {
           if (length($l) > 20) {
              $out .= substr($l,58);
           }
        }
        if ($out =~ /.SN (\d+)/) {
           my $key = $1;
           $K{$key} .= "|" if (exists($K{$key}));
           $K{$key} .= "/dev/es/$sesdev";
        }
     }
  }
  return \%K;
}





1;
