package Discover::Brocade;
use Agent::BROCADE;
use System;
use strict;
use DiscoveryObject;
use Logic::SWITCH;
use Discover;
use Socket;

sub REGISTER {
  my($class) = @_;

  return { types  => "brocade",
          sysDesc => 1,
          fromIP  => 0,
          };
}


sub discoverFromSysDesc {
  my($class, $ip, $sysDesc, $args) = @_;
  if($sysDesc =~ /qlogic/i){
     # Not brocade
     return undef;
  }

  if ($sysDesc =~ /brocade/i || $sysDesc =~ /switch/i) {
     return $class->discoverFromIP($ip, $args);
  }
  return undef;
}


sub discoverFromIP {
  my($class, $ipno, $args) = @_;

  my $password = $args->{password};
  my ($wwn, $model) = Agent::BROCADE->getWWN($ipno);
  return [] if (!$wwn);

  my $oid     = Logic::SWITCH->get_oid($ipno);
  return [] if (index($oid, ".1588.") < 0);

  my $iaddr     = inet_aton($ipno);
  my $ip        = gethostbyaddr($iaddr, AF_INET) || $ipno;
  my ($devname) = split(/\./, $ip) ;

  my $obj = DiscoveryObject->newFromString(
         "switch.brocade|brocade|$ip|$wwn|$wwn|$wwn||$devname|$model");
  $obj->{oid} = $oid;
  Discover->updateTopoDevice($obj);
  return [$obj];
}

1;
