package DeviceReport::SE;
use System;
use strict;
use DeviceReport;
use Agent::3310;
use base 'DeviceReport';

sub map {
  my($class, $rep) = @_;
  my (%SLOT, %ID);

  foreach my $el (keys %$rep) {
     if ($el =~ /^slot\.(\d+)\.dev\-name/) {
        my $no = $1;
        $SLOT{$1} = $rep->{$el};
     }
  }
  
  foreach my $el (keys %$rep) {
     
     if (($el =~ /^fcPort\.(\d+)\.encName/) || 
         ($el =~ /^fcPort\.(\d+)\.PortId/)) {
        my $no = $1;
        my $enc = $rep->{"fcPort.$no.encName"}; # 'sp7-dsp00'
        $enc .= "-" if ($enc);
        my $id  = $rep->{"fcPort.$no.PortId"};  # ':m3p1'
	if ($id) {
          $id = substr($id,1) if (substr($id,0,1) eq ":");
	  $enc .= $id;
	} else {
	  $enc .= $no;
	}

        $ID{"fcPort.$no"} = [$enc, "fcPort.$enc"];

     } elsif ($el =~ /^fru\.(\d+)\.fruType/) {
       my $no      = $1;
       my $fruType = $rep->{"fru.$no.fruType"};
       
       if ($rep->{"fru.$no.fruId"}) {
         
         my $frutype = $rep->{"fru.$no.Class"} || $rep->{"fru.$no.fruType"};
	   	 
         # If you do not get fruType, T3 is not instrumented
	 if (!$frutype) {
	   $frutype .= "(FRUs Not Instrumented)"; 
	 }

         my $slot    = $rep->{"fru.$no.fruSlot"};
         my $typeLabel = $rep->{"slot.$slot.dev-type"};
         $frutype    = "$typeLabel $frutype" if ($typeLabel && $typeLabel ne $frutype);
         $frutype    = ucfirst($frutype);
         my $enc     = $SLOT{$slot};
         my $id      = $rep->{"fru.$no.fruId"};   # 2A
         $ID{"fru.$no"} = [$enc, "$frutype.$enc-$id"]; # 6020 controllerCard.array00-u1ctr
       
       } elsif ( ($fruType eq "switch") || 
                 ($fruType eq "ve") || ($fruType eq "sp") ) {

         my $frutype = $rep->{"fru.$no.fruType"};
       	 my $slot    = $rep->{"fru.$no.fruSlot"};
       	 my $id      = "$slot";
	 my $enc     = $SLOT{$slot};
       	 $ID{"fru.$no"}       = [$enc,"$frutype.$enc-$id"];
       }

     } elsif ($el =~ /^lun\.(\d+)\.lunName/) {
        my $no = $1;
	my $lunId =  $rep->{"lun.$no.volId"} || $rep->{"lun.$no.lunName"}; 
        my $id = $lunId;
        $ID{"lun.$no"} = ["", "lun.$id"];

     } elsif ($el =~ /^slice\.(\d+)\.volId/) {
        my $no = $1;
        my $id = $rep->{$el} . "-" . $rep->{"slice.$no.lunName"};
        $ID{"slice.$no"} = ["", "slice.$id"];
     }
  }
  return \%ID;
}


# no $q->{summary}                    # only frus,vols, system, id
# $q->{summary} = "controller.u1ctr." # this controller
# $q->{summary} = "controller."       # all controllers
# Main sections:
# <FRU> <LOGICAL> <SYSTEM> <ID>

sub xmlSummary {
  my($class, $report, $q) = @_;

  my $summary = $q->{summary}; # summary
  my $rep = $report->content();

  my $normal  = $q->{normal};  # normalized
  my (%S, %VD);
  my $out = "<REPORT>\n";
  $out .= " <CONTENT>\n";

  my $type = $rep->{'id.device_type'};

  $S{HEADER} = {
      device_name                   => {order => 1, value => $rep->{'id.device_name'}},
      device_type                   => {order => 2, value => $rep->{'info.model'} },
      device_key                    => {order => 3, value => $rep->{'id.device_key'} },
      device_ip                     => {order => 4, value => $rep->{'id.ipno'} },
      device_label                  => {order => 5, value => Util->abb("$type.medium") },
      device_power_sequencer_status => {order => 6, value => $rep->{'info.power_sequencer.status'} },
     
      };
  $S{SAN} = $class->san_info($report);
  my $map = $class->map($rep);

  
  foreach my $el (sort keys %$rep) {
       my @L = split(/\./, $el);
       my $k = "$L[0].$L[1]";
       next if (index($el, "fruDiskPerf") >= 0);
       if (!$summary) {
          if ($L[0] eq "fru" && $L[2] eq "fruType") {
              my $k2  = $map->{"fru.$L[1]"}[1] || $k;
              my $loc = $map->{"fru.$L[1]"}[0];
              my $I = SE->fruInfo($rep, $L[1]);

              my $id = $rep->{"$k.fruId"};
              $id = "${1}0$2"  if ($id =~ /(.+[d])(\d)$/);
              my $name = "$loc"; 
	      $name = "$loc.$id" if ($rep->{"$k.fruId"});

              my $avail = "Not Installed" if ($rep->{"$k.fruStatus"} eq "dummy"  
                           ||$rep->{"$k.fruStatus"} eq "notInstalled");
              $S{FRU}{$k2}            = { name   => $name,
                                           id    => $k,
                                    availability => $avail,
                                         state   => $I->{state0},
                                         status  => $I->{status0},
                                        location => $loc,
                                         type    => $I->{fruType},
                                         revision=> $I->{revString},
                                           model => $I->{model},
                                          vendor => $I->{vendor},
                                          serial => $I->{serial},
                                         keyLabel=> "SERIAL",
                                         keyValue=> $I->{serial},
                                       };

          } elsif ($L[0] eq "fru" && $L[2] eq "_Type") {
              my $loc = $map->{"fru.$L[1]"}[0];
              my $I = SE->fruInfo($rep, $L[1]);

              my $id = $rep->{"$k.fruId"};
              $id = "${1}0$2"  if ($id =~ /(.+[d])(\d)$/);
              my $frurev = $rep->{"$k._Firmware"};
              my $fruname = $rep->{"$k._ElementName"};
              my $frumodel = $rep->{"$k._Model"};
              my $fruvendor = $rep->{"$k._Vendor"};
              my $fruserial = $rep->{"$k._SerialNumber"};
              my $frutype  = $rep->{"$k._Type"};
              my $avail  = $rep->{"$k._Availability"};
              my $status= $rep->{"$k._Status"};
              my $state= $rep->{"$k._RawStatus"};

	     
              my $k2 = "CSM-200 $frutype.$fruserial";

              $S{FRU}{$k2}            = { name   => $frutype,
                                           id    => $k,
                                    availability => $avail,
                                         state   => $status,
                                         status  => $avail,
                                        location => $loc,
                                         type    => $frutype,
                                         revision=> $frurev,
                                           model => $frumodel,
                                          vendor => $fruvendor,
                                          serial => $fruserial,
                                         keyLabel=> "SERIAL",
                                         keyValue=> $fruserial,
                                       };

          } elsif ($L[0] eq "fcPort" && $L[2] eq "PortWWN") {
              my $displaySummary = "name,state,status,serial";
              my $wwn  = $rep->{"$k.LocalPortWWN"} || $rep->{"$k.PortWWN"};
              my $k2   = $map->{"fcPort.$L[1]"}[1] || $k;
              my $loc  = $map->{"fcPort.$L[1]"}[0];
              my $name = "$k." . $rep->{"$k.SlotId"};
	      my $serial = $wwn || "-";
              $S{PORT}{$k2}     = {      name    => $k2,
                                           id    => $k,					 
                                         state   => $rep->{"$k.PortState"},
                                         location=> $loc,
                                         status  => $rep->{"$k.status-desc"},
                                         type    => $rep->{"$k.portType"},
                                          model  => "",
                                          serial => $serial,
                                        revision => "",
                                        keyLabel => "WWN",
                                        keyValue => $wwn,
                                        summary  => $displaySummary,
                                       };

          } elsif ($L[0] eq "etherPort" && $L[2] eq "PortWWN") {
              my $displaySummary = "name,state,status,serial";
              my $wwn  = $rep->{"$k.LocalPortWWN"} || $rep->{"$k.PortWWN"};
              my $k2   = $map->{"etherPort.$L[1]"}[1] || $k;
              my $loc  = $map->{"etherPort.$L[1]"}[0];
              my $name = $rep->{"$k.Name"};
              my $serial = $rep->{"$k.RealPortNum"};
              $S{PORT}{$k2}     = {      name    => $name,
                                           id    => $k,					 
                                         state   => $rep->{"$k.PortState"},
                                         location=> $loc,
                                         status  => $rep->{"$k.status-desc"},
                                         type    => $rep->{"$k.portType"},
                                          model  => "",
                                          serial => $serial,
                                        revision => "",
                                        keyLabel => "WWN",
                                        keyValue => $wwn,
                                        summary  => $displaySummary,
                                       };

          } elsif ($L[0] eq "system") {
              $S{SYSTEM}{$k} = { value => $rep->{$el} };

          } elsif ($L[0] eq "id") {
              $S{ID}{$k} =  { value => $rep->{$el} };

          } elsif ($L[0] eq "lun" && $L[2] eq "lunName"
                   && $rep->{"info.model"} ne "6920")  {

	      next if ($rep->{"$k.lunStatus"} eq "deleted");
	       
              my $k2   = $map->{"lun.$L[1]"}[1] || $k;
	      my $name = $rep->{"$k.volId"} || $rep->{"$k.lunName"};
              $S{LOGICAL}{$k2} =  { name => $name,
                                    id  => $k,
                                  type  => $rep->{"$k.lunType"},
                                 status => $rep->{"$k.lunStatus"},
                                   wwn  => $rep->{"$k.lunWwn"},
                                 };

          } elsif ($L[0] eq "slice" && $L[2] eq "lunName"
                   && $rep->{"info.model"} ne "6920")  {
              my $k2   = $map->{"slice.$L[1]"}[1] || $k;
              my $name = $rep->{"$k.lunName"} . "." . $rep->{"$k.volId"} . "." . 
                         $rep->{"$k.volSliceName"};
	      next if($name =~ /^\.\./);
              $S{LOGICAL}{$k2} =  { name => $name,
                                    id  => $k,
                                  type  => "slice",
                                 status => "",$rep->{"$k.lunStatus"},
                                 };

          } elsif ($L[0] eq "volume" 
                   && ($L[2] eq "ElementName" || $L[4] eq "physicalDisk")
                   && $rep->{"info.model"} eq "6920")  {

              # find all the physical disks associated with this volume
               my $physicalDisks = "";
               $physicalDisks = $S{LOGICAL}{$k}->{physicalDisks};
               if ($L[4] eq "physicalDisk" && $L[5] ne "total") {
                 $physicalDisks = $physicalDisks.", ".$rep->{$el};
                 if (substr($physicalDisks, 0, 2) eq ", ") {
                  $physicalDisks = substr($physicalDisks, 2, length($physicalDisks)-2);
                }
               }

              my $k2   = $k;
              my $name = $rep->{"$k.ElementName"} ; 
              $S{LOGICAL}{$k2} = { name => $name,
                                    id  => $rep->{"$k.DeviceID"},
                                  type  => "volume",
                            sourceVdisk => $rep->{"$k.DeviceID"},
                          physicalDisks => $physicalDisks,
                                 };
          } else {
              #$S{OTHER}{"$L[0].$L[1]"} = 1;
          }
       } else {
          my $m  = $map->{"$L[0].$L[1]"}[1];
          my $k2 = $m ? "$m.$L[2]" : $el;
	  
	  if (substr($k2,0, length($summary)) eq $summary) {
             # For calculating slice size
  	     if ($el =~ /^slice\.(\d+)\.volSliceSize/) {
                 my $sliceNo = $1;
	         my $sizeinBlocks = $rep->{$el};
	         my $size  = sprintf("%.3f", $sizeinBlocks/1024/1024/2);
  	         $out .= "     <VALUE ID=\"slice.$sliceNo.volSliceCapacity\">$size GB</VALUE>\n";   	
		 
 	     } else { 	 	     	       
  	       $out   .= "   <VALUE ID=\"$k2\">$rep->{$el}</VALUE>\n";
	     }	     
          }
       }
  }

  if (!$summary) {
    $out .= DeviceReport->xml(\%S, "ID,SYSTEM");
  }

  $out .= " </CONTENT>\n";
  $out .= "</REPORT>\n";
#use Data::Dumper;
#open(O, ">/tmp/Y"); print O Dumper(\%S); close(O);
  return (\%S, $out);
}




1;
