package Catalog::Threshold;
use Catalog::RF;
use base 'Catalog::RF';
use strict;

###################################################
# THRESHOLD FILES
#
# Threshold File
# Author: Christian Cadieux

# Thresholds  : System/Policies/Thresholds*
#               $threshold = Catalog::Threshold->parseFile($F);
#               $new_text = $threshold->toText($threshold);

# Format:
# name              = Number,Time,Quiet,Severity,Comment
# driver.SF_OFFLINE = 10,24h,1h,W,COmment
# XML:
# <thresholds>
# <threshold name="driver.SF_OFFLINE">
#   <number>10</number>
#   <period>24h</period>
#   <quiet>1h</quiet>
#   <severity>W</severity>
#   <comment>Comment</comment>
# </threshold>
###################################################

sub info {
  return {ROOT => "thresholds",
         hash  => { threshold => "name" }};
}

sub toCatalog {
  my($class, $arg) = @_;
  my $D = System->get_home() . "/System/Policies";
  my(%D2);
  opendir(O, $D);
  my @files = readdir(O); closedir(O);
  foreach my $f (@files) {
    if ($f =~ /Thresholds(.*)/) {
       my $edition = $1;
       my $diag = $class->parseFile("System/Policies/$f");
       my $tests = $diag->{thresholds}{threshold};
       foreach my $name (keys %$tests) {
            next if ($name eq "_ATT");
            my $name = $tests->{$name}{_ATT}{name};
            my @K = split(/\./, $name);
            my $type = $K[0];
            if ($type =~ /counters/) {
               $type = "san";
            } elsif ($type =~ /driver/) {
               $type = "hba";
            }
            if ($type) {
              $D2{"$type$edition"}{$name} = $tests->{$name};
            } else {
              print "Error: no devType for $f:$name \n";
            }
       }
    }
  }
  my $C = System->get_home() .  Catalog->device_path();
  foreach my $type (keys %D2) {
      my($t, $edition) = split(/\./, $type);
      $edition = "-$edition" if ($edition);
      mkdir "$C/$t",0777 if (!-d "$C/$t");
      my $d = $class->new( $D2{$type});
      open(W, ">$C/$t/threshold${edition}.xml");
      print W $d->toXML();
      close(W);
  }
}

sub fromCatalog {
  my($class, $arg) = @_;
  my $D = ($arg->{BASE_DIR} || System->get_home()) .  Catalog->device_path();
  chdir $D;
  my @files = `ls */threshold*.xml`;

  my $DATA =  Catalog->system_path() . "/Policies/";
  mkdir $DATA,0777 if (!-d $DATA);

  my(%D2);
  my %SAVE;
  foreach my $f (@files) {
     chomp($f);
     my $rep =  Catalog::XML->parseFile("$D/$f", $class->info());
     if (!$rep) {
         print "Error reading Catalog/device/$f\n";
         last;
     }
     my($type, $edition) = split(/\-/,substr($f,0,-4));
     $edition = ".$edition" if ($edition);
     $SAVE{"Thresholds$edition"} .= $class->toText($rep);
  }
  foreach my $f (keys %SAVE) {
    open(W, ">$DATA/$f");
    print W $SAVE{$f};
    close(W);
  }
}




sub new {
  my($class, $rep) = @_;
  my $d =  {thresholds => {  _ATT => { revision => "\$" . "Revision:\$" },
                        threshold => $rep },  _ARG => $class->info()};

  bless($d, "Catalog::Threshold");
  return $d;
}



sub parseFile {
  my($class, $file, $arg) = @_;

  my $D = System->get_home();
  if (open(O, "$D/$file")) {
     my @l = <O>; close(O);
     return $class->parse(\@l,  $class->file_name($file));
  } else {
     $class->err("opening $file: $! \n");
     return undef;
  }
}

sub parse {
  my($class, $array, $file_name) = @_;

  my $out .= "<thresholds file=\"$file_name\" revision=\"\$" . "Revision:\$\">\n";
  foreach my $l (@$array) {
    chomp($l);
    if (substr($l,0,1) eq "#") {
        $out .= "<!-- $l -->\n";
        next;
    }
    my($name, $num,$period,$quiet,$sev,$comment) = split(/\s*[=,]\s*/, $l,6);
    $comment =~ s/[<>]//g;
    next if (!$sev);
    $out .= <<EOF;
  <threshold name="$name">
   <number>$num</number>
   <period>$period</period>
   <quiet>$quiet</quiet>
   <severity>$sev</severity>
   <comment>$comment</comment>
 </threshold>
EOF
  }
  $out .= "</thresholds>\n";
   my $report =  Catalog::XML->parse($out,$class->info());
   bless($report, "Catalog::Threshold");
   return $report;
}

sub toText {
  my($class, $report) = @_;
  $report = $class if (ref($class));
  my($last, $out);
  my $r = $report->{thresholds}{threshold};

  foreach my $el (sort keys %$r) {
     next if ($el eq "_ATT");
     my @L = split(/\./, $el);
     if ($L[0] ne $last) {
         $out .= "\n";
         $last = $L[0];
     }
     my $v = $r->{$el};
     $out .= sprintf("%-30s = %s,%s,%s,%s,%s\n", $el,
                   $v->{number}{_VAL},$v->{period}{_VAL},
                   $v->{quiet}{_VAL}, $v->{severity}{_VAL},
                   $v->{comment}{_VAL});
  }
  return $out;
}

1;
