# $Id: Register.pm,v 1.3 2005/01/06 21:32:36 jkremer Exp $
# Copyright 2004 Sun Microsystems, Inc., All Rights Reserved.
# Sun Proprietary/Confidential: For Internal Use Only
package Catalog::Register;

use strict;
use Catalog::EventGrid;
use Catalog::Implementation;
use Catalog::HealthConfig;
use Catalog::Model;
use Catalog::Revision;
use Debug;
use Lease;
use PDM::ConfigFile;

sub checkXML {
  my ($class, $type, $dir) = @_;

  eval {
	 Debug->print2("Checking $dir/implementation.xml");
	 my $impl = new Catalog::Implementation($type, $dir);
  };
  if ($@){
	 print "Error in $dir/implementation.xml\n";
	 print "$@\n";
	 return 0;
  }

  Debug->print2("Checking $dir/model.xml");
  my $model = new Catalog::Model($type, $dir);
  if ($model->{error}){
	 print "Error in $dir/model.xml\n";
	 print "$model->{error}\n";
	 return 0;
  }
  my $warn = $model->check();
  if ($warn){
	 print "Model warning!\n";
	 print $warn;
  }

  Debug->print2("Checking $dir/revision.xml");
  my $revision = new Catalog::Revision($type, $dir);
  if ($revision->{error}){
	 print "Error in $dir/revision.xml\n";
	 print "$revision->{error}\n";
	 return 0;
  }
  my $warn = $revision->check();
  if ($warn){
	 print "Revision format warning!\n";
	 print $warn;
  }

  Debug->print2("Checking $dir/health.xml");
  my $health = new Catalog::HealthConfig($type, $dir);
  if ($health->{error}){
	 print "Error in $dir/health.xml\n";
	 print "$health->{error}\n";
	 return 0;
  }


  return 1;
}

sub register {
  my ($class, $type, $dir) = @_;

  Debug->print2("Registering device $type using data from $dir");
  my $STORADE_DIR = "/etc/storade";
  my $CONF_FILE   = "$STORADE_DIR/$type.conf";

  if (! -d $STORADE_DIR){
	 Debug->print2("Creating dir  $STORADE_DIR\n");
	 mkdir $STORADE_DIR, 0755;
  }

  open (C, ">$CONF_FILE");
  print C "BASE_DIR=$dir\n";
  close (C);

  $class->_registerCategory($type);
  $class->_registerEgrid($type, $dir);
  $class->_registerFSA($type, $dir);
  $class->_registerTO($type);
  $class->_registerModelProperties($type, $dir);
}

sub unregister {
  my ($class, $type) = @_;

  my $STORADE_DIR = "/etc/storade";
  my $CONF_FILE   = "$STORADE_DIR/$type.conf";

  unlink  $CONF_FILE;
  $class->_unregisterCategory($type);
}

sub storadeDir {
  return "/opt/SUNWstade";
}

sub _registerTO {
  my ($class, $type) = @_;
  my $uctype = uc($type);
  my $modFile = $class->storadeDir(). "/lib/TO/" . $uctype . ".pm";

  if (! -f $modFile){

	 open (T, ">$modFile");
	 print T "# Autogenerated device register code.\n";
	 print T "package TO::" . $uctype . ";\n";
	 print T "use strict;\n";
	 print T "use base 'TO::COMMON';\n";
	 print T "sub type { '$uctype' }\n";
	 print T "sub leaf { 1 }\n";
	 print T "1;\n";
	 close (T);
  }
}

sub _registerEgrid {
  my ($class, $type, $dir) = @_;

  my $egrid = new Catalog::EventGrid($type, $dir);
}

# read in policy.xml and write out policy properties
sub _registerFSA {
  my ($class, $type, $dir) = @_;

}

# Read in model.properties and write out to ui <type>.properties
sub _registerModelProperties {
  my ($class, $type, $dir) = @_;

  my $uilib = "/var/opt/webconsole/webapps/storade/WEB-INF/lib/";
  my $uipkg = "com/sun/netstorage/mgmt/fm/storade/ui/resources/";

  my $outdir = $uilib . $uipkg;
  if (! -d $outdir){
	 mkdir ($outdir, 0755);
  }

  my $model = new Catalog::Model($type, $dir);
  my $out   = $model->outModelProperties();
  my $file  = $outdir . $type . "_resources.properties";
  open(O, $file);
  print O $out;
  print O "\n";
  close O;

  opendir(D, $dir);
  my @files = readdir(D);
  foreach my $f (@files) {
	 if ($f =~ /model_(.*).properties/){
		my $locale = $1;
		$out = $model->outModelProperties($locale);
		$file = $outdir . $type . "_resources_" . $locale . ".properties";
		open(O, $file);
		print O $out;
		print O "\n";
		close O;
	 }
  }
  close(D);
}


sub _registerCategory {
  my ($class, $type) = @_;
  my($renv, $devs, $hosts, $notifs) = PDM::ConfigFile->read;

  my $lease = $class->_leaseConf();
  if ($lease){
	 my $cat = $renv->{categories};
	 if (index("|$cat|", "|$type|") < 0){
		$cat .= "|$type";
		$renv->{categories} = $cat;
		PDM::ConfigFile->write( $renv, $devs, $hosts, $notifs);
	 }
	 $lease->release();
  }
  else {
	 return "Unable to update rasagent.conf";
  }

  return undef;
}

sub _unregisterCategory {
  my ($class, $type) = @_;
  my($renv, $devs, $hosts, $notifs) = PDM::ConfigFile->read;
  my $lease = $class->_leaseConf();
  if ($lease){
	 my $categories = $renv->{categories};
	 if (index("|$categories|", "|$type|") >= 0){
		my @cats = split(/\|/, $categories);
		$categories = undef;
		foreach my $cat (@cats){
		  next if ($cat eq $type);
		  if ($categories){
			 $categories .= "|$cat";
		  }
		  else {
			 $categories = $cat;
		  }
		}
		$renv->{categories} = $categories;
		PDM::ConfigFile->write( $renv, $devs, $hosts, $notifs);
	 }	
	 $lease->release();
  }
  else {
	 return "Unable to update rasagent.conf";
  }
  return undef;
}

sub _leaseConf {
  my ($class) = @_;
  return $class;
#  my $lease;
#  if (($lease = Lease->get("rasagent.conf", 3, 4)) ) {
#	 return $lease;
#  }
#  return undef;
}

sub release {}

1;
