# $Id: Message.pm,v 1.2 2004/12/16 01:14:42 jkremer Exp $
# Copyright 2004 Sun Microsystems, Inc., All Rights Reserved.
# Sun Proprietary/Confidential: For Internal Use Only
package Catalog::Message;

use strict;
use Catalog::Entry;
use base 'Catalog::Entry';

sub new {
  my ($class, $type, $dir) = @_;

  my $this = { "type"   => $type,
               "entry"  => "message.properties",
					"dir"    => $dir
				 };
  bless($this, "Catalog::Message");
  return $this->loadEntry();
}

sub load {
  my ($this) = @_;
  my $file = $this->{file};
  if (open(O, $file)) {
	 my @L = <O>; close(O);
	 my $map = {};
	 foreach my $l (@L) {
		my $line = $l;
		my $sindex = index($line, "=");
		next if ($sindex <= 0);
		next if (index($line, "#") == 0);
		$map->{ substr($line, 0, $sindex) } = substr($line, $sindex+1);
	 }
	 chomp %$map;
	 $this->{map} = $map;
  } else {
	 $this->setError("Can't open $file: $!");
  }
}

sub getMessage {
  my ($this, $key, $args) = @_;

  my $msg = $this->{map}->{$key};
  for (my $i = 0; $i <= $#$args; $i++){
	 my $arg = $args->[$i];
	 $msg =~ s/\{$i\}/$arg/g;
  }
  return $msg;
}


sub getComponentDescription {
  my ($this, $comp, $desc) = @_;

  if ($desc =~ /@(.*)\((.*)\)/){
	 my $key  = $1;
	 my @args = split(/\,/, $2);
	 for (my $i = 0; $i <= $#args; $i++){
		my $arg = $args[$i];
		my $var;
		chomp $arg;
		if ($arg =~ /\"(.*)\"/){
		  $var = $1;
		}
		elsif ($arg =~ /fru\.(.*)/){
		  my $fru = $comp->getFRU();
		  if ($fru){
			 $var = $fru->getProperty($1);
		  }	
		}
		elsif ($arg =~ /system\.(.*)/){
		  my $sys = $comp->getSystem();
		  if ($sys){
			 $var = $sys->getProperty($1);
		  }	
		}
		else {
		  $var = $comp->getProperty($arg);
		}
		if ($var){
		  $args[$i] = $var;
		}
	 }
	 my $l1 = join("\t", @args);
	 return ("$key\t$l1", $this->getMessage($key, \@args));
  }
  elsif ($desc =~ /@(.*)/){
	 my $key  = $1;
	 return ("$key", $this->getMessage($key));
  }	

  return (undef, $desc);
}

1;
