package Agent::TRAPMESSAGE;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>
#  $Name: bld60_020 $ 
#  $Id: TRAPMESSAGE.pm,v 1.5 2005/03/15 02:14:18 kdesai Exp $

use strict qw(vars);
use State;
use PDM::Parse;
use Report;
use Agent;
use base 'Agent';
use Policies;
use Modules;

sub isSelectable { 0 }
sub revision     { '$Revision: 1.5 $'}
sub type         { Report::CAT_TRAPMESSAGE }
sub diskTotal    { 9    }

use vars qw( $ERR %FOUND %SAM_MAP @SAM_SEV);

sub new {
  my($self) = Agent->new();

  bless ($self, 'Agent::TRAPMESSAGE');
  return $self;
}

sub RUN {
   my($agent, $static_list) = @_;
   my($err_lines, $warn_lines,  $out,$device, $connect_errs);
   my($report ,  $id, $lines, $log_err, $type);

   $DB::single = 1;
   my $type = uc($agent->type());
 
   my $processed_list = [];
 
   my $renv     = System->get_renv();
   my $logf     = $renv->{trap_logfile} || "/var/adm/trap_messages";
   my $warn_lines = [];
   my (%UIDS, $ISP, $read);

   my $trap_modules = Modules->load("Trap");
   foreach my $m (@$trap_modules) {
      my $m = "Trap::$m";
      my $u = $m->REGISTER();
      if ($u) {
        $UIDS{$m} = $u; $read=1;
      }
   }
   return $processed_list if (!$read);

   if ($logf && -r $logf) {
       Debug->print1("Executing agent TRAPMESSAGE");
       Timelapse->start("trap:logfile");
       ($log_err, $lines) = $agent->read_log_file($logf,'NEW');  
       Debug->err('CANNOT_READ', $logf) if ($log_err);

       $agent->find_alert(\%UIDS, $lines, $device, \$ISP, $warn_lines);
       Timelapse->stop("trap:logfile");
   }
      
   my($name) = $renv->{hostname} || System->hostname();
   if ($#$warn_lines >= 0) {
      $id = {
            deviceName  => System->hostid(),
            active      => "Y",
            logFile     => $logf,
            display     => $name,
            name        => $name, 
            class       => "host",
            category    => Report::CAT_TRAPMESSAGE,
            ip          => "",
         };
      $report->{"id.name"} = $name;
      my $new_rep = Report->new($id, $report , $warn_lines, Report::STATUS_DONT_SAVE);
      require Health::Message;
      my $broke_list = Health::Message->all_logic($new_rep);

      foreach my $dev (@$broke_list) {
         $dev->{problems} = 2; # broke but not processed yet.
         push(@$processed_list, $dev);
      }
      PDM->saveReport($new_rep);
   }
 
   return $processed_list;
}



############################################################
#                    SUBROUTINES
############################################################

sub find_alert {
  my($agent, $UIDS, $lines, $device, $ISP, $err) = @_;
  my( $level, $name, $no1, $no2, $rest);
  my($m, $year, $date, $comp, $x);
  my($ipno);

  my $Config = PDM::ConfigFile->read();
  my $devs = $Config->devices();
  my (%ACTIVE, %IP, %SAVE);
  my %policies;
  $policies{samfs} = Policies->new("samfs_policies");
  my $playback = System->get_snapshot();
  my ($comp1, $comp2, %DEV);

  foreach my $d (@$devs) {
     $DEV{$d->{ipno}} = $d;
  }

  for ($x = 0; $x <= $#$lines; $x++ ) {
     my $line = $lines->[$x];
     my @F = split(/\s*\t\s*/, $line);
     my (%LINE, $l, $ip);

     # Take out this line and replace it with a tab
     $F[0] =~ s/(\d+\.\d+\.\d+\.\d+)\(via/\t/g;

     ($LINE{DATE}, $LINE{TIME}, $LINE{DEVICE}, $ip) = split(/[\t\s]+/, $F[0]);

     if ($ip =~ /\[(\d+\.\d+\.\d+\.\d+)\]/) {
       $ip = $1;
     }
     $LINE{IP} = $ip;
     next if (! exists $DEV{$ip} || $DEV{$ip}{active} eq "N");
     my($OID);

     for ($l=1; $l <= $#F; $l++) {
     	
        my($name, $val) = split(/ = /, $F[$l]);
        if (defined($val)) {
	   $val = substr($val, 1, -1) if (substr($val,0,1) eq '"');
           $val = Util->rtrim($val);
           $LINE{$name} = $val;
           $OID = $val if ($name =~ /.1.3.6.1.6.3.1.1.4.1.0/);
	} else {
	   $OID = $F[$l];
	   $LINE{$OID} = $OID;	
	}  
     }
     if ($OID) {
       $OID =~ s/OID\:\s*//;
     }
     foreach my $m (keys %$UIDS) {
          my $uids = $UIDS->{$m};
          foreach my $uid (@$uids) {
             if (substr($OID, 0, length($uid)) eq $uid) {
                push(@{$SAVE{$m}}, \%LINE);
                last;
             }
          }
     }
  }         
  foreach my $m (keys %SAVE) {
     $m->RUN($SAVE{$m}, $err);
  }

}

1;
