package Agent::QLOGICSW;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2004, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Id: QLOGICSW.pm,v 1.7 2005/08/26 21:54:59 mckenney Exp $

use strict;
use Agent::SWITCH2;
use base 'Agent::SWITCH2';
use Net::Telnet;
use Agent::SWITCH;
use Util;

#  Report::CAT_SWITCH2

sub isSelectable {"Qlogic Switch"}
sub revision     {'$Revision: 1.7 $'}

sub new {
  my($self) = Agent->new();

  bless ($self, 'Agent::QLOGICSW');
  return $self;
}
use vars qw($ERR);


sub HEALTH {
  my($agent, $new_rep) = @_;
  require Health::QLOGICSW;
  Health::QLOGICSW->all_logic($new_rep);
}


sub getPortStatus {
  my($class, $dev, $R) = @_;
  my($x);
  my $DIR   = System->get_home() . "/snmp/bin";
  my $MIBDIR   = System->get_home() . "/snmp/share/snmp/mibs";
  my $renv  = System->get_renv();
  my $TO    = $renv->{'timeout.snmp'} || 10;
  my $wwn   = $dev->{wwn};
  my $mibwwn = Util->wwn2mib($wwn);
  my $public = $renv->{'snmp.community'} || "public";

 
  my $OPT = "-v1 -c$public -t$TO -r2 -M$MIBDIR -mall " . System->snmpopt() . "b";
  my $err;
  my $rem;

  # Get port type
  my $passwd = System->getDevicePassword($dev, "switch");

  my $tmpfile = System->get_home() . "/DATA/mytmpdata.$dev->{ipno}";
  open(OOF, ">$tmpfile");
  print OOF "$passwd";
  close OOF;


  my $SDIR = System->get_home() . "/sbin" ;
  ($err,$rem) = Util->run_command(
               "$SDIR/qlogicSwitchPortType $dev->{ipno}", 
               "sanbox_version.txt", 2*$TO+5);


  foreach my $l (@$rem) {
     if($l =~ /ERROR/){
        $R->{"port.0.type"} = "ERROR: ENSURE PASSWORD HAS BEEN ENTERED FOR THIS DEVICE";
     }elsif($l =~ /Port /){
        my($f1, $f2) = split(/ = /, $l);
        my ($nport, $port, $ntype) = split(/ /, $f1);
        $R->{"port.$port.type"} = $f2;
     }
  }
  # get port Admin state
  ($err,$rem) = Util->run_command( "$SDIR/qlogicadminstate $dev->{ipno}", 
                      "admin_state.txt", 2*$TO+5, {cache => 0});
  foreach my $l (@$rem) {
    if ($l =~ /(\d+)\s*=\s(.*)/) {
       my $port = $1;
       my $val = $2;
       $R->{"port.$port.state.AdmStatus"} = $val;
    }
  }

  unlink($tmpfile);
  # get port state
  $OPT = "-v1 -c$public -t$TO -r2 -m${MIBDIR}/fa_40.mib " . System->snmpopt() . "b";

  ($err,$rem) = Util->run_command(
               "$DIR/snmpwalk $OPT $dev->{ipno} connUnitPortState.$mibwwn", 
               "sanbox_version.txt", 3*$TO+5);
  if ($err){
       Debug->errNoRepeat( SNMP_SENSOR => $dev->{name} , 8, "Run Command error: $err: $DIR/snmpwalk $OPT $dev->{ipno} connUnitPortState.$mibwwn");   
  }



  foreach my $l (@$rem) {
    if ($l =~ /$mibwwn/) {
      my($f1, $f2) = split(/ = /, $l);
      my $ix = rindex($f1, ".");
      my $port = substr($f1,$ix+1) - 1;
      $ix = index($f2,"(");
      my $type = substr($f2,0,$ix);
      $R->{"port.$port.state"} = $type;
    }
  }


  $OPT = "-v1 -c$public -t$TO -r2 -M$MIBDIR -mall " . System->snmpopt() . "b";

  ($err,$rem) = Util->run_command(
               "$DIR/snmpwalk $OPT $dev->{ipno} connUnitPortSpeed.$mibwwn", 
               "sanbox_version.txt", 3*$TO+5);

  if ($err){
       Debug->errNoRepeat( SNMP_SENSOR => $dev->{name} , 8, "Run Command error: $err: $DIR/snmpwalk $OPT $dev->{ipno} connUnitPortSpeed.$mibwwn");   
  }


  my $port_speed;
  foreach my $l (@$rem) {
    if ($l =~ /$mibwwn/) {
      
      my($f1, $f2) = split(/ = /, $l);
      my $ix = rindex($f1, ".");
      my $port = substr($f1,$ix+1) - 1;
      if($f2 =~ /1062500/)
      {
         $port_speed = "10Gb";
      }
      elsif($f2 =~ /212500/)
      {
         $port_speed = "2Gb";
      }
      elsif(($f2 =~ /10625/) || ($f2 =~ /102400/))
      {
      $port_speed = "1Gb";
      }
      $R->{"port.$port.speed"} = $port_speed;
    }
  }
  
}


#
# no FC stats yet
#



1;
