package Agent::NTC;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>
use Agent;
use vars qw($AUTOLOAD);
use System;
use base 'Agent';
use strict;
use Util;
use Data::Dumper;

sub new {
  my($self) = Agent->new();
  bless ($self, 'Agent::NTC');
  return $self;
}

sub probe {
 my($class, $ip, $host, $TO, $frus) = @_;
  my %H;
  $TO = 10 if (!$TO);
  my $VAR1;

  my $alive = Util->ping($ip, 1);
  if ($alive) { #check if its alive
    $H{ip}=$ip;
    $H{name}=$ip;
    my $DIR  = System->get_home() . "/snmp/bin";
    my $MIBDIR  = System->get_home() . "/snmp/share/snmp/mibs";
    my $renv  = System->get_renv();
    my $TO  = $renv->{'timeout.snmp'} || 10;
    my $public = "public";

    my $OPT = "-m all -M $MIBDIR -r 0 -t $TO -Osb $ip $public slc.slcSystem";
    my ($err,$output) = Util->run_command(
                 "$DIR/snmpwalk $OPT");
    if ($err){
       Debug->errNoRepeat( SNMP_SENSOR => $ip,8, "Run Command error:".
       "$err: $DIR/snmpwalk $OPT");
    }
    foreach my $line (@$output){
      my ($key, $value)= split(/\s\=\s/,$line);
      $key =~ s/\.0//;
      $value =~ s/\"//g;
      $H{ $key } = $value;
    }
    if($#$output>5){
          print "  -> found NTC at $ip\n";
    }

  }else{$H{err}="Could not ping";}
  return \%H;
}

1;
