package Agent::DATAHOST;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name: bld60_020 $ 
#  $Id: DATAHOST.pm,v 1.3 2005/07/21 21:18:57 mckenney Exp $
use Agent;
use Agent::MESSAGE;
use base 'Agent';
use Carp;
use TO;
use vars qw($AUTOLOAD);
use System;
use Agent::T3;
use strict;

sub isSelectable {"Data Host"}
sub revision {'$Revision: 1.3 $'}

sub new {
  my($self) = Agent->new();

  bless ($self, 'Agent::DATAHOST');
  return $self;
}


sub RUN {
  my($agent) = @_;
  my($showrev, $backup, $report, $timelapse);

  $DB::single = 1;
  my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
  my $renv = System->get_renv();
  my $processed_list = [];

  my $last_report = PDM->getCacheHandle("datahost");
  my (@loglines, $l);
  foreach my $h (@$hosts) {
     next if ($h->{dh} ne "Y");

     my $hostname = $h->{hostname};
     my $LOG = System->get_home() . "/DATA/DataHost/$hostname.loglines";
     if (-f $LOG) {
       rename $LOG, "$LOG.1";
       open(O, "$LOG.1");
       while ($l = <O>) {
         chop($l);
         push(@loglines, $l);
       }
       close(O);
       if ($#loglines >= 0) {
         my $mess = Agent::MESSAGE->new();
         my $report;
         $mess->clear();
         $mess->read_thresholds(\@loglines);
         my($NOTICE, $WARN, $ERR, $error_cnt) = $mess->log_thresholds($hostname);
         if ($error_cnt > 0) {
            my $id = {
              category    => Report::CAT_MESSAGE,
              deviceName  => $hostname,
              display     => "datahost $hostname",
              logFile     => "",
              active      => "Y",
              class       => "host.datahost",
              name        => $hostname,
              ip          => $h->{ipno},
            };

            $report->{"id.name"} = $hostname;
            $report->{"id.ipno"} = $h->{ipno};
            $report->{warnings} = $WARN;
            $report->{errors}   = $ERR;
            $report->{notices}  = $NOTICE;
            my $new_rep = Report->new($id, $report , undef, Report::STATUS_OK);
            require Health::Message;
            my $broke_list = Health::Message->all_logic($new_rep);
            foreach my $dev (@$broke_list) {
              $dev->{problems} = 2; # broke but not processed yet.
              push(@$processed_list, $dev);
            }
            PDM->saveReport($new_rep);
         }
       }
     }

     my $HB = "dh." . $h->{hostname};
     my $rep = Util->deserialize("DataHost/$hostname");

     my $freq = ($h->{frequency} || 30) * 60;
     # compare now with the time of ras_install on that datahost
     if (!$rep && exists($h->{reg_time}) && (time - $h->{reg_time} > $freq * 4) ) {
        Debug->errNoRepeat(NO_REPORT => $HB, 24);
        next;
     }
     # compare now with the last report you received.
     if ($rep->{time} && (time - $rep->{time} > $freq * 4)) {
        Debug->errNoRepeat(NO_REPORT => $HB, 24);
     }
     if ($last_report->{$HB} == $rep->{time}) { # no new report
        Debug->print2("datahost: Report has same timestamp, skipping!");
        next;
     }
     my $localh = $renv->{hostname};
     open(O, System->get_home() . "/DATA/REMOTE_LISTS/$localh");
     my $new;
     while ($l = <O>) {
         if ($l !~ /\=$hostname/) {
            $new .= $l;
         } 
     }
     close(O);
     open(O, ">" . System->get_home() . "/DATA/REMOTE_LISTS/$localh");
     print O $new;
     my $date = Util->get_today();
     print O "host:$hostname=$date=AccessName=$hostname\n";
     close(O);
     $last_report->{$HB} = $rep->{time};
     
     my $id = {     
              deviceName  => $hostname,
              active      => "Y",
              logFile     => "",
              class       => "host.datahost",
              name        => $hostname,
              category    => Report::CAT_HOST,
              ip          => $h->{ip},
           };

     my $new_rep =Report->new($id, $rep, undef);
     require Health::Host;
     Health::Host->run_host($new_rep);
     PDM->saveReport($new_rep);

  }
  return $processed_list;
}


use Agent::HOST;

sub REPORT {
  my($class, $host, $r, $arg) = @_;
  return Agent::HOST->REPORT($host, $r, $arg);
}

sub FCCounters {
  my($class,$arg) = @_;
  my($p);
  my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
  my (%X, %ENC);
  foreach my $h (@$hosts) {
     next if (!$h->{dh} ne "Y");
     my $hostname = $h->{hostname};
     my $rep = Util->deserialize("DataHost/$hostname");
     $ENC{$hostname} = $hostname;
     next if (! $rep);
     my $to = $rep->{topo};
     my $hosts = $to->hostList();
     my $host = $hosts->[0];
     my $ports = $host->portInfo();
     for ($p=0; $p <= $#$ports; $p++) {
       my $port = $ports->[$p];
       my $key = "|$hostname|port.$p|host";
       $X{$key} = $port->{'Link failures'} . "\t" .
                  $port->{'Signal loss'} . "\t".
                  $port->{'Sequence error'} . "\t".
                  $port->{'CRC errors'} . "\t".
                  $port->{'Sync Loss'} . "\t".
                  $port->{'Invalid words'};
     }
  }
  my $out =  { enc => \%ENC , data => \%X };
  return $out;
} 
  
1;
