/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rsc.internal.ssp;

import com.sun.rsc.internal.ssp.PlatformSupport;
import com.sun.rsc.internal.ssp.SSPDeviceManager;
import com.sun.rsc.internal.ssp.SSPDeviceNotRespondingException;
import com.sun.rsc.internal.ssp.SSPInvalidDataOnDeviceException;
import com.sun.rsc.internal.ssp.SSPOperationNotSupportedException;
import com.sun.rsc.internal.ssp.SSPServerNotSupportedException;
import com.sun.rsc.internal.ssp.SSPSessionInactiveException;
import com.sun.rsc.internal.ssp.SSPVersionData;
import com.sun.rsc.internal.util.RSCDebug;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class BasePlatformSupport
implements PlatformSupport,
PropertyChangeListener {
    protected Hashtable hash;
    protected FileReader in;
    protected String pathPrefix;
    protected String hosttype;
    protected SSPVersionData vd;
    private int hardwareRevision;
    private int envAvail = 1;
    private SSPDeviceManager sspdm;
    static final int AVAIL_ALWAYS = 1;
    static final int AVAIL_NOBATT = 2;
    static final int AVAIL_NORMAL = 3;
    static final int AVAIL_NEVER = 4;

    BasePlatformSupport(SSPDeviceManager sSPDeviceManager) throws SSPSessionInactiveException, SSPOperationNotSupportedException, SSPServerNotSupportedException, SSPDeviceNotRespondingException, SSPInvalidDataOnDeviceException {
        this.sspdm = sSPDeviceManager;
        this.hosttype = sSPDeviceManager.getSystemType();
        String string = System.getProperty("file.separator");
        this.pathPrefix = "platform-files" + string + this.hosttype + string + "supportedfeatures.txt";
        this.hash = new Hashtable();
        try {
            this.in = new FileReader(this.pathPrefix);
            BufferedReader bufferedReader = new BufferedReader(this.in);
            String string2 = "rsc";
            while ((string2 = bufferedReader.readLine()) != null) {
                int n = string2.indexOf(35);
                if (n >= 0) {
                    string2 = string2.substring(n);
                }
                if ((string2 = string2.trim()).length() <= 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                String string3 = stringTokenizer.nextToken();
                int n2 = 1;
                if (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    try {
                        n2 = Integer.parseInt(string4);
                    }
                    catch (NumberFormatException numberFormatException) {
                        RSCDebug.debug((String)("Couldn't parse availability flag for variable " + string3 + "."));
                        n2 = 1;
                    }
                }
                this.hash.put(string3, new Integer(n2));
            }
            this.in.close();
        }
        catch (Exception exception) {
            throw new SSPServerNotSupportedException(this.hosttype);
        }
        if (this.isEnvironmentAvailableSupported()) {
            this.envAvail = sSPDeviceManager.getEnvironmentAvailable();
            sSPDeviceManager.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("EnvironmentAvailable")) {
            this.envAvail = (Integer)propertyChangeEvent.getNewValue();
        }
    }

    public boolean isHardwareRevisionSupported() {
        return this.isMIBVariableSupported("rscHardwareRevision");
    }

    public boolean isHostnameSupported() {
        return this.isMIBVariableSupported("rscHostname");
    }

    public boolean isLongNamesSupported() {
        return this.isNonMIBFeatureSupported("rscLongNames");
    }

    public boolean isFanCompareSupported() {
        return this.isMIBVariableSupported("rscFanCompare");
    }

    public boolean isSystemTypeSupported() {
        return this.isMIBVariableSupported("rscSystemType");
    }

    public boolean isCustomerInfoSupported() {
        return this.isMIBVariableSupported("rscCustomerInfo");
    }

    public boolean isDateTimeSupported() {
        return this.isMIBVariableSupported("rscTOD");
    }

    public boolean isEnvironmentAvailableSupported() {
        return this.isMIBVariableSupported("rscEnvironmentAvailable");
    }

    public boolean isPowerSupplyMismatchSupported() {
        return this.isMIBVariableSupported("rscPowerSupplyMismatch");
    }

    public boolean isVersionDataSupported() {
        return this.isMIBVariableSupported("rscVersionInfo");
    }

    public boolean isVersionBootMajorSupported() {
        return this.isMIBVariableSupported("rscVersionBootMajor");
    }

    public boolean isVersionBootMinorSupported() {
        return this.isMIBVariableSupported("rscVersionBootMinor");
    }

    public boolean isVersionBootMicroSupported() {
        return this.isMIBVariableSupported("rscVersionBootMicro");
    }

    public boolean isVersionMainMajorSupported() {
        return this.isMIBVariableSupported("rscVersionMainMajor");
    }

    public boolean isVersionMainMinorSupported() {
        return this.isMIBVariableSupported("rscVersionMainMinor");
    }

    public boolean isVersionMainMicroSupported() {
        return this.isMIBVariableSupported("rscVersionMainMicro");
    }

    public boolean isVersionFirmwareMajorSupported() {
        return this.isMIBVariableSupported("rscVersionFirmwareMajor");
    }

    public boolean isVersionFirmwareMinorSupported() {
        return this.isMIBVariableSupported("rscVersionFirmwareMinor");
    }

    public boolean isVersionFirmwareMicroSupported() {
        return this.isMIBVariableSupported("rscVersionFirmwareMicro");
    }

    public boolean isFrontPanelLEDsSupported() {
        return this.isMIBVariableSupported("rsc");
    }

    public boolean isFrontPanelPowerLEDSupported() {
        return this.isMIBVariableSupported("rscFrontPanelPowerLED");
    }

    public boolean isFrontPanelThermalLEDSupported() {
        return this.isMIBVariableSupported("rscFrontPanelThermalLED");
    }

    public boolean isFrontPanelDiskLEDSupported() {
        return this.isMIBVariableSupported("rscFrontPaneldiskLED");
    }

    public boolean isFrontPanelPSLEDSupported() {
        return this.isMIBVariableSupported("rscFrontPanelPSLED");
    }

    public boolean isFrontPanelGeneralLEDSupported() {
        return this.isMIBVariableSupported("rscFrontPanelGeneralLED");
    }

    public boolean isFrontPanelActivityLEDSupported() {
        return this.isMIBVariableSupported("rscFrontPanelActivityLED");
    }

    public boolean isFrontPanelThermalLED2Supported() {
        return this.isMIBVariableSupported("rscFrontPanelThermalLED2");
    }

    public boolean isFrontPanelOkToRemoveLEDSupported() {
        return this.isMIBVariableSupported("rscFrontPanelOkToRemoveLED");
    }

    public boolean isFrontPanelLeftSideAttentionLEDSupported() {
        return this.isMIBVariableSupported("rscFrontPanelLeftSideAttentionLED");
    }

    public boolean isFrontPanelRightSideAttentionLEDSupported() {
        return this.isMIBVariableSupported("rscFrontPanelRightSideAttentionLED");
    }

    public boolean isLocatorLEDSupported() {
        return this.isMIBVariableSupported("rscLocatorLED");
    }

    public boolean isPagingActiveSupported() {
        return this.isMIBVariableSupported("rsc");
    }

    public boolean isTpeLinkTestSupported() {
        return this.isMIBVariableSupported("rscTpeLinkTest");
    }

    public boolean isSerialPagerVerboseSupported() {
        return this.isMIBVariableSupported("rscSerialPagerVerbose");
    }

    public boolean isPrimaryPagerNumberSupported() {
        return this.isMIBVariableSupported("rsc");
    }

    public boolean isBackupPagerNumberSupported() {
        return this.isMIBVariableSupported("rsc");
    }

    public boolean isPrimaryPagerParitySupported() {
        return this.isMIBVariableSupported("rscSerialPagerOneParity");
    }

    public boolean isBackupPagerParitySupported() {
        return this.isMIBVariableSupported("rscSerialPagerTwoParity");
    }

    public boolean isPrimaryPagerStopBitsSupported() {
        return this.isMIBVariableSupported("rscSerialPagerOneStop");
    }

    public boolean isBackupPagerStopBitsSupported() {
        return this.isMIBVariableSupported("rscSerialPagerTwoStop");
    }

    public boolean isPrimaryPagerDataBitsSupported() {
        return this.isMIBVariableSupported("rscSerialPagerOneData");
    }

    public boolean isBackupPagerDataBitsSupported() {
        return this.isMIBVariableSupported("rscSerialPagerTwoData");
    }

    public boolean isPrimaryPagerInitStringSupported() {
        return this.isMIBVariableSupported("rscSerialPagerOneInit");
    }

    public boolean isBackupPagerInitStringSupported() {
        return this.isMIBVariableSupported("rscSerialPagerTwoInit");
    }

    public boolean isPrimaryPagerPasswordSupported() {
        return this.isMIBVariableSupported("rscSerialPagerOnePassword");
    }

    public boolean isBackupPagerPasswordSupported() {
        return this.isMIBVariableSupported("rscSerialPagerTwoPassword");
    }

    public boolean isEmailAddressSupported() {
        return this.isMIBVariableSupported("rscEmailAddress");
    }

    public boolean isPrimarySMTPHostSupported() {
        return this.isMIBVariableSupported("rscSMTPAddress");
    }

    public boolean isBackupSMTPHostSupported() {
        return this.isMIBVariableSupported("rscSMTPAddressBackup");
    }

    public boolean isIPModeSupported() {
        return this.isMIBVariableSupported("rsc");
    }

    public boolean isActiveGlobalIPModeFlagSupported() {
        return this.isMIBVariableSupported("rscActiveGlobalIPModeFlag");
    }

    public boolean isIPAddressSupported() {
        return this.isMIBVariableSupported("rsc");
    }

    public boolean isIPNetmaskSupported() {
        return this.isMIBVariableSupported("rsc");
    }

    public boolean isGatewayAddressSupported() {
        return this.isMIBVariableSupported("rsc");
    }

    public boolean isDNSServerSupported() {
        return this.isMIBVariableSupported("rsc");
    }

    public boolean isDomainNameSupported() {
        return this.isMIBVariableSupported("rscDomainName");
    }

    public boolean isActiveIPAddressSupported() {
        return this.isMIBVariableSupported("rscActiveIP");
    }

    public boolean isActiveIPNetmaskSupported() {
        return this.isMIBVariableSupported("rscActiveMask");
    }

    public boolean isActiveGatewayAddressSupported() {
        return this.isMIBVariableSupported("rscActiveGateway");
    }

    public boolean isActiveDHCPServerSupported() {
        return this.isMIBVariableSupported("rscActiveDHCPServer");
    }

    public boolean isSerialBaudRateSupported() {
        return this.isMIBVariableSupported("rscBaudRate");
    }

    public boolean isSerialPortSupported() {
        if (this.isHardwareRevisionSupported()) {
            try {
                this.hardwareRevision = this.sspdm.getHardwareRevision();
            }
            catch (SSPSessionInactiveException sSPSessionInactiveException) {
                return this.isMIBVariableSupported("rscSerialPort");
            }
            catch (SSPDeviceNotRespondingException sSPDeviceNotRespondingException) {
                return this.isMIBVariableSupported("rscSerialPort");
            }
            catch (SSPInvalidDataOnDeviceException sSPInvalidDataOnDeviceException) {
                return this.isMIBVariableSupported("rscSerialPort");
            }
            catch (SSPOperationNotSupportedException sSPOperationNotSupportedException) {
                return this.isMIBVariableSupported("rscSerialPort");
            }
        } else {
            this.hardwareRevision = 0;
        }
        if (this.hardwareRevision > 2) {
            return true;
        }
        return this.isMIBVariableSupported("rscSerialPort");
    }

    public boolean isSerialModemSupported() {
        if (this.isSerialPortSupported()) {
            return this.isMIBVariableSupported("rscSerialModem");
        }
        return false;
    }

    public boolean isPCCardModemSupported() {
        if (this.isHardwareRevisionSupported()) {
            try {
                this.hardwareRevision = this.sspdm.getHardwareRevision();
            }
            catch (SSPSessionInactiveException sSPSessionInactiveException) {
                return this.isMIBVariableSupported("rscPCMCIAModem");
            }
            catch (SSPDeviceNotRespondingException sSPDeviceNotRespondingException) {
                return this.isMIBVariableSupported("rscPCMCIAModem");
            }
            catch (SSPInvalidDataOnDeviceException sSPInvalidDataOnDeviceException) {
                return this.isMIBVariableSupported("rscPCMCIAModem");
            }
            catch (SSPOperationNotSupportedException sSPOperationNotSupportedException) {
                return this.isMIBVariableSupported("rscPCMCIAModem");
            }
        } else {
            this.hardwareRevision = 0;
        }
        return this.isMIBVariableSupported("rscPCMCIAModem");
    }

    public boolean isCountryCodeSupported() {
        return this.isMIBVariableSupported("rscCountryCode");
    }

    public boolean isSerialStopBitsSupported() {
        return this.isMIBVariableSupported("rscSerialStop");
    }

    public boolean isSerialDataBitsSupported() {
        return this.isMIBVariableSupported("rscSerialData");
    }

    public boolean isSerialParitySupported() {
        return this.isMIBVariableSupported("rscSerialParity");
    }

    public boolean isPPPLocalIPSupported() {
        return this.isMIBVariableSupported("rscSerialPPPLocalIP");
    }

    public boolean isPPPRemoteIPSupported() {
        return this.isMIBVariableSupported("rscSerialPPPRemoteIP");
    }

    public boolean isKeyswitchSupported() {
        return this.isMIBVariableSupported("rscFrontPanelKeyswitch");
    }

    public boolean isBootModeSupported() {
        return this.isMIBVariableSupported("rsc");
    }

    public boolean isBootModeExpirationSupported() {
        return this.isMIBVariableSupported("rsc");
    }

    public boolean isTemperaturesSupported() {
        boolean bl;
        block5: {
            bl = false;
            if (this.hosttype.equals("Sun-Fire-V490")) {
                try {
                    if (!this.isEnvironmentAvailableSupported()) break block5;
                    this.envAvail = this.sspdm.getEnvironmentAvailable();
                    if (this.envAvail == 1) {
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
            } else {
                bl = this.isMIBVariableSupported("rscTemperature");
            }
        }
        return bl;
    }

    public boolean isTemperatureValueSupported() {
        return this.isMIBVariableSupported("rsc");
    }

    public boolean isTemperatureLowWarnSupported() {
        return this.isMIBVariableSupported("rscTemperatureLowWarn");
    }

    public boolean isTemperatureLowShutdownSupported() {
        return this.isMIBVariableSupported("rscTemperatureLowShutdown");
    }

    public boolean isTemperatureHighWarnSupported() {
        return this.isMIBVariableSupported("rscTemperatureHighWarn");
    }

    public boolean isTemperatureHighShutdownSupported() {
        return this.isMIBVariableSupported("rscTemperatureHighShutdown");
    }

    public boolean isTemperatureDescriptionSupported() {
        return this.isMIBVariableSupported("rscTemperatureDesc");
    }

    public boolean isFansSupported() {
        return this.isMIBVariableSupported("rscFan");
    }

    public boolean isFanPresentSupported() {
        return this.isMIBVariableSupported("rscFanPresent");
    }

    public boolean isFanOkaySupported() {
        return this.isMIBVariableSupported("rscFanOkay");
    }

    public boolean isFanTypeSupported() {
        return this.isMIBVariableSupported("rscFanType");
    }

    public boolean isFanSpeedSupported() {
        return this.isMIBVariableSupported("rscFanSpeed");
    }

    public boolean isFanDescriptionSupported() {
        return this.isMIBVariableSupported("rscFanDesc");
    }

    public boolean isFanPowerSupported() {
        return this.isMIBVariableSupported("rscFanPower");
    }

    public boolean isFanSpeed2Supported() {
        return this.isMIBVariableSupported("rscFanSpeed2");
    }

    public boolean isFanMinSpeedSupported() {
        return this.isMIBVariableSupported("rscFanMinSpeed");
    }

    public boolean isFanMaxSpeedSupported() {
        return this.isMIBVariableSupported("rscFanMaxSpeed");
    }

    public boolean isFanNormLowSpeedSupported() {
        return this.isMIBVariableSupported("rscFanLowNormSpeed");
    }

    public boolean isFanNormHighSpeedSupported() {
        return this.isMIBVariableSupported("rscFanHighNormSpeed");
    }

    public boolean isFanEnabledSupported() {
        try {
            SSPVersionData sSPVersionData = this.sspdm.getVersionData();
            int n = sSPVersionData.getFirmwareMajor();
            int n2 = sSPVersionData.getFirmwareMinor();
            if (n < 2 || n == 2 && n2 < 2) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return this.isMIBVariableSupported("rscFanEnabled");
    }

    public boolean isPowerSuppliesSupported() {
        return this.isMIBVariableSupported("rscPowerSupply");
    }

    public boolean isPowerSupplyPresentSupported() {
        return this.isMIBVariableSupported("rscPowerSupplyPresent");
    }

    public boolean isPowerSupplyTypeSupported() {
        return this.isMIBVariableSupported("rscPowerSupplyType");
    }

    public boolean isPowerSupplyOkaySupported() {
        return this.isMIBVariableSupported("rscPowerSupplyOkay");
    }

    public boolean isPowerSupplyACOkaySupported() {
        return this.isMIBVariableSupported("rscPowerSupplyACOkay");
    }

    public boolean isPowerSupplyDCOkaySupported() {
        return this.isMIBVariableSupported("rscPowerSupplyDCOkay");
    }

    public boolean isPowerSupplyishareSupported() {
        return this.isMIBVariableSupported("rscPowerSupplyIshare");
    }

    public boolean isPowerSupplyClimitSupported() {
        return this.isMIBVariableSupported("rscPowerSupplyClimit");
    }

    public boolean isPowerSupplyDescriptionSupported() {
        return this.isMIBVariableSupported("rscPowerSupplyDesc");
    }

    public boolean isPowerSupply3pt3VRailSupported() {
        return this.isMIBVariableSupported("rscPowerSupply3pt3VRail");
    }

    public boolean isPowerSupply5VRailSupported() {
        return this.isMIBVariableSupported("rscPowerSupply5VRail");
    }

    public boolean isPowerSupply12VRailSupported() {
        return this.isMIBVariableSupported("rscPowerSupply12VRail");
    }

    public boolean isPowerSupply48VRailSupported() {
        return this.isMIBVariableSupported("rscPowerSupply48VRail");
    }

    public boolean isPowerSupplyFanOkaySupported() {
        return this.isMIBVariableSupported("rscPowerSupplyFanOkay");
    }

    public boolean isPowerSupplyTempOkaySupported() {
        return this.isMIBVariableSupported("rscPowerSupplyTempOkay");
    }

    public boolean isPowerSupplyLowLineOverloadSupported() {
        return this.isMIBVariableSupported("rscPowerSupplyLowLineOverload");
    }

    public boolean isPowerSupplyUnpluggedSupported() {
        return this.isMIBVariableSupported("rscPowerSupplyUnplugged");
    }

    public boolean isInternalDiskSupported() {
        return this.isMIBVariableSupported("rscDisk");
    }

    public boolean isInternalDiskPresentSupported() {
        return this.isMIBVariableSupported("rscDiskPresent");
    }

    public boolean isInternalDiskOkaySupported() {
        return this.isMIBVariableSupported("rscDiskOkay");
    }

    public boolean isInternalDiskDescriptionSupported() {
        return this.isMIBVariableSupported("rscDiskDescDisksDesc");
    }

    public boolean isCpusSupported() {
        return this.isMIBVariableSupported("rscCPU");
    }

    public boolean isCpuPresentSupported() {
        return this.isMIBVariableSupported("rscCpuPresent");
    }

    public boolean isCpuOkaySupported() {
        return this.isMIBVariableSupported("rscCpuOkay");
    }

    public boolean isCpuDieTempSupported() {
        return this.isMIBVariableSupported("rscCpuDieTemp");
    }

    public boolean isCpuDieLowWarnSupported() {
        return this.isMIBVariableSupported("rscCpuDieLowWarn");
    }

    public boolean isCpuDieLowShutdownSupported() {
        return this.isMIBVariableSupported("rscCpuDieLowShutdown");
    }

    public boolean isCpuDieHighWarnSupported() {
        return this.isMIBVariableSupported("rscCpuDieHighWarn");
    }

    public boolean isCpuDieHighShutdownSupported() {
        return this.isMIBVariableSupported("rscCpuDieHighShutdown");
    }

    public boolean isPcisSupported() {
        return this.isMIBVariableSupported("rscPCI");
    }

    public boolean isPciPresentSupported() {
        return this.isMIBVariableSupported("rscPciPresent");
    }

    public boolean isPciOkaySupported() {
        return this.isMIBVariableSupported("rscPciOkay");
    }

    public boolean isConsoleBootLogSupported() {
        return this.isMIBVariableSupported("rsc");
    }

    public boolean isOriginalConsoleBootLogSupported() {
        return this.isMIBVariableSupported("rsc");
    }

    public boolean isConsoleRunLogSupported() {
        return this.isMIBVariableSupported("rsc");
    }

    public boolean isOriginalConsoleRunLogSupported() {
        return this.isMIBVariableSupported("rsc");
    }

    public boolean isEventLogSupported() {
        return this.isMIBVariableSupported("rsc");
    }

    public boolean isEventLogIndexSupported() {
        return this.isMIBVariableSupported("rscEventLogIndex");
    }

    public boolean isEventLogTimeStampSupported() {
        return this.isMIBVariableSupported("rscEventLogTimeStamp");
    }

    public boolean isEventLogIDSupported() {
        return this.isMIBVariableSupported("rscEventLogID");
    }

    public boolean isEventLogMessageSupported() {
        return this.isMIBVariableSupported("rscEventLogMessage");
    }

    public boolean isUsersSupported() {
        return this.isMIBVariableSupported("rsc");
    }

    public boolean isUserNameSupported() {
        return this.isMIBVariableSupported("rscUserName");
    }

    public boolean isUserPasswordSupported() {
        return this.isMIBVariableSupported("rscUserPassword");
    }

    public boolean isUserConsolePriviledgeSupported() {
        return this.isMIBVariableSupported("rscUserConsolePriviledge");
    }

    public boolean isUserAttrPriviledgeSupported() {
        return this.isMIBVariableSupported("rscUserAttrPriviledge");
    }

    public boolean isUserConfigPriviledgeSupported() {
        return this.isMIBVariableSupported("rscUserConfigPriviledge");
    }

    public boolean isUserButtonPriviledgeSupported() {
        return this.isMIBVariableSupported("rscUserButtonPriviledge");
    }

    public boolean isConsoleLogSupported() {
        return this.isMIBVariableSupported("rsc");
    }

    public boolean isConsoleLogTypeSupported() {
        return this.isMIBVariableSupported("rscConsoleLogType");
    }

    public boolean isConsoleLogIndexSupported() {
        return this.isMIBVariableSupported("rscConsoleLogIndex");
    }

    public boolean isConsoleLogOffsetSupported() {
        return this.isMIBVariableSupported("rscConsoleLogOffset");
    }

    public boolean isConsoleLogBufferSupported() {
        return this.isMIBVariableSupported("rscConsoleLogBuffer");
    }

    public boolean isBatterySupported() {
        return this.isMIBVariableSupported("rscBattery");
    }

    public boolean isBatteryTestSupported() {
        return this.isMIBVariableSupported("rscBatteryTest");
    }

    public boolean isProtocolLoggerSupported() {
        return this.isMIBVariableSupported("rsc");
    }

    public boolean isProtocolRecorderSupported() {
        return this.isMIBVariableSupported("rsc");
    }

    public boolean isBatteryStatusSupported() {
        return this.isMIBVariableSupported("rscBatteryStatus");
    }

    public boolean isBatteryMaxValueSupported() {
        return this.isMIBVariableSupported("rscBatteryMaxValue");
    }

    public boolean isBatteryLowWarnThresholdSupported() {
        return this.isMIBVariableSupported("rscBattryLowWarnThreshold");
    }

    public boolean isBatteryLowCriticalThresholdSupported() {
        return this.isMIBVariableSupported("rscBattryLowCriticalThreshold");
    }

    public boolean isResetEventSupported() {
        try {
            if (!this.isVersionFirmwareMajorSupported()) {
                return false;
            }
            SSPVersionData sSPVersionData = this.sspdm.getVersionData();
            int n = sSPVersionData.getFirmwareMajor();
            int n2 = sSPVersionData.getFirmwareMinor();
            return n >= 2 && (n != 2 || n2 >= 2);
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean isMIBVariableSupported(String string) {
        Object v = this.hash.get(string);
        if (v == null) {
            return false;
        }
        if (this.envAvail == 1) {
            return true;
        }
        int n = (Integer)v;
        if (this.envAvail == 2) {
            return n < 3;
        }
        if (this.envAvail == 3) {
            return n < 2;
        }
        return false;
    }

    protected boolean isNonMIBFeatureSupported(String string) {
        return this.isMIBVariableSupported(string);
    }
}

