#!/bin/sh
# Copyright 09/15/04 Sun Microsystems, Inc. All Rights Reserved.
#pragma ident  "@(#)sunmc_prm_setup.sh	1.18 04/09/15 Sun Microsystems"

#This function finds a pattern in a file
findline()
{
    pattern=$1
    file=$2
    found=`$CMD_GREP -n -e "$pattern" $file`
    if [ -z "$found" ] ; then
        return 1
    else
        return 0
    fi
}


#This function does setup of the Server layer. All server related setup code must go in this function

server_setup()
{
    /usr/bin/gettext "Setup for Performance Reporting Manager - Server Layer "
    echolog ""
    echolog ""

    #Add the module info into the database.
    if [ ! -f /var/opt/SUNWsymon/cfg/.license.packs ] ; then
        /usr/bin/cp ${BASEDIR}/base/cfg/.license.packs /var/opt/SUNWsymon/cfg/
    fi

    # remove incorrect pack line
    removeLicensePack "w Performance Reporting Manager"

    # If the line for PRM does not exist, then add it
    addLicensePack "p Performance Reporting Manager"

    if [ ! -f $MODULES_INFO ] ; then
        ${BASEDIR}/lib/sbin/es-add-module ${BASEDIR}/addons/PRM/sbin/modules.info
        if [ $? -eq 1 ] ; then
            /usr/bin/gettext "Performance Reporting Manager setup failed"
            exit 1
        fi

        /usr/bin/cp ${BASEDIR}/addons/PRM/sbin/modules.info $MODULES_INFO
        echolog ""
    fi

    #Create a directory for collection services
    /usr/bin/mkdir -p /var/opt/SUNWsymon/PRM/service
    /usr/bin/mkdir -p /var/opt/SUNWsymon/PRM/service/cfg

    #copy service cfg files to var directory
    /usr/bin/cp ${BASEDIR}/addons/PRM/cfg/hardware.4u /var/opt/SUNWsymon/PRM/service/cfg
    /usr/bin/cp ${BASEDIR}/addons/PRM/cfg/hardware.4u1D /var/opt/SUNWsymon/PRM/service/cfg
    /usr/bin/cp ${BASEDIR}/addons/PRM/cfg/hardware.4udt /var/opt/SUNWsymon/PRM/service/cfg
    /usr/bin/cp ${BASEDIR}/addons/PRM/cfg/hardware.4unt /var/opt/SUNWsymon/PRM/service/cfg
    /usr/bin/cp ${BASEDIR}/addons/PRM/cfg/hardware.4uwg /var/opt/SUNWsymon/PRM/service/cfg
    /usr/bin/cp ${BASEDIR}/addons/PRM/cfg/hardware.Serengeti /var/opt/SUNWsymon/PRM/service/cfg
    /usr/bin/cp ${BASEDIR}/addons/PRM/cfg/hardware.StarCatD /var/opt/SUNWsymon/PRM/service/cfg
    /usr/bin/cp ${BASEDIR}/addons/PRM/cfg/hardware.4uvh /var/opt/SUNWsymon/PRM/service/cfg

    #copy collection properties file to var directory
    /usr/bin/cp ${BASEDIR}/addons/PRM/cfg/collect.properties /var/opt/SUNWsymon/cfg
    /usr/bin/chmod u+w /var/opt/SUNWsymon/cfg/collect.properties

    #Append lines for console
    if [ ! -f /var/opt/SUNWsymon/cfg/console-tools.cfg ] ; then
        /usr/bin/touch /var/opt/SUNWsymon/cfg/console-tools.cfg
    fi

    #check if ths lines exist, if they don't exist then only append
    findline  com.sun.symon.base.client.util.CrReport:reportMgr /var/opt/SUNWsymon/cfg/console-tools.cfg
    if [ $? -eq 1 ] ; then
        /bin/echo "com.sun.symon.base.client.util.CrReport:reportMgr, com.sun.symon.base.console.report.manager.CrReportMain" >> /var/opt/SUNWsymon/cfg/console-tools.cfg
    fi

    #run es-tools
    ${BASEDIR}/sbin/es-tool

    #setup PRM web console for Tomcat Web Server
    if [ ! -f $BASEDIR/web/prm/WEB-INF/lib/esprms.jar ] ; then
        /usr/bin/ln -s $BASEDIR/apps/classes/esprms.jar $BASEDIR/web/prm/WEB-INF/lib
    fi
    if [ ! -f $BASEDIR/web/prm/WEB-INF/lib/eslprm.jar ] ; then
        /usr/bin/ln -s $BASEDIR/apps/classes/eslprm.jar $BASEDIR/web/prm/WEB-INF/lib
    fi
    if [ ! -f $BASEDIR/web/prm/WEB-INF/lib/esweb.jar ] ; then
        /usr/bin/ln -s $BASEDIR/web/console/WEB-INF/lib/esweb.jar $BASEDIR/web/prm/WEB-INF/lib
    fi
    if [ ! -f $BASEDIR/web/prm/WEB-INF/lib/esclt.jar ] ; then
        /usr/bin/ln -s $BASEDIR/classes/esclt.jar $BASEDIR/web/prm/WEB-INF/lib
    fi
    if [ ! -f $BASEDIR/web/prm/WEB-INF/lib/escom.jar ] ; then 
        /usr/bin/ln -s $BASEDIR/classes/escom.jar $BASEDIR/web/prm/WEB-INF/lib
    fi
    if [ ! -f $BASEDIR/web/prm/WEB-INF/lib/esjrm.jar ] ; then
        /usr/bin/ln -s $BASEDIR/classes/esjrm.jar $BASEDIR/web/prm/WEB-INF/lib
    fi
    if [ ! -f $BASEDIR/web/prm/WEB-INF/lib/esmsg.jar ] ; then
        /usr/bin/ln -s $BASEDIR/classes/esmsg.jar $BASEDIR/web/prm/WEB-INF/lib
    fi
    if [ ! -f $BASEDIR/web/prm/WEB-INF/lib/essvc.jar ] ; then
        /usr/bin/ln -s $BASEDIR/classes/essvc.jar $BASEDIR/web/prm/WEB-INF/lib
    fi

    if [ -d ${BASEDIR}/web/prm/WEB-INF ] ; then
        cd ${BASEDIR}/web/prm/WEB-INF
        if [ -f web.xml ] ; then
            /usr/bin/sed -e "s:##BASEDIR##:$BASEDIR:g" \
                 web.xml > web.tmp
            /usr/bin/sed -e "s:##VARDIR##:$VAROPTDIR:g" \
                 web.tmp > web.xml
            /usr/bin/rm -f web.tmp
        fi
	if [ ! -h $BASEDIR/web/prm/WEB-INF/classes ] ; then
	    /usr/bin/ln -s $BASEDIR/addons/PRM/lib/locale/classes $BASEDIR/web/prm/WEB-INF
	fi
    fi
       
    if [ -d ${BASEDIR}/web/conf ] ; then
        cd $BASEDIR/web/conf
        if [ -f server.xml ] ; then
            /usr/bin/chmod u+w server.xml

            findline "prm" server.xml

            if [ $? -eq 1 ] ; then
                FindNo=`/usr/bin/grep -n "</Host>" server.xml|head -1|awk -F: '{print $1;}'`
                TotalCount=`wc -l server.xml|awk '{print $1;}'`
                HeadCount=`expr $FindNo - 1`
                TailCount=`expr $TotalCount - $FindNo + 1`
                /usr/bin/head -$HeadCount server.xml > /tmp/server.xml.head
                /usr/bin/tail -$TailCount server.xml > /tmp/server.xml.tail
        
                echo "        <!--Prm_Setup_Begin-->" >> /tmp/server.xml.head
                echo "   " >> /tmp/server.xml.head
                echo "        <Context path=\"/prm\" docBase=\"prm\" debug=\"0\"  " >> /tmp/server.xml.head
                echo "                 reloadable=\"true\" crossContext=\"true\">" >> /tmp/server.xml.head
                echo "        </Context>" >> /tmp/server.xml.head
                echo "   " >> /tmp/server.xml.head
                echo "        <!--Prm_Setup_End-->" >> /tmp/server.xml.head
                echo "  " >> /tmp/server.xml.head
        
                /usr/bin/cat /tmp/server.xml.tail >> /tmp/server.xml.head
                /usr/bin/mv /tmp/server.xml.head server.xml > /dev/null
                /usr/bin/chmod 444 server.xml
                /usr/bin/rm /tmp/server.xml.tail > /dev/null
            fi
        fi
    fi

    #append lines to log.properties
    /usr/bin/mkdir -p /var/opt/SUNWsymon/PRM/log

    findline prmlog /var/opt/SUNWsymon/AdvancedServices/logs/core/log.properties
    if [ $? -eq 1 ] ; then
        /usr/bin/sed 's/ACTIVE=/ACTIVE=prmlog dbadd dbdrop /' /var/opt/SUNWsymon/AdvancedServices/logs/core/log.properties >  /tmp/log.properties.$$
        /usr/bin/mv /tmp/log.properties.$$ /var/opt/SUNWsymon/AdvancedServices/logs/core/log.properties
        echo "prmlog=clog://localhost/../PRM/log/prm.log;lines=1000;width=200;flags=rw+;mode=644;keep=1" >> /var/opt/SUNWsymon/AdvancedServices/logs/core/log.properties
        echo "dbadd=clog://localhost/../PRM/log/dbAddPart.log;lines=1000;width=200;flags=rw+;mode=644;keep=1" >> /var/opt/SUNWsymon/AdvancedServices/logs/core/log.properties
        echo "dbdrop=clog://localhost/../PRM/log/dbDropPart.log;lines=1000;width=200;flags=rw+;mode=644;keep=1" >> /var/opt/SUNWsymon/AdvancedServices/logs/core/log.properties
    fi


    echolog ""

    echolog " "

    # Test if the base is 3.0 or 3.5
    sunmc35=3.5
    build_no=`/usr/bin/pkgparam SUNWescom SUNW_PRODVERS`
    build_no=`echo $build_no | /usr/bin/cut -c1-3`


    if [ "$build_no" = "$sunmc35" ] ; then
        move_prm_file
    fi

    # Call online help setup function
    help_setup
}

help_setup()
{
    ${BASEDIR}/sbin/es-chelp -a prm-main-help prm/prm-standard-1.html#PRM-STANDARD-5
    ${BASEDIR}/sbin/es-chelp -a prm-performance-help prm/prm-custom-1.html#PRM-CUSTOM-16
    ${BASEDIR}/sbin/es-chelp -a prm-alarm-help prm/prm-custom-1.html#PRM-CUSTOM-16
    ${BASEDIR}/sbin/es-chelp -a prm-system-help prm/prm-custom-1.html#PRM-CUSTOM-16
    ${BASEDIR}/sbin/es-chelp -a prm-package-help prm/prm-custom-1.html#PRM-CUSTOM-16
    ${BASEDIR}/sbin/es-chelp -a prm-composite-help prm/prm-custom-1.html#PRM-CUSTOM-34
    ${BASEDIR}/sbin/es-chelp -a prm-category-help prm/prm-custom-1.html#PRM-CUSTOM-79
    ${BASEDIR}/sbin/es-chelp -a prm-subcategory-help prm/prm-custom-1.html#PRM-CUSTOM-79
    ${BASEDIR}/sbin/es-chelp -a prm-perftime-help prm/prm-custom-1.html#PRM-CUSTOM-111
    ${BASEDIR}/sbin/es-chelp -a prm-filter-help prm/prm-custom-1.html#PRM-CUSTOM-50
    ${BASEDIR}/sbin/es-chelp -a prm-graph-output-help prm/prm-options-1.html#PRM-OPTIONS-38
    ${BASEDIR}/sbin/es-chelp -a prm-tabular-output-help prm/prm-intro-1.html#PRM-INTRO-8
    ${BASEDIR}/sbin/es-chelp -a prm-composite-output-help prm/prm-custom-1.html#PRM-CUSTOM-34
    ${BASEDIR}/sbin/es-chelp -a prm-processes-output-help prm/prm-options-1.html#PRM-OPTIONS-38
    ${BASEDIR}/sbin/es-chelp -a prm-alarms-output-help prm/prm-options-1.html#PRM-OPTIONS-38
    ${BASEDIR}/sbin/es-chelp -a prm-csv-help prm/prm-options-1.html#PRM-OPTIONS-27
    ${BASEDIR}/sbin/es-chelp -a prm-customize-help prm/prm-options-1.html#PRM-CUSTOM-51
    ${BASEDIR}/sbin/es-chelp -a prm-nonperf-propchooser-help prm/prm-custom-1.html#PRM-CUSTOM-27
    ${BASEDIR}/sbin/es-chelp -a prm-perf-propchooser-help prm/prm-custom-1.html#PRM-CUSTOM-27
    ${BASEDIR}/sbin/es-chelp -a prm-datacollection-help prm/prm-custom-1.html#PRM-OPTIONS-15
    ${BASEDIR}/sbin/es-chelp -a prm-dataavailability-help prm/prm-custom-1.html#PRM-CUSTOM-27
    ${BASEDIR}/sbin/es-chelp -a prm-schedule-help prm/prm-options-1.html#PRM-OPTIONS-3
    ${BASEDIR}/sbin/es-chelp -a prm-schedule-status-help prm/prm-options-1.html#PRM-OPTIONS-3
    ${BASEDIR}/sbin/es-chelp -a prm-hardware-help prm/prm-custom-1.html#PRM-CUSTOM-16
    ${BASEDIR}/sbin/es-chelp -a prm-hardware-propchooser-help prm/prm-custom-1.html#PRM-CUSTOM-27
    ${BASEDIR}/sbin/es-chelp -a prm-logging-setting-help prm/prm-custom-1.html#PRM-CUSTOM-27
    ${BASEDIR}/sbin/es-chelp -a prm-patch-help prm/prm-custom-1.html#PRM-CUSTOM-16
    ${BASEDIR}/sbin/es-chelp -a prm-patch-help prm/prm-custom-1.html#PRM-CUSTOM-16
    ${BASEDIR}/sbin/es-chelp -a prm-webmain-help prm/prm-options-1.html#PRM-OPTIONS-45
}

move_prm_file()
{
    /usr/bin/mkdir -p /var/opt/SUNWsymon/AdvancedServices/services/PRM
    /usr/bin/mkdir -p /var/opt/SUNWsymon/AdvancedServices/tasks/PRM


    #copy the varopt files
    if [ -f ${BASEDIR}/AdvancedServices/services/PRM/collectservice.properties ] ; then
        /usr/bin/cp ${BASEDIR}/AdvancedServices/services/PRM/collectservice.properties /var/opt/SUNWsymon/AdvancedServices/services/PRM
    else
        /usr/bin/gettext "Unable to copy file to the /var/opt/SUNWsymon directory"
        echolog ""
    fi

    if [ -f ${BASEDIR}/AdvancedServices/services/PRM/report-service-acls.properties ] ; then
        /usr/bin/cp ${BASEDIR}/AdvancedServices/services/PRM/report-service-acls.properties /var/opt/SUNWsymon/AdvancedServices/services/PRM
    else
        /usr/bin/gettext "Unable to copy file to the /var/opt/SUNWsymon directory"
        echolog ""
    fi

    if [ -f ${BASEDIR}/AdvancedServices/tasks/PRM/PRMTaskType.xml ] ; then
        /usr/bin/cp ${BASEDIR}/AdvancedServices/tasks/PRM/PRMTaskType.xml /var/opt/SUNWsymon/AdvancedServices/tasks/PRM
    else
        /usr/bin/gettext "Unable to copy file to the /var/opt/SUNWsymon directory"
        echolog ""
    fi

}

#This function does setup of the agent layer. All agent related setup code must go inside this function
agent_setup()
{
    /usr/bin/gettext "Setup for Performance Reporting Manager - Agent Layer"
    echolog " "
    echolog " "

    #in case of re-setup, delete SYSTEM/PATCH/PKG/ADVHW data
    /usr/bin/rm -f /var/opt/SUNWsymon/PRM/agent/data/system.dat
    /usr/bin/rm -f /var/opt/SUNWsymon/PRM/agent/data/systemdelta.dat
    /usr/bin/rm -f /var/opt/SUNWsymon/PRM/agent/data/patch.dat
    /usr/bin/rm -f /var/opt/SUNWsymon/PRM/agent/data/patchdelta.dat
    /usr/bin/rm -f /var/opt/SUNWsymon/PRM/agent/data/pkg.dat
    /usr/bin/rm -f /var/opt/SUNWsymon/PRM/agent/data/pkgdelta.dat
    /usr/bin/rm -f /var/opt/SUNWsymon/PRM/agent/data/hardware.dat
    /usr/bin/rm -f /var/opt/SUNWsymon/PRM/agent/data/hardwaredelta.dat
    /usr/bin/rm -f /var/opt/SUNWsymon/PRM/agent/data/hardware.cfg
    /usr/bin/rm -f /var/opt/SUNWsymon/PRM/agent/data/hwcfg.dat
    /usr/bin/rm -f /var/opt/SUNWsymon/cfg/perftool.dat

    #create directories for the perftool module
    /usr/bin/mkdir -p /var/opt/SUNWsymon/PRM/agent/cfg
    /usr/bin/mkdir -p /var/opt/SUNWsymon/PRM/agent/data
    /usr/bin/mkdir -p /var/opt/SUNWsymon/PRM/agent/data/tmp

    #copy agent files to var directory
    /usr/bin/cp ${BASEDIR}/addons/PRM/cfg/day.cfg /var/opt/SUNWsymon/PRM/agent/cfg
    /usr/bin/cp ${BASEDIR}/addons/PRM/cfg/process.cfg /var/opt/SUNWsymon/PRM/agent/cfg

    #copy the defaultlog.cfg only if its not present on the agent
    if [ ! -f /var/opt/SUNWsymon/PRM/agent/cfg/defaultlog.cfg ] ; then
          /usr/bin/cp ${BASEDIR}/addons/PRM/cfg/defaultlog.cfg /var/opt/SUNWsymon/PRM/agent/cfg
    fi

    ${BASEDIR}/sbin/es-load-default -a -f ${BASEDIR}/addons/PRM/sbin/perftool.minfo

    domain_file=/var/opt/SUNWsymon/cfg/domain-config.x
    domain_file_name=`/usr/bin/basename $domain_file`
    temp=/tmp/$domain_file_name.$$
    local_var=clog://localhost/../log/history.log\;lines=12000\;width=200\;flags=rw+\;mode=644\;mmap=false

    if [ -r ${temp} ] ; then
        /usr/bin/rm -f ${temp}
    fi

    var=`${CMD_GREP} "historyOutput" ${domain_file}`
    modify_domain_flag=""

    if [ "$var" != "" ] ; then
        agt_lines=`$XGET ${domain_file} agent.historyOutput`

        agt_mapfalse=`echo "$agt_lines" | ${CMD_GREP} "mmap[ ]*=[ ]*false"`
        agt_lines=`echo "$agt_lines" | /usr/bin/cut -d\; -f2 | /usr/bin/cut -d= -f2`
        plt_lines=`$XGET ${domain_file} platform.historyOutput`

        plt_mapfalse=`echo "$plt_lines" | ${CMD_GREP} "mmap[ ]*=[ ]*false"`
        plt_lines=`echo "$plt_lines" | /usr/bin/cut -d\; -f2 | /usr/bin/cut -d= -f2`

        if [ "$agt_lines" -lt 12000 ] || [ -z "$agt_mapfalse" ] \
            || [ "$plt_lines" -lt 12000 ] || [ -z "$plt_mapfalse" ] ; then
             modify_domain_flag=1
        fi
    fi

    if [ -z "$var" ] || [ "$modify_domain_flag" -eq 1 ] ; then
        /usr/bin/gettext "Increasing the size of the /var/opt/SUNWsymon/log/history.log to 12,000 lines "
        echolog ""

        if [ -f "/var/opt/SUNWsymon/log/history.log" ]; then
            if [ "$agt_lines" -lt 12000 ] || [ "$plt_lines" -lt 12000 ] ; then
                /usr/bin/gettext "The old /var/opt/SUNWsymon/log/history.log will be moved to /var/opt/SUNWsymon/log/history.log.old"

                #remove the old history.log file
                /usr/bin/mv /var/opt/SUNWsymon/log/history.log /var/opt/SUNWsymon/log/history.log.old

                if [ -f "/var/opt/SUNWsymon/PRM/agent/data/file_record.dat" ]; then
                    /usr/bin/mv /var/opt/SUNWsymon/PRM/agent/data/file_record.dat /var/opt/SUNWsymon/PRM/agent/data/file_record.dat.old
                fi
            fi
        fi


        echolog ""
        echolog ""

        ${CMD_GREP} -v "historyOutput" ${domain_file} > ${temp}

        $XPUT ${temp} agent.historyOutput "$local_var"
        $XPUT ${temp} platform.historyOutput "$local_var" 
        /usr/bin/mv ${temp} ${domain_file}

    fi

}




#*******************************************************************************
#                      MAIN Entry Point
#*******************************************************************************
# Comments:
# This setup script is only intended for Non DB setup (agent & server layer)
#
#*******************************************************************************
BASEDIR=`/usr/bin/pkgparam SUNWescom BASEDIR`
. ${BASEDIR}/SUNWsymon/sbin/es-common.sh
set_basedir
check_root
set_xput
setup_textdomain SUNW_SUNMC_PRM
MODULES_INFO=/var/opt/SUNWsymon/PRM/modules.info
CMD_GREP=/usr/bin/egrep

umask 022

#If agent layer is installed, run agent_setup
/usr/bin/pkginfo -q SUNWesarg
if [ $? -eq 0 ] ; then
    agent_setup
fi

#if Server layer is installed, run server_setup
/usr/bin/pkginfo -q SUNWessrg
if [ $? -eq 0 ] ; then
    server_setup
    exit 10
fi

exit 0
