#!/bin/sh
# Copyright 05/06/04 Sun Microsystems, Inc. All Rights Reserved.
#pragma ident  "@(#)es-uninst.sh	1.12 04/05/06 Sun Microsystems"

#
# unset help entries
#
unset_help()
{
   if [ -x ${ESROOT}/sbin/es-chelp ]; then
	${ESROOT}/sbin/es-chelp -d eservice-manager-help
	${ESROOT}/sbin/es-chelp -d eservice-modifier-help
	${ESROOT}/sbin/es-chelp -d eservice-filter-help
   fi 
}

#
# preserved E*Service Addon's data, if necessary
#
 
process_eservice_agent_data()
{
 
   keep_eservice_data="$1"

   upgrade_eservice_dir="$VAROPTDIR/upgrade/addons/EService"

   # Check if Keep_Data flag has been set by core uninstall,
   # if not, prompt the user to ask the question about keep the data.
   if [ -z "$keep_eservice_data" ] ; then

       ask_user "Would you like to preserve your previous data"
       if [ $answer -eq 1 ] ; then
           keep_eservice_data=1
       fi
   fi
     
   if [ "$keep_eservice_data" -eq 1 ] ; then
       # User choose to keep data during the core uninstall.

       # Create upgrade directory
       if [ ! -d $upgrade_eservice_dir ]; then
           /usr/bin/mkdir -p $upgrade_eservice_dir > /dev/null 2>&1
           if [ $? -ne 0 ]; then
               echolog "Could not preserve EServices data. Upgrade directory could not be created."
               exit 1
           fi
       fi    
         
       # Preserve $VAROPTDIR SE and ST module files. *-family-j.x files are to be ignored.
       eservice_modules_to_keep="httpST httpSE ftpST ftpSE dnsST dnsSE telnetST telnetSE smtpST smtpSE nisST nisSE ldapST ldapSE imapSE imapST popST popSE calendarST calendarSE edot"

       for each_eservice_module_to_keep in $eservice_modules_to_keep
       do
           modules_to_preserve=`/usr/bin/ls -1 ${VAROPTDIR}/cfg/$each_eservice_module_to_keep* | /usr/bin/grep -v family-j.x`
           if [ ! -z "$modules_to_preserve" ]; then
               /usr/bin/cp -f ${modules_to_preserve} $upgrade_eservice_dir
               [ $? -ne 0 ] && echologverbose 'Could not preserve $2 for EServices.' $each_module_to_preserve
           fi  
       done  

       # Preserve base-modules-d.dat file and eservices-composite.conf files.
       [ -f ${VAROPTDIR}/cfg/base-modules-d.dat ] && /usr/bin/cp -f ${VAROPTDIR}/cfg/base-modules-d.dat $upgrade_eservice_dir
       [ -f ${VAROPTDIR}/cfg/eservices-composite.conf ] && /usr/bin/cp -f ${VAROPTDIR}/cfg/eservices-composite.conf $upgrade_eservice_dir
       [ -f ${VAROPTDIR}/cfg/eservicedot.dat ] && /usr/bin/cp -f ${VAROPTDIR}/cfg/eservicedot.dat $upgrade_eservice_dir
               
   fi

}

#
# unset E*Service Addons
#
unset_eservice()
{
	# delete Service Availability Manager Composite Object
	/usr/bin/pkginfo -qi SUNWesses
	if [ $? -eq 0 ] ; then
		tmp_file="${ESROOT}/sbin/es-device"
		addon_wrapper "${tmp_file} -d ${VAROPTDIR}/cfg/eservices-composite.conf" > /dev/null 2>&1

		# delete /var/opt/SUNWsymon/cfg/eservices-composite.conf
		/bin/rm -fr ${VAROPTDIR}/cfg/eservices-composite.conf
		unset_help
	fi

	# delete /var/opt/SUNWsymon/cfg/eservicedot.dat file
	/bin/rm -fr ${VAROPTDIR}/cfg/eservicedot.dat

	# delete entry in dtable to remove the discovery table entry
	tmp_file="${ESROOT}/sbin/es-dt"
	addon_wrapper "${tmp_file} -d -l EServicesObject" > /dev/null 2>&1

	# back up base-modules-d.dat
	BASEFILE="${VAROPTDIR}/cfg/base-modules-d.dat"
	if [ -f "${BASEFILE}" ]; then
		${BASEDIR}/sbin/es-load-default -d -f ${BASEDIR}/addons/EServices/sbin/edot.minfo

		# delete other SE and ST module from base-modules-d.dat
		eservice_entry="httpST httpSE ftpST ftpSE dnsST dnsSE telnetST telnetSE smtpST smtpSE nisST nisSE ldapST ldapSE imapSE imapST popST popSE calendarST calendarSE"
		for  each_eservice_entry in $eservice_entry
		do 
			grep $each_eservice_entry ${VAROPTDIR}/cfg/base-modules-d.dat 2>&1 > /dev/null
			if [ $? -eq 0 ]; then
				grep -v $each_eservice_entry ${VAROPTDIR}/cfg/base-modules-d.dat > ${VAROPTDIR}/cfg/base-modules-d.dat.new
				mv ${VAROPTDIR}/cfg/base-modules-d.dat.new ${VAROPTDIR}/cfg/base-modules-d.dat
				/usr/bin/chmod 600 ${VAROPTDIR}/cfg/base-modules-d.dat
			fi
		done
	fi

        # remove line from .license.packs
        removeLicensePack "a Service Availability Manager"

	echolog 'Service Availability Manager AddOn unsetup successful'
	exit 0
}

######################################################
#
#  Main entry point
#
######################################################

BASEDIR=`/usr/bin/pkgparam SUNWescom BASEDIR`
if [ -z "${BASEDIR}" ]; then
    echo "No Components are installed..."
    exit 1
fi

. ${BASEDIR}/SUNWsymon/sbin/es-common.sh

set_commondirs
set_basedir
check_root

# this is needed, for a call to check_root in addon_setup
PROGNAME="$0"; export PROGNAME

tmp_file="${ESROOT}/addons/EServices/sbin/addon_common.sh"
if [ -n "${ESROOT}" ]; then
    if [ -r "${tmp_file}" ]; then
        . ${tmp_file}
    else
        /usr/bin/echo "${tmp_file} not readable."
        exit 1
    fi
else
    echo "Sun Management Center ESROOT not setup."
    exit 1
fi
setup_textdomain SUNW_SUNMC_SAM
process_eservice_agent_data "$Keep_Data"
unset_eservice
