#!/bin/sh 

#
# ident "@(#)gui-xc-plt-update-cfg.sh 1.12     03/11/19 SMI"
#
# Copyright (c) 2002 by Sun Microsystems, Inc.  All rights reserved.
#

# Set ESROOT.
BASEDIR=`/usr/bin/pkgparam SUNWescom BASEDIR`
if [ -z "${BASEDIR}" ]; then
    /usr/bin/echo "Sun Management Center not installed properly."
    exit 1
fi
ESROOT=$BASEDIR/SUNWsymon; export ESROOT


#
# Based on the final portion of es-setup-esscp.sh.  Changes made to
# es-setup-esscp.sh may need to be made to this script, and vice-versa.
#

usage() {
	/usr/bin/echo "Usage: $0 <sc_spare> <domain_port> <platform_server> <platform_port>"
	exit 1
}

if [ "$#" -ne 4 ]; then
	usage
fi

#
# Passed in variables
#
SC_SPARE="$1"
if [ "${SC_SPARE}" = "--" ]; then
	SC_SPARE=""
fi

DOMAIN_PORT="$2"
if [ "${DOMAIN_PORT}" = "--" ]; then
	DOMAIN_PORT=""
fi

PLATFORM_SERVER="$3"
if [ "${PLATFORM_SERVER}" = "--" ]; then
	PLATFORM_SERVER=""
fi

PLATFORM_PORT="$4"
if [ "${PLATFORM_PORT}" = "--" ]; then
	PLATFORM_PORT=""
fi


if [ -r "${ESROOT}/addons/SunFire15K_12K/sbin/addon_common.sh" ]; then
	. ${ESROOT}/addons/SunFire15K_12K/sbin/addon_common.sh
	addon_setup SUNWesscp
else
	# locale not setup
	/usr/bin/echo "${ESROOT}/addons/SunFire15K_12K/sbin/addon_common.sh not readable."
	exit 1
fi

#
# Local variables
#
sc=`/usr/bin/hostname`
sc_spare=''
symon_conf="/etc/opt/SUNWsymon/symon.conf"
default_agent_port=161
default_platform_port=166
default_domain_port="161"
default_platform_family_name="Sun-Fire-15000-platform"
dot_family="Sun-Fire-15000-platform-group"
# This is the good dot
dot_oid="1.3.6.1.4.1.42.2.85.1.1.1"
dfile=dtable.toe
port_changed=0
oids_file="/var/opt/SUNWsymon/cfg/platform-oids-d.dat"
es_dt_label="Sun-Fire-15000"

# Add the EFE module to platform-modules-d.dat
module_add efe platform-modules-d.dat "efe = \".iso.org.dod.internet.private.enterprises.sun.prod.starcat.sunmc.efe sun efe {module = \\\"efe\\\"; enterprise = \\\"sun\\\"; i18nModuleType = \\\"base.modules.efe:moduleType\\\"; moduleType = \\\"serverSupport\\\"; oid = \\\"1.3.6.1.4.1.42.2.85.1.4\\\"; i18nModuleName = \\\"base.modules.efe:moduleName\\\"; desc = \\\"base.modules.efe:mediumDesc.\\\"; location = \\\".iso.org.dod.internet.private.enterprises.sun.prod.starcat.sunmc.efe\\\"; moduleName = \\\"base.modules.efe:moduleName\\\"; version = \\\"1.0\\\"; i18nModuleDesc = \\\"base.modules.efe:moduleDesc\\\"; console = \\\"efe\\\"; instance = \\\"\\\"; }\""

# Add the scmonitor module to platform-modules-d.dat
module_add scmonitor platform-modules-d.dat "scmonitor = \".iso.org.dod.internet.private.enterprises.sun.prod.starcat.sunmc.scmonitor sun scmonitor {module = \\\"scmonitor\\\"; enterprise = \\\"sun\\\"; i18nModuleType = \\\"base.modules.scmonitor:moduleType\\\"; moduleType = \\\"localApplication\\\"; oid = \\\"1.3.6.1.4.1.42.2.85.1.5\\\"; location = \\\".iso.org.dod.internet.private.enterprises.sun.prod.starcat.sunmc.scmonitor\\\"; i18nModuleName = \\\"base.modules.scmonitor:moduleName\\\"; location = \\\".iso.org.dod.internet.private.enterprises.sun.prod.sunsymon.agent.modules.scmonitor\\\"; moduleName = \\\"SC Monitoring (Sun Fire 15K/12K)\\\"; version = \\\"1.0\\\"; i18nModuleDesc = \\\"base.modules.scmonitor:moduleDesc\\\"; console = \\\"scmonitor\\\"; instance = \\\"\\\"; }\""


# Remove PDSM from platform-modules-d.dat
# PDSM module is not pre-loaded by default. PDSM is unloadable.  Need
# to remove current entry of PDSM from platform-modules-d.dat, in case the
# user has loaded it. Note that PDSM has to be loaded *after* PCR.
# By automatically removing PDSM's entry at setup time we make sure
# that PCR is always loaded before PDSM
tmp_file=${tmp_dir}/pdsm.${PID}
module_name=pdsm
module_file=${VARDIR}/platform-modules-d.dat
/usr/bin/egrep -v "^[ 	]*${module_name}[ 	]*=" ${module_file} > ${tmp_file}

# move the tmp working copy to the module_file
/usr/bin/mv ${tmp_file} ${module_file}
if [ $? -ne 0 ]; then
	/usr/bin/echo "Unable to update ${module_file}"
	exit 1
fi
/usr/bin/echo "Removed pdsm from ${module_file}"


# Add the platform Config-Reader module to platform-modules-d.dat
module_add Config-ReaderStarcat platform-modules-d.dat "Config-ReaderStarcat = \".iso.org.dod.internet.private.enterprises.sun.prod.starcat.sunmc.ReaderStarcat sun Config-ReaderStarcat {enterprise = \\\"sun\\\"; module = \\\"Config-ReaderStarcat\\\"; i18nModuleType = \\\"base.modules.Config-ReaderStarcat:moduleType\\\"; moduleType = \\\"hardware\\\"; oid = \\\"1.3.6.1.4.1.42.2.85.1.1\\\"; desc = \\\"Config-Reader for Sun Fire 15K/12K Platform\\\"; i18nModuleName = \\\"base.modules.Config-ReaderStarcat:moduleName\\\"; location = \\\".iso.org.dod.internet.private.enterprises.sun.prod.starcat.sunmc.ReaderStarcat\\\"; moduleName = \\\"Config Reader (Sun Fire 15K/12K)\\\"; version = \\\"1.0\\\"; i18nModuleDesc = \\\"base.modules.Config-ReaderStarcat:moduleDesc\\\"; console = \\\"Config-ReaderStarcat\\\"; instance = \\\"\\\"; scSpare = \\\"$SC_SPARE\\\"; agentPort = \\\"$DOMAIN_PORT\\\";}\""

# Add the scstatus module to base-modules-d.dat
module_add scstatus base-modules-d.dat "scstatus = \".iso.org.dod.internet.private.enterprises.sun.prod.starcat.sunmc.scstatus sun scstatus {module = \\\"scstatus\\\"; enterprise = \\\"sun\\\"; i18nModuleType = \\\"base.modules.scstatus:moduleType\\\"; moduleType = \\\"localApplication\\\"; oid = \\\"1.3.6.1.4.1.42.2.85.1.8\\\"; i18nModuleName = \\\"base.modules.scstatus:moduleName\\\"; location = \\\".iso.org.dod.internet.private.enterprises.sun.prod.starcat.sunmc.scstatus\\\"; moduleName = \\\"SC Status\\\"; version = \\\"1.0\\\"; i18nModuleDesc = \\\"base.modules.scstatus:moduleDesc\\\"; console = \\\"scstatus\\\"; usedefault = \\\"false\\\"; instance = \\\"\\\"; scOtherSC = \\\"$SC_SPARE\\\";}\""


# update symon.conf
#echolog ''
/usr/bin/rm -f ${symon_conf}.${PID}
if [ -w ${symon_conf} ]; then
	/usr/bin/grep -v "Sun-Fire-15000" ${symon_conf} > ${symon_conf}.${PID}
fi
/usr/bin/echo 'platform Sun-Fire-15000' >> ${symon_conf}.${PID}
/usr/bin/mv ${symon_conf}.${PID} ${symon_conf} || echolog 'Error setting up ${symon_conf}.'
echolog 'Updated symon.conf information.'

# attempt to remove entry with label, failure is ok, suppress error messages
addon_wrapper "${ESROOT}/sbin/es-dt" -d -l "${es_dt_label}" > /dev/null 2>&1

addon_wrapper "${ESROOT}/sbin/es-dt" -a -h "${PLATFORM_SERVER}" -p "${PLATFORM_PORT}" -o "${dot_oid}" -n "${dot_family}" -l "${es_dt_label}"

if [ $? -ne 0 ] ; then
	#echolog ''
	echolog 'Failed to Update Discovery Table information via es-dt'
	exit 1
else
	#echolog ''
	echolog 'Updated Discovery Table information via es-dt'
fi

#
# blow away the /var/opt/SUNWsymon/cfg/platform-oids-d.dat file
# to insure that the module oids are correct for this
# version of the data model.
#
tmp_file="${oids_file}"
if [ -f ${tmp_file} ] ; then
	/usr/bin/rm -f ${tmp_file}
	if [ -f ${tmp_file} ]; then
		echolog 'Could not remove ${tmp_file}.'
	fi
fi

# Create Smart Update config file, interactive mode.
SCPCFG="${VARDIR:-/var/opt/SUNWsymon/cfg}/esscp.config"
verbose_smartupdate_cfgfile "$SCPCFG" rw
create_starcat_platform_config "$SCPCFG" "$DOMAIN_PORT" "$SC_SPARE"
