<%-- createchannel.jsp --%>
<%@ page import="com.sun.portal.providers.containers.jsp.single.JSPSingleContainerProvider,
                 com.sun.portal.providers.containers.jsp.table.JSPTableContainerProvider,
                 java.util.List,
                 java.util.Map,
                 java.util.ArrayList"
%>

<%@ page contentType="text/html; charset=UTF-8" %>
<%@ page session="false" %>

<%
	// Get the container to create channel in.
	JSPSingleContainerProvider scp = (JSPSingleContainerProvider)pageContext.getAttribute("JSPProvider");
	String container = (String)request.getParameter("container");
	JSPTableContainerProvider tcp = (JSPTableContainerProvider)scp.getContainerProviderContext().getProvider(request, scp.getName(), container);

	// Create a unique channel name.
	String channelName = "userchan_" +System.currentTimeMillis();

	// Get the request params.
	String channelTitle = request.getParameter("channelTitle");
	String channelDescription = request.getParameter("channelDescription");
	String providerName = request.getParameter("providerName");
	String category = request.getParameter("category");
	Boolean autoSelectChannel = new Boolean(request.getParameter("autoSelectChannel"));
	List localeFilters = tcp.getProviderContext().getLocalePropertiesFilters(); 

	// Create the channel.
	tcp.getContainerProviderContext().createChannel(channelName, providerName);

	
	// Add the channel to userDefinedChannels.
	if (tcp.getProviderContext().existsCollectionProperty("JSPCreateChannelContainer","userDefinedChannels")) {
		Map m =tcp.getContainerProviderContext().getCollectionProperty(tcp.getName(),"userDefinedChannels");
		List userDefinedChannels =new ArrayList(m.values());
		userDefinedChannels.add(channelName);
		tcp.getProviderContext().setCollectionProperty(tcp.getName(),"userDefinedChannels",userDefinedChannels);
		
	}

	// Set channel properties.
  tcp.getProviderContext().setStringProperty(channelName, "description", channelDescription);
  tcp.getProviderContext().setStringProperty(channelName, "title", channelTitle);

	// Add the Channel created to the correct category.  Category is a property of the table container 
	// and you cannot assume a particular container has the category property.
	if (tcp.getProviderContext().existsCollectionProperty(container, category,localeFilters)) {
		Map m =tcp.getProviderContext().getCollectionProperty(container,category,localeFilters);
	        List channelsInCategory =new ArrayList(m.values());
		channelsInCategory.add(channelName);
	        tcp.getProviderContext().setCollectionProperty(container,category,channelsInCategory,localeFilters);
	}
	
	// Add the created channel to available channels list
	List l =tcp.getAvailableChannels();
	l.add(channelName);
	tcp.setAvailableChannels(l);

	// If user indicated "Yes" to "Channel Automatically Selected" (this is the default),
	// add the created channel to selected channels list.
	if (autoSelectChannel.booleanValue()) {
		l =tcp.getSelectedChannels();
		l.add(channelName);
		tcp.setSelectedChannels(l);
	}
%>
