<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" indent="yes"/>

<xsl:template match="/">
<html>
<head>
</head>
<body>
<table bgcolor="#ffffff" cellpadding="2" border="0" cellspacing="0">
<xsl:for-each select="market-data/quote-set/quote">
	<tr> 
		<td bgcolor="#9999CC" colspan="2" width="40%" nowrap="yes">
					<font color="#ffffff">
					<b><xsl:value-of select="./@name"/></b>
					</font>
		</td>
		<td bgcolor="#9999CC" width="20%" fgcolor="#ffffff"><br /></td>
		<td width="40%" align="right" colspan="2" bgcolor="#9999CC" ><font color="#ffffff">
			<xsl:value-of select="./@exchange-code"/>, <xsl:value-of select="./@hyperfeed-time"/></font>
		</td>
	</tr>

	<tr>
		<td width="40%">마지막 거래가</td>
		<td nowrap="yes" align="right"><b><xsl:value-of select="./@last"/></b></td>
		<td width="15%"><br /></td>
		<td width="40%">시가</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@open"/></td>
	</tr>

	<tr>
		<td width="40%">전일대비</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@change"/></td>
		<td width="10"><br /></td>
		<td width="40%">전일가</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@close"/></td>
	</tr>

	<tr>
		<td width="40%">등락율(%)</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@percent-change"/></td>
		<td width="10"><br /></td>
		<td width="40%">매도호가</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@bid"/></td>
	</tr>

	<tr>
		<td width="40%">거래량</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@volume"/></td>
		<td width="10"><br /></td>
		<td width="40%">매수호가</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@ask"/></td>
		</tr>

	<tr>
		<td width="40%">고가</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@high"/></td>
		<td width="10"><br /></td>
		<td width="40%">52주 최고가</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@high-52-week"/></td>
	</tr>

	<tr>
		<td width="40%">저가</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@low"/></td>
		<td width="10"><br /></td>
		<td width="40%">52주 최저가</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@low-52-week"/></td>
	</tr>
</xsl:for-each>
</table>
</body>
</html>
</xsl:template>
</xsl:stylesheet>
