<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" indent="yes"/>

<xsl:template match="/">
<html>
<head>
</head>
<body>
<table bgcolor="#ffffff" cellpadding="2" border="0" cellspacing="0">
<xsl:for-each select="market-data/quote-set/quote">
	<tr> 
		<td bgcolor="#9999CC" colspan="2" width="40%" nowrap="yes">
					<font color="#ffffff">
					<b><xsl:value-of select="./@name"/></b>
					</font>
		</td>
		<td bgcolor="#9999CC" width="20%" fgcolor="#ffffff"><br /></td>
		<td width="40%" align="right" colspan="2" bgcolor="#9999CC" ><font color="#ffffff">
			<xsl:value-of select="./@exchange-code"/>, <xsl:value-of select="./@hyperfeed-time"/></font>
		</td>
	</tr>

	<tr>
		<td width="40%">終値</td>
		<td nowrap="yes" align="right"><b><xsl:value-of select="./@last"/></b></td>
		<td width="15%"><br /></td>
		<td width="40%">始値</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@open"/></td>
	</tr>

	<tr>
		<td width="40%">前日比</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@change"/></td>
		<td width="10"><br /></td>
		<td width="40%">前日終値</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@close"/></td>
	</tr>

	<tr>
		<td width="40%">前日比 %</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@percent-change"/></td>
		<td width="10"><br /></td>
		<td width="40%">買い気配値</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@bid"/></td>
	</tr>

	<tr>
		<td width="40%">出来高</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@volume"/></td>
		<td width="10"><br /></td>
		<td width="40%">売り気配値</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@ask"/></td>
		</tr>

	<tr>
		<td width="40%">本日の最高値</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@high"/></td>
		<td width="10"><br /></td>
		<td width="40%">52 週最高値</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@high-52-week"/></td>
	</tr>

	<tr>
		<td width="40%">本日の最安値</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@low"/></td>
		<td width="10"><br /></td>
		<td width="40%">52 週最安値</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@low-52-week"/></td>
	</tr>
</xsl:for-each>
</table>
</body>
</html>
</xsl:template>
</xsl:stylesheet>
