<%--
  Copyright 2003 Sun Microsystems, Inc. All rights reserved 
  Use is subject to license terms.
 --%>
<%@page language= "java" import="com.sun.portal.search.demo.Search, 
				com.sun.portal.search.soif.*, 
				com.sun.portal.search.soif.SOIFOutputStream, 
				com.sun.portal.search.soif.SOIFInputStream, 
				java.net.*, java.lang.*, 
				java.util.Random, java.util.Date" %> 
				
<%-- @(#)feedbackProcess.jsp --%>

<%@ taglib uri="/tld/jx.tld" prefix="jx" %>
<%@ taglib uri="/tld/desktop.tld" prefix="dt" %>
<%@ taglib uri="/tld/desktopProviderContext.tld" prefix="dtpc" %>

<%
boolean inheritClassification=false;
boolean inheritReadACL=false;

String title;
String rid="", database= "";
title = request.getParameter("title");
if (title == null || (title.equals(""))) {
    throw new Exception("Discussions : commentaire non valide car il ne porte pas de titre.");
}

// Extract all form fields. check if the submission is a 
// newTopic or comment or ratingType
// extract rid, title,desc,rating from the request
String desc= "", rating="";
boolean newTopic=false;
SOIF parentrd = new SOIF();
String parentRid=""; 
if (request.getParameter("desc") != null) 
    desc = request.getParameter("desc");
if (request.getParameter("rtg") != null) 
    rating = request.getParameter("rtg");
%>

<dt:obtainChannel channel="$JSPProvider">
<dtpc:providerContext>
<dtpc:getStringProperty key="searchServer" id="searchServer"/>
<dtpc:getSessionID id="accessToken"/>
<dtpc:getStringProperty key="dbname" id="dbname"/>
<dtpc:getStringAttribute key="commonname" id="gn"/>
<dtpc:getUserID id="authorId"/>

<jx:declare id="searchServer" type="java.lang.String"/>
<jx:declare id="accessToken" type="java.lang.String"/>
<jx:declare id="dbname" type="java.lang.String"/>
<jx:declare id="gn" type="java.lang.String"/>
<jx:declare id="authorId" type="java.lang.String"/>

<%
AVPair parentReadACL = new AVPair("readACL");
AVPair parentClassification = new AVPair("classification");

rid = request.getParameter("rid");
if (rid == null || rid.equals("")) {
    newTopic = true;
} else {
    // Retrieve the existing document from the search database
    if (request.getParameter("database") != null) {
	database = request.getParameter("database");
    } else {
	// assume default database
    }

    String query = "URL = "+rid;
    Search search = new Search(query, "","",1,5,"search",database,searchServer,accessToken);
    search.doQuery(1,5);
    SOIFInputStream is = search.getResultStream();

    if (is != null) {
	parentrd = is.readSOIF();
	if (parentrd == null) 
	   throw new Exception("Discussions : description de ressources parente introuvable dans la base de données "+database+"");

	// extract parent reference id field
	parentRid = parentrd.getValue("rd-reference-id");
	parentReadACL = parentrd.getAVPair("readACL");
	parentClassification = parentrd.getAVPair("classification");
    } else {
       throw new Exception("Discussions : échec de lecture du flux d'entrée");
    }
}

// Start processing parent data
String childurl = "comment"+(new Random().nextInt());
SOIF childrd = new SOIF("DOCUMENT", childurl);
String childRid = "";

if (newTopic) {
    childRid = "ROOT "+childurl;
} else if (parentRid == null || parentRid.equals("")) {
    // Happens when comments are added from search interface 
    // if parent has no Rid or if rid field is empty
    // update the child's reference_url field
    childRid = "ROOT "+childurl;
    childrd.insert("rd-reference-url", parentrd.getURL());
    // for JSP return page - go back to fullDiscussion.jsp
    rid = "";
} else {
    if (parentRid.indexOf("ROOT ") >= 0) {
       // First child - remove the 'ROOT' and add to childRid
       int i = parentRid.indexOf("ROOT");
       childRid = parentRid.substring(i+5)+" "+childurl;
    } else {
       childRid = parentRid+" "+childurl;
    }
}

childrd.insert("title", title);
childrd.insert("description", desc);
childrd.insert("partial-text", desc);
childrd.insert("Author", gn);
childrd.insert("rd-reference-id", childRid);
childrd.insert("rd-Author-id", authorId);

int newrating = (Integer.parseInt(rating))/(1+1);
childrd.insert("rd-rating", newrating+"");
childrd.insert("rd-peak-rating", rating);
childrd.insert("rd-sum-rating", rating);
childrd.insert("rd-num-rating", "1");

String modifiedDate = (new Date()).toString();
childrd.replace("last-modified", modifiedDate);

if (inheritClassification && parentClassification != null) {
    childrd.insert(parentClassification);
}

if (inheritReadACL && parentReadACL != null) {
    childrd.insert(parentReadACL);
} else {
    childrd.insert("readACL", "");
}

try {
    URLConnection pc = new URL((String)pageContext.findAttribute("searchServer")).openConnection();
    pc.setAllowUserInteraction(true);
    pc.setUseCaches(false);
    pc.setDoOutput(true);
    pc.setDoInput(true);
    SOIFOutputStream sos = new SOIFOutputStream(pc.getOutputStream()); 
    //SOIFOutputStream sos = new SOIFOutputStream("/tmp/comment.soif", "UTF-8");
    pc.connect();

    SOIF hdr = new SOIF("RDMHEADER", "-");
    hdr.insert("rdm-type", "rd-submit-request");
    hdr.insert("rdm-access-token", accessToken);
    hdr.insert("submit-database", dbname);
    sos.write(hdr); 

    SOIF req = new SOIF("Request", "-");
    req.insert("submit-type", "nonpersistent"); 
    req.insert("submit-operation", "insert"); 
    sos.write(req);
    sos.write(childrd);
    sos.close();

    SOIFInputStream sis = new SOIFInputStream(pc.getInputStream());
    SOIF s; 
    while ((s = sis.readSOIF()) != null)  { %>
	soif: <%=s%> <br>
    <% }
    Thread.sleep(500);
} catch (Exception e) {
    throw new Exception("Discussions : impossible d'envoyer des commentaires. Échec de la connexion à "+searchServer);
}
%>
</dtpc:providerContext>
</dt:obtainChannel>

