<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" indent="yes"/>

<xsl:template match="/">
<html>
<head>
</head>
<body>
<table bgcolor="#ffffff" cellpadding="2" border="0" cellspacing="0">
<xsl:for-each select="market-data/quote-set/quote">
	<tr> 
		<td bgcolor="#ffffff" colspan="2" width="40%" nowrap="yes">
					<font color="#000000">
					<b><xsl:value-of select="./@name"/></b>
					</font>
		</td>
		<td bgcolor="#ffffff" width="20%" fgcolor="#000000"><br /></td>
		<td width="40%" align="right" colspan="2" bgcolor="#ffffff" ><font color="#000000">
			<xsl:value-of select="./@exchange-code"/>, <xsl:value-of select="./@hyperfeed-time"/></font>
		</td>
	</tr>

	<tr>
		<td width="40%"> letzten </td>
		<td nowrap="yes" align="right"><b><xsl:value-of select="./@last"/></b></td>
		<td width="15%"><br /></td>
		<td width="40%">Öffnen</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@open"/></td>
	</tr>

	<tr>
		<td width="40%">Ändern</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@change"/></td>
		<td width="10"><br /></td>
		<td width="40%">Letzter Schlusskurs</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@close"/></td>
	</tr>

	<tr>
		<td width="40%">% Änderung</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@percent-change"/></td>
		<td width="10"><br /></td>
		<td width="40%">Angebot</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@bid"/></td>
	</tr>

	<tr>
		<td width="40%">Umfang</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@volume"/></td>
		<td width="10"><br /></td>
		<td width="40%">Preisangebot</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@ask"/></td>
		</tr>

	<tr>
		<td width="40%">Höchster Tageskurs</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@high"/></td>
		<td width="10"><br /></td>
		<td width="40%">Höchster Kurs in 52 Wochen</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@high-52-week"/></td>
	</tr>

	<tr>
		<td width="40%">Niedrigster Tageskurs</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@low"/></td>
		<td width="10"><br /></td>
		<td width="40%">Niedrigster Kurs in 52 Wochen</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@low-52-week"/></td>
	</tr>
</xsl:for-each>
</table>
</body>
</html>
</xsl:template>
</xsl:stylesheet>

