<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" indent="yes"/>

<xsl:template match="/">
<html>
<head>
</head>
<body>
<table bgcolor="#ffffff" cellpadding="2" border="0" cellspacing="0">
<xsl:for-each select="market-data/quote-set/quote">
	<tr>
		<td bgcolor="#9999CC" colspan="2" width="40%" nowrap="yes">
					<font color="#ffffff">
					<b><xsl:value-of select="./@name"/></b>
					</font>
		</td>
		<td bgcolor="#9999CC" width="20%" fgcolor="#ffffff"><br /></td>
		<td width="40%" align="right" colspan="2" bgcolor="#9999CC" ><font color="#ffffff">
			<xsl:value-of select="./@exchange-code"/>, <xsl:value-of select="./@hyperfeed-time"/></font>
		</td>
	</tr>

	<tr>
		<td width="40%">前一</td>
		<td nowrap="yes" align="right"><b><xsl:value-of select="./@last"/></b></td>
		<td width="15%"><br /></td>
		<td width="40%">打开</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@open"/></td>
	</tr>

	<tr>
		<td width="40%">更改</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@change"/></td>
		<td width="10"><br /></td>
		<td width="40%">上次收盘价</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@close"/></td>
	</tr>

	<tr>
		<td width="40%">% 更改</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@percent-change"/></td>
		<td width="10"><br /></td>
		<td width="40%">买方报价</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@bid"/></td>
	</tr>

	<tr>
		<td width="40%">数量</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@volume"/></td>
		<td width="10"><br /></td>
		<td width="40%">卖方报价</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@ask"/></td>
		</tr>

	<tr>
		<td width="40%">日高点</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@high"/></td>
		<td width="10"><br /></td>
		<td width="40%">52 星期中的高点</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@high-52-week"/></td>
	</tr>

	<tr>
		<td width="40%">日低点</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@low"/></td>
		<td width="10"><br /></td>
		<td width="40%">52 星期中的低点</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@low-52-week"/></td>
	</tr>
</xsl:for-each>
</table>
</body>
</html>
</xsl:template>
</xsl:stylesheet>
