<?xml version="1.0" encoding="UTF-8" ?>

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- set the output properties -->
<xsl:output method="html" version="4" encoding="UTF-8"/>

<!-- Include main display XSL instructions -->
<xsl:include href="common_view.xsl"/>

<!-- componentlist PROCESSING -->
<xsl:template match="componentlist">
  <xsl:choose>
    <xsl:when test="count(./ComponentGroup)=0">
      <TD bgcolor="{$bgcolor_form_selected}"><P/>
      	<FONT face="{$font_name}" size="{$font_size_big_2}">
      		<B>
      			无事件或任务
      		</B>
      	</FONT>
      	<P/>
      	<xsl:text>&nbsp;</xsl:text>
      </TD>
    </xsl:when>
    <xsl:otherwise>
      <TD bgcolor="{$bgcolor_form_selected}">
      <!-- For Each ComponentGroup on this canvas, list appropriately -->
  	  	<xsl:for-each select="./ComponentGroup">
    		<xsl:call-template name="ComponentGroup"/>
  		</xsl:for-each>
  	  </TD>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="Task">
<!-- Don't do anything with future tasks here -->
  <xsl:if test="not(@futuredue)">
    <xsl:call-template name="List_Task">       
    <xsl:with-param name="delete">true</xsl:with-param>
    </xsl:call-template> 
  </xsl:if>
</xsl:template>

<xsl:template match="Event">
    <xsl:call-template name="List_Event">
    	<xsl:with-param name="delete">true</xsl:with-param>
    </xsl:call-template>
</xsl:template>

<xsl:template name="futureTask">
<br/>
<font face="{$font_name}" size="{$font_size_big_2}">
  <A>
    <xsl:attribute name="href">
      <xsl:value-of select="edit_command"/>
    </xsl:attribute>
    <xsl:value-of select="@e_Summary"/>
  </A>
</font>
</xsl:template>

<xsl:template match="panel">
<!--  <xsl:value-of select="@name"/><br/> -->
  <xsl:choose>
    <xsl:when test="@name='singleDayTimeHeader'">
      <TR>
      <TD align="left">
        <xsl:call-template name="singleDayTimeHeaderTemplate"/>
      </TD>
      <TD align="right" valign="bottom">
          <xsl:call-template name="viewtabs"/>        
      </TD>
      </TR>
    </xsl:when>

    <xsl:when test="@name='singleDayView'">
      <TR>
      <TD colspan="2">
       <TABLE border="0" cellpadding="1" cellspacing="0" width="100%">
        <TR>
          <TD bgcolor="{$bgcolor_table_border}">
            <TABLE border="0" cellpadding="6" cellspacing="1" width="100%">
              <TR>
                <xsl:apply-templates select="componentlist"/>
              </TR>
            </TABLE>
          </TD>
        </TR>
      </TABLE>
     </TD>
     </TR>
    </xsl:when>

    <xsl:when test="@name='miniview'">
        <xsl:apply-templates select="panel"/>
        <HR size="{$font_size_big}"/>
    </xsl:when>
 
    <xsl:when test="@name='minical'">
      <xsl:apply-templates select="minical"/>
    </xsl:when>

    <xsl:when test="@name='tasktable'">
      <xsl:call-template name="tasktable"/>
    </xsl:when>

    <xsl:when test="@name='weekahead'">
      <TR>
      <TD colspan="2">
       <xsl:call-template name="weekaheadTemplate"/>        
      </TD>
      </TR>
    </xsl:when>

    <xsl:otherwise>
      <TABLE border="0">
       <xsl:apply-templates select="panel"/> 
      </TABLE>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

</xsl:stylesheet>
