<?xml version="1.0"?>

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- set the output properties -->
<xsl:output method="html" encoding="UTF-8"/>

<xsl:include href="common.xsl"/>
<xsl:include href="i18n.xsl"/>
<xsl:include href="date_format.xsl"/>
<xsl:include href="dialog_tabs.xsl"/>
<xsl:include href="event_tabs.xsl"/>


<xsl:template match="/">
  <xsl:apply-templates select="calendar"/>      
</xsl:template>

<xsl:template match="calendar">

  <xsl:variable name="tab_value"><xsl:value-of select="@tab"/></xsl:variable>
  <xsl:choose>
    <xsl:when test="@top='true'">

    <xsl:variable name="Frame1"><xsl:value-of select="frame[1]"/></xsl:variable>
    <xsl:variable name="Frame2"><xsl:value-of select="frame[2]"/></xsl:variable>
    <xsl:variable name="Frame3"><xsl:value-of select="frame[3]"/></xsl:variable>

    <HTML>
    <HEAD>
<!--    <xsl:call-template name="contextJavascript"/> -->
        <xsl:call-template name="javascript_vars"/>
        <SCRIPT SRC="js_context.js">alert('NotFound');</SCRIPT>

    <TITLE>编辑事件：Sun Java[tm] System Calendar Express</TITLE>
    </HEAD>
    <FRAMESET border="0" frameborder="0" rows="40,*,40">
      <FRAME name="tab" marginheight="0" marginwidth="0" scrolling="no" scrollbars="no" src="{$Frame1}"/>
      <FRAME name="main" frameborder="0" src="{$Frame2}"/>
      <FRAME name="button" marginheight="0" marginwidth="0" scrolling="no" scrollbars="no" frameborder="0" src="{$Frame3}"/>
    </FRAMESET>
    </HTML>

    </xsl:when>

    <xsl:when test="@view='tabs'">
      <xsl:for-each select="group">
        <xsl:if test="@name='tabs'">
          <xsl:call-template name="tabs_root"/>
        </xsl:if>
      </xsl:for-each>
    </xsl:when>

    <xsl:when test="@view='main'">
      <xsl:for-each select="group">
        <xsl:if test="@name='main'">
          <xsl:choose>

            <xsl:when test="number(/calendar/@tab) = 1">
              <xsl:call-template name="main_root"/>
            </xsl:when>

            <xsl:when test="number(/calendar/@tab) = 3">
              <xsl:call-template name="reminders_root"/>
            </xsl:when>

            <xsl:when test="number(/calendar/@tab) = 6">
              <xsl:call-template name="preview_root"/>
            </xsl:when>

            <xsl:otherwise>
              <B>Can not find this tab value is "<xsl:value-of select="/calendar/@tab"/>"</B>   
            </xsl:otherwise>
          </xsl:choose>
        </xsl:if>
      </xsl:for-each>
    </xsl:when>

    <xsl:when test="@view='button'">
      <xsl:for-each select="group">
        <xsl:if test="@name='button'">
          <xsl:call-template name="button_root"/>      
        </xsl:if>
      </xsl:for-each>
    </xsl:when>

    <xsl:otherwise>
      <html>What's this view? (new_event.xsl) -<xsl:value-of select="@view"/></html>
    </xsl:otherwise>

  </xsl:choose>
</xsl:template>

<xsl:template name="NewEventCalendarGroupSelector">
  <FONT face="{$font_name}" size="{$font_size_big_2}">
  <SELECT name="calgroup">
    <xsl:attribute name="onChange">return parent.NewEventGroupInvite(this.options, this.selectedIndex, this);</xsl:attribute>

    <OPTION value="">---快速邀请---<xsl:attribute name="selected"/></OPTION>
    <xsl:if test="(not(/calendar/usrctx/calendarList/calID[@name=/calendar/usrctx/@selectedCalendar])) and (not(/calendar/usrctx/usergroup[@name=/calendar/usrctx/@selectedGroup]))">
      <OPTION value="temporary" selected="" >
          <xsl:call-template name="printCalendarName">
            <xsl:with-param name="name" select="/calendar/usrctx/@selectedCalendar"/>
          </xsl:call-template>
      </OPTION>
    </xsl:if>
    <xsl:for-each select="/calendar/usrctx/calendarList/calID">
      <xsl:if test="not(@error)">
        <OPTION>
          <xsl:attribute name="value"><xsl:value-of select="./@name"/></xsl:attribute>
<!-- Set the selected to Quick Invite always 
          <xsl:if test="/calendar/usrctx/@selectedCalendar = ./@name"><xsl:attribute name="selected"/></xsl:if>
-->
          <xsl:call-template name="printCalendarName">
            <xsl:with-param name="name" select="./@name"/>
            <xsl:with-param name="printname" select="./@printableName"/>
          </xsl:call-template>
        </OPTION>
      </xsl:if>
    </xsl:for-each>
    <OPTION value=""><xsl:text>________________________</xsl:text></OPTION>

    <xsl:for-each select="/calendar/usrctx/usergroup">
      <OPTION>
        <xsl:attribute name="value"><xsl:value-of select="./@members"/></xsl:attribute>
        <xsl:if test="../@selectedGroup = ./@name"><xsl:attribute name="selected"/></xsl:if>
        组：<xsl:text> </xsl:text>
        <xsl:call-template name="printCalendarName">
          <xsl:with-param name="name" select="./@name"/>
        </xsl:call-template>
      </OPTION>
    </xsl:for-each>
  </SELECT>
  </FONT>
</xsl:template>


<xsl:template name="main_root">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>
<!--  <xsl:call-template name="javascript_accept_users"/> -->
<!-- load the javascript support -->
  <SCRIPT SRC="js_accept_invite.js">alert('notfound!');</SCRIPT>
<!--  <xsl:call-template name="dateChecking"/> -->
    <xsl:call-template name="javascript_strings"/>
    <SCRIPT SRC="js_date_checking.js">alert('NotFound!');</SCRIPT>

<BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="9" marginheight="9">
 <xsl:attribute name="onload">
    <xsl:choose>
     <xsl:when test="(string-length(../eventdata/Event/@e_Summary) = 0)">
       document.forms[0].summary.focus();
     </xsl:when>
     <xsl:otherwise>
       document.forms[0].invitee.focus();
     </xsl:otherwise>
    </xsl:choose>
  </xsl:attribute>

<FORM method="post">
  <xsl:attribute name="action"><xsl:value-of select="./formdata/@action"/></xsl:attribute>
  <xsl:attribute name="name">form</xsl:attribute>
  <xsl:apply-templates select="formdata"/>
  <INPUT type="hidden" name="mass_invite" value=""/>
  <INPUT type="hidden" name="mass_inform" value=""/>
<INPUT type="hidden" name="absalarmset"><xsl:attribute name="value"><xsl:value-of select="../eventdata/Event/@e_alarm_absolute_trigger"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="firstyear"><xsl:attribute name="value"><xsl:value-of select="../eventdata/Event/AbsoluteAlarmTime/@year"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="firstmonth"><xsl:attribute name="value"><xsl:value-of select="../eventdata/Event/AbsoluteAlarmTime/@month"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="firstday"><xsl:attribute name="value"><xsl:value-of select="../eventdata/Event/AbsoluteAlarmTime/@date"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="firsthour"><xsl:attribute name="value"><xsl:value-of select="../eventdata/Event/AbsoluteAlarmTime/@hour"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="firstminute"><xsl:attribute name="value"><xsl:value-of select="../eventdata/Event/AbsoluteAlarmTime/@minute"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="secondyear"><xsl:attribute name="value"><xsl:value-of select="../eventdata/Event/StartTime/@year"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="secondmonth"><xsl:attribute name="value"><xsl:value-of select="../eventdata/Event/StartTime/@month"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="secondday"><xsl:attribute name="value"><xsl:value-of select="../eventdata/Event/StartTime/@date"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="secondhour"><xsl:attribute name="value"><xsl:value-of select="../eventdata/Event/StartTime/@hour"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="secondminute"><xsl:attribute name="value"><xsl:value-of select="../eventdata/Event/StartTime/@minute"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="isallday"><xsl:attribute name="value"><xsl:value-of select="../eventdata/Event/@e_allday"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="isprivate"><xsl:attribute name="value"><xsl:choose><xsl:when test="(../eventdata/Event/@e_Class = 'private')">1</xsl:when><xsl:otherwise>0</xsl:otherwise></xsl:choose></xsl:attribute></INPUT>
<INPUT type="hidden" name="isopaque"><xsl:attribute name="value"><xsl:choose><xsl:when test="(../eventdata/Event/@e_opaque = 'true')">1</xsl:when><xsl:otherwise>0</xsl:otherwise></xsl:choose></xsl:attribute></INPUT>

<CENTER>
<TABLE border="0" cellpadding="3" cellspacing="1">
<!-- Insert errors here-->
<xsl:call-template name="emit_new_event_errors"/>
    <TR>
    <TD colspan="2"  align="right"><FONT face="{$font_name}" size="{$font_size_big_2}">
         <B>日历<xsl:text>&nbsp;</xsl:text></B>
     <xsl:variable name="selectedCalid">
       <xsl:value-of select="../eventdata/Event/@e_Calid"/>
     </xsl:variable>
     <xsl:variable name="defaultCalid">
      <xsl:for-each select="/calendar/usrctx/calendarList/calID">
       <xsl:if test="$selectedCalid = @name">
        <xsl:choose>
         <xsl:when test="(string-length(@error) > 0) or (string-length(@permission) > 0)">
          <xsl:value-of select="/calendar/usrctx/user/@name"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="@name"/>
        </xsl:otherwise>
        </xsl:choose>
       </xsl:if>
      </xsl:for-each>
     </xsl:variable>

     <xsl:choose>
     <xsl:when test="(../eventdata/Event/@e_isNewEvent = 'true')">
       <SELECT name="new_org_calid">
       <xsl:for-each select="/calendar/usrctx/calendarList/calID">
	<xsl:if test="(string-length(@error) = 0) and (string-length(@permission) = 0)">
         <OPTION value="{@name}">
           <xsl:call-template name="printCalendarName">
            <xsl:with-param name="name" select="@name"/>
            <xsl:with-param name="printname" select="@printableName"/>
           </xsl:call-template>
           <xsl:if test="$defaultCalid = @name">
             <xsl:attribute name="selected"/>
           </xsl:if>
         </OPTION>
        </xsl:if>
       </xsl:for-each>

       <xsl:attribute name="onChange">
       var f = parent.frames[1].document.forms[0];
       f['myaction'].value='change_calendar';
       f.submit();
     </xsl:attribute>
     </SELECT>
     </xsl:when>
     <xsl:otherwise>
     <xsl:variable name="orgCalid">
       <xsl:value-of select="../eventdata/Event/@e_org_Calid"/>
     </xsl:variable>
       <SELECT name="new_org_calid">
       <xsl:for-each select="/calendar/usrctx/calendarList/calID">
	<xsl:if test="(string-length(@error) = 0) and ((string-length(@permission) = 0) or ($orgCalid = @name))">
         <OPTION value="{@name}">
           <xsl:call-template name="printCalendarName">
             <xsl:with-param name="name" select="@name"/>
             <xsl:with-param name="printname" select="@printableName"/>
           </xsl:call-template>
           <xsl:if test="$selectedCalid = @name">
             <xsl:attribute name="selected"/>
           </xsl:if>
         </OPTION>
        </xsl:if>
       </xsl:for-each>

       <xsl:attribute name="onChange">
       var f = parent.frames[1].document.forms[0];
       f['myaction'].value='change_calendar';
       f.submit();
     </xsl:attribute>
     </SELECT>
     </xsl:otherwise>
     </xsl:choose>

    </FONT>
    </TD>
    </TR>
    <TR>
    <TD align="right" valign="baseline"><FONT face="{$font_name}" size="{$font_size_big_2}"><B>事件标题</B></FONT></TD>
    <TD valign="baseline"><INPUT type="text" name="summary" size="42" >
      <xsl:attribute name="value">
        <xsl:choose>
          <xsl:when test="(../eventdata/Event/@e_isNewEvent = 'true') and (string-length(../eventdata/Event/@e_Summary) = 0)">
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="../eventdata/Event/@e_Summary_urlencoded"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:attribute>
    </INPUT></TD>
  </TR>
  <TR>
    <TD colspan="2" align="left" valign="baseline">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <xsl:call-template name="outputSpecificError">
          <xsl:with-param name="Type">INVALID_STARTDATETIME</xsl:with-param>
        </xsl:call-template>
      </FONT>
    </TD>
  </TR>
  <TR>
    <TD align="right" valign="baseline"><FONT face="{$font_name}" size="{$font_size_big_2}"><B>日期</B></FONT></TD>
    <TD valign="baseline" nowrap="">
      <xsl:call-template name="date_selector">
        <xsl:with-param name="month" select="../eventdata/Event/StartTime/@month" />
        <xsl:with-param name="day" select="../eventdata/Event/StartTime/@date" />
        <xsl:with-param name="year" select="../eventdata/Event/StartTime/@year" />
      </xsl:call-template>
      <A>
        <xsl:attribute name="href">
          <xsl:value-of select="command[@name='jump_to']"/>
        </xsl:attribute>
        <IMG src="imx/goto2.gif" width="24" height="24" align="absmiddle" border="0" alt="跳至新日期"/>
      </A>
     </TD>
     </TR>
  <TR>
    <TD align="right" valign="baseline"><FONT face="{$font_name}" size="{$font_size_big_2}"><B>时间</B></FONT></TD>
    <TD valign="baseline" nowrap="">
      <INPUT type="radio" name="allday" value="timed">
        <xsl:if test="../eventdata/Event/@e_allday != '1'">
          <xsl:attribute name="checked"/>
        </xsl:if>
        <xsl:attribute name="onClick">
          if (document.forms[0]['e_allday']) {
             document.forms[0]['e_allday'].value = '0';
          }
          if (document.forms[0]['isallday']) {
             document.forms[0]['isallday'].value = '0';
          }
        </xsl:attribute>
      <xsl:text>&nbsp;</xsl:text>
      <xsl:choose>
      <xsl:when test="../eventdata/Event/@e_allday='1'">
<!-- call the template with all day values -->        
        <xsl:call-template name="duration_selector">
          <xsl:with-param name="ds_start_hour">00</xsl:with-param>
          <xsl:with-param name="ds_start_min">00</xsl:with-param>
          <xsl:with-param name="dur_hour">23</xsl:with-param>
          <xsl:with-param name="dur_min">59</xsl:with-param>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="duration_selector">
          <xsl:with-param name="ds_start_hour" select="../eventdata/Event/StartTime/@hour" />
          <xsl:with-param name="ds_start_min" select="../eventdata/Event/StartTime/@minute" />
          <xsl:with-param name="dur_hour" select="../eventdata/Event/@e_durhour" />
          <xsl:with-param name="dur_min" select="../eventdata/Event/@e_durmin" />
        </xsl:call-template>
      </xsl:otherwise>
      </xsl:choose>
      </INPUT>
      <BR/>
       <INPUT type="radio" name="allday" value="allday">
        <xsl:if test="../eventdata/Event/@e_allday = '1'">
          <xsl:attribute name="checked"/>
        </xsl:if>
        <xsl:attribute name="onClick">
          if (document.forms[0]['e_allday']) {
             document.forms[0]['e_allday'].value = '1';
          }
          if (document.forms[0]['e_opaque']) {
              document.forms[0]['e_opaque'].value = 'false';
          }
          if (document.forms[0]['opaque_setting']) {
	      document.forms[0]['isopaque'].value = 0;
          }
          if (document.forms[0].opaque_setting) {
              document.forms[0].opaque_setting.checked = false;
          }
          <xsl:choose>
             <xsl:when test="/calendar/usrctx/userprefs/@ceClock='12'">
                document.forms[0]['hr'].value = '12';
                document.forms[0]['mn'].value = '00';
                document.forms[0]['pm'].selectedIndex = 0;
              </xsl:when>
              <xsl:otherwise>
                document.forms[0]['hr'].value = '00';
                document.forms[0]['mn'].value = '00';
              </xsl:otherwise>
            </xsl:choose>
            document.forms[0]['dhr'].value = '23';
            document.forms[0]['dmn'].value = '59';
        </xsl:attribute>
      </INPUT>
      <FONT face="{$font_name}" size="{$font_size_big_2}"><xsl:text>&nbsp;</xsl:text>全日（例如，假期或生日）</FONT>
      </TD>
      </TR>
      <TR>
      <TD></TD>
      <TD align="left" valign="baseline" nowrap="">     
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <xsl:choose>
	  <xsl:when test="(string-length(../eventdata/Event/@e_uid) > 0) and (string-length(../eventdata/Event/@e_existingRRule) > 0)">
	  <xsl:call-template name="emitRecurChangePatternLinkEvent">
          </xsl:call-template>
  	  </xsl:when>
          <xsl:otherwise>
          <INPUT type="checkbox" name="recurrence_enabled" value="repeat">
            <xsl:if test="string-length(../eventdata/Event/@e_existingRRule) > 0"> 
              <xsl:attribute name="checked"/>
            </xsl:if>
            <xsl:attribute name="onClick">
              if (!(document.forms[0]['recurrence_enabled'].checked)) {
                document.forms[0]['e_existingRRule'].value = '';
                document.forms[0]['e_rruleChanged'].value = 'true';
              } else {
              <xsl:value-of select="command[@name='recurrence']"/>
              }
            </xsl:attribute>
          </INPUT>
	   <xsl:call-template name="emitRecurChangePatternLinkEvent">
          </xsl:call-template>
	  </xsl:otherwise>
	</xsl:choose>
      </FONT>
	</TD>
       </TR>
       <TR>
        <TD align="right" valign="baseline">
      
    </TD>
  </TR>
  
<!-- If the server is set up to handle event privacy -->
      <xsl:if test="../eventdata/@allowPrivacy">
    <TR>
   <TD align="right" valign="baseline"><FONT face="{$font_name}" size="{$font_size_big_2}"><B>保密</B></FONT></TD>
    <TD valign="baseline">
        <FONT face="{$font_name}" size="{$font_size_big_2}">
<!-- we ensure that confidential and private come out of the server in lower case -->
<!-- but they need to go back as upper case to be compliant with the standard -->
        <SELECT name="eventPrivacy">
          <OPTION value="PUBLIC">
          <xsl:if test="(not(../eventdata/Event/@e_Class)) or ((../eventdata/Event/@e_Class != 'confidential') and (../eventdata/Event/@e_Class != 'private'))">
            <xsl:attribute name="selected"/>
          </xsl:if>
          公用事件
          </OPTION>
          <OPTION value="CONFIDENTIAL">
          <xsl:if test="../eventdata/Event/@e_Class = 'confidential'">
            <xsl:attribute name="selected"/>
          </xsl:if>
          仅时间与日期
          </OPTION>
          <OPTION value="PRIVATE">
          <xsl:if test="../eventdata/Event/@e_Class = 'private'">
            <xsl:attribute name="selected"/>
          </xsl:if>
          私人事件
          </OPTION>
          <xsl:attribute name="onChange">
	    if (document.forms[0]['eventPrivacy'].selectedIndex == 2) {
	      if (document.forms[0]['e_opaque']) {
                document.forms[0]['e_opaque'].value = 'false';
              }
              if (document.forms[0].opaque_setting) {
                document.forms[0].opaque_setting.checked = false;
              }
              if (document.forms[0]['opaque_setting']) {
	        document.forms[0]['isopaque'].value = 0;
              }
            } else {
                document.forms[0]['isprivate'].value = '0';
            }
	  </xsl:attribute>
        </SELECT>
        </FONT>
       </TD>
      </TR>
      </xsl:if>

<TR>
<TD align="right" valign="baseline"><FONT face="{$font_name}" size="{$font_size_big_2}"><B>空闲/忙</B></FONT></TD>
<TD valign="baseline">
<INPUT type="checkbox" name="opaque_setting" value="opaque">
<xsl:if test="../eventdata/Event/@e_opaque = 'true'"> 
<xsl:attribute name="checked"/>
</xsl:if>
<xsl:attribute name="onClick">
    if (document.forms[0].opaque_setting.checked){
	document.forms[0]['isopaque'].value = 1;
    } else {
	document.forms[0]['isopaque'].value = 0;
    }
</xsl:attribute>
</INPUT>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<xsl:text>&nbsp;</xsl:text>在计算可用性时包括此事件</FONT>
<!-- this must be here to let form processing know to look for checkbox changes -->
<INPUT type="hidden" name="opaque_x" value="here"/>
</TD>
</TR>

 
  <TR>
    <TD align="right" valign="baseline">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <B>地点</B>
      </FONT>
    </TD>
    <TD valign="baseline">
      <INPUT type="text" name="location" size="42">
        <xsl:attribute name="value">
          <xsl:value-of select="../eventdata/Event/@e_Location"/>
        </xsl:attribute>
      </INPUT>
    </TD>
  </TR>
  <TR>
    <TD align="right" valign="top" nowrap="">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <B>说明</B>
      </FONT>
    </TD>
    <TD colspan="2">
      <TEXTAREA cols="42" rows="5" name="description" wrap="virtual">
        <xsl:value-of select="../eventdata/Event/@e_Description"/>
      </TEXTAREA>
    </TD>
  </TR>
  <xsl:if test="string(/calendar/tabs/tab[4]) != '*off*'">
    <TR><TD colspan="2"><HR size="{$font_size_big}"/></TD></TR>
    <TR>
      <TD colspan="2">
        <FONT face="{$font_name}" size="{$font_size_big_2}">
          <B>邀请其他用户或资源：</B>
        </FONT>
      </TD>
    </TR>
    <TR>
      <TD colspan="1" align="left" valign="baseline" nowrap="">
        <xsl:text>&nbsp;</xsl:text>
      </TD>
      <TD colspan="1" align="left" valign="baseline">
        <INPUT type="text" name="invitee" size="20"/>
        <xsl:text>&nbsp;&nbsp;</xsl:text>
        <FONT face="{$font_name}" size="{$font_size_big_2}">
          <INPUT type="submit" name="invite" value="邀请&nbsp;&nbsp;" width="72"/>
        </FONT> 
        <xsl:text>&nbsp;&nbsp;</xsl:text>
        <FONT face="{$font_name}" size="{$font_size_big_2}">
         <INPUT type="button" name="Search" value="搜索(S)..." width="52">
              <xsl:attribute name="onClick">
                <xsl:value-of select="command[@name='search_for_invite']"/>
              </xsl:attribute>
         </INPUT>
         </FONT>
        <xsl:text>&nbsp;&nbsp;</xsl:text>
        <xsl:if test="../eventdata/Event/@enable_inform = 'true'">
        <FONT face="{$font_name}" size="{$font_size_big_2}">
          <INPUT type="submit" name="inform" value="通知" width="72"/>
        </FONT>
        <xsl:text>&nbsp;&nbsp;</xsl:text>
        <FONT face="{$font_name}" size="{$font_size_big_2}">
         <INPUT type="button" name="Search" value="搜索(S)..." width="52">
              <xsl:attribute name="onClick">
                <xsl:value-of select="command[@name='search_for_inform']"/>
              </xsl:attribute>
         </INPUT>
         </FONT>
        </xsl:if>
        <BR/>
        <FONT face="{$font_name}" size="{$font_size_big}">
          （输入用户 ID、日历 ID 或电子邮件地址。若您不知道名称，请单击“搜索”。）
        </FONT>
      </TD>
     </TR>

    <!--  Show the subscribed calendars and local groups(aliases) in a pulldown menu -->
    <TR>
      <TD align="right" valign="top"><xsl:text>&nbsp;</xsl:text></TD>
      <TD>
        <xsl:call-template name="NewEventCalendarGroupSelector"/>
      </TD>
     </TR>
    <TR>
      <TD align="right" valign="middle"><FONT face="{$font_name}" size="{$font_size_big_2}"><B>被邀请人</B></FONT></TD>
      <TD>
        <FONT face="{$font_name}" size="{$font_size_big_2}">
        <SELECT name="invitees" size="{$font_size_big_3}">
         <xsl:attribute name="onChange">
           var dialog = 'NewEvent';
           return parent.MoveCursorOnFocus(dialog,this.options, this.selectedIndex, this);
         </xsl:attribute>
         <xsl:attribute name="onFocus">
           var dialog = 'NewEvent';
           return parent.MoveCursorOnFocus(dialog,this.options, this.selectedIndex, this);
         </xsl:attribute>
          <xsl:if test="count(../eventdata/Event/attendee)=0">
            <OPTION>无被邀请人</OPTION>
          </xsl:if>
          <xsl:for-each select="../eventdata/Event/attendee">
            <xsl:if test="string(@RSVP) = 'TRUE'">
              <OPTION>
                <xsl:attribute name="value">
                  <xsl:value-of select="@userid"/>
                </xsl:attribute>
                <xsl:call-template name="printCalendarName">
                  <xsl:with-param name="name" select="@userid"/>
                  <xsl:with-param name="printname" select="@CN"/>
                </xsl:call-template>
              </OPTION>
            </xsl:if>
          </xsl:for-each>
          <OPTION>_______________________________</OPTION>
        </SELECT>
        <xsl:text>&nbsp;&nbsp;</xsl:text>
        <INPUT type="submit" name="remove_attendee" value="移除"/>
        </FONT>
      </TD>
    </TR>
    <xsl:if test="../eventdata/Event/@enable_inform = 'true'">
    <TR>
      <TD align="right" valign="top">通知事件情况</TD>
      <TD>
        <FONT face="{$font_name}" size="{$font_size_big_2}">
        <SELECT name="informees" size="{$font_size_big_3}">
         <xsl:attribute name="onChange">
           var dialog = 'NewEvent';
           return parent.MoveCursorOnFocus(dialog,this.options, this.selectedIndex, this);
         </xsl:attribute>
         <xsl:attribute name="onFocus">
           var dialog = 'NewEvent';
           return parent.MoveCursorOnFocus(dialog,this.options, this.selectedIndex, this);
         </xsl:attribute>
          <xsl:if test="count(../eventdata/Event/attendee)=0">
            <OPTION>无被邀请人</OPTION>
          </xsl:if>
          <xsl:for-each select="../eventdata/Event/attendee">
            <xsl:if test="string(@RSVP) != 'TRUE'">
              <OPTION>
                <xsl:attribute name="value">
                  <xsl:value-of select="@userid"/>
                </xsl:attribute>
                <xsl:call-template name="printCalendarName">
                  <xsl:with-param name="name" select="@userid"/>
                  <xsl:with-param name="printname" select="@CN"/>
                </xsl:call-template>
              </OPTION>
            </xsl:if>
          </xsl:for-each>
          <OPTION>_______________________________</OPTION>
        </SELECT>
          <xsl:text>&nbsp;&nbsp;</xsl:text>
          <INPUT type="submit" name="remove_attendee_i" value="移除"/>
        </FONT>
      </TD>
    </TR>
    </xsl:if>
  </xsl:if>
</TABLE>
</CENTER>

</FORM>

</BODY>
</HTML>

</xsl:template>

<xsl:template name="reminders_root">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>
<!--  <xsl:call-template name="dateChecking"/> -->
    <xsl:call-template name="javascript_strings"/>
    <SCRIPT SRC="js_date_checking.js">alert('NotFound!');</SCRIPT>


<BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="9" marginheight="9">
 <xsl:attribute name="onload">
    document.forms[0].Others.focus();
  </xsl:attribute>


<FORM method="post">
  <xsl:attribute name="action"><xsl:value-of select="./formdata/@action"/></xsl:attribute>
  <xsl:attribute name="name">form</xsl:attribute>
  <xsl:apply-templates select="formdata"/>
<INPUT type="hidden" name="absalarmset"><xsl:attribute name="value"><xsl:value-of select="../eventdata/Event/@e_alarm_absolute_trigger"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="firstyear"><xsl:attribute name="value"><xsl:value-of select="../eventdata/Event/AbsoluteAlarmTime/@year"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="firstmonth"><xsl:attribute name="value"><xsl:value-of select="../eventdata/Event/AbsoluteAlarmTime/@month"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="firstday"><xsl:attribute name="value"><xsl:value-of select="../eventdata/Event/AbsoluteAlarmTime/@date"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="firsthour"><xsl:attribute name="value"><xsl:value-of select="../eventdata/Event/AbsoluteAlarmTime/@hour"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="firstminute"><xsl:attribute name="value"><xsl:value-of select="../eventdata/Event/AbsoluteAlarmTime/@minute"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="secondyear"><xsl:attribute name="value"><xsl:value-of select="../eventdata/Event/StartTime/@year"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="secondmonth"><xsl:attribute name="value"><xsl:value-of select="../eventdata/Event/StartTime/@month"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="secondday"><xsl:attribute name="value"><xsl:value-of select="../eventdata/Event/StartTime/@date"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="secondhour"><xsl:attribute name="value"><xsl:value-of select="../eventdata/Event/StartTime/@hour"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="secondminute"><xsl:attribute name="value"><xsl:value-of select="../eventdata/Event/StartTime/@minute"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="isallday"><xsl:attribute name="value"><xsl:value-of select="../eventdata/Event/@e_allday"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="isprivate"><xsl:attribute name="value"><xsl:choose><xsl:when test="(../eventdata/Event/@e_Class = 'private')">1</xsl:when><xsl:otherwise>0</xsl:otherwise></xsl:choose></xsl:attribute></INPUT>
<INPUT type="hidden" name="isopaque"><xsl:attribute name="value"><xsl:choose><xsl:when test="(../eventdata/Event/@e_opaque = 'true')">1</xsl:when><xsl:otherwise>0</xsl:otherwise></xsl:choose></xsl:attribute></INPUT>
<CENTER>
<TABLE border="0" cellpadding="3" cellspacing="1">
<!-- Insert errors here-->
<xsl:call-template name="emit_new_event_errors"/>
  <TR>
    <TD colspan="2">
      <FONT face="{$font_name}" size="{$font_size_big}">
        您可为该事件发送电子邮件通知给自己。请在下方输入一个或多个您的电子邮件地址。并以逗号 (,) 或分号 (;) 分隔电子邮件地址。
      </FONT>
    </TD>
  </TR>
  <TR>
    <TD colspan="2">
      <HR size="{$font_size_big}"/>
    </TD>
  </TR>

  <!-- REMIND -->
  
  <TR>
    <TD align="right" valign="baseline">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <B>提醒</B>
      </FONT>
    </TD>
    <TD valign="baseline">
      <FONT face="{$font_name}" size="{$font_size_big_3}">
      
      <INPUT type="checkbox" name="Remind">
        <xsl:if test="../eventdata/Event/@e_alarm_on = 1">
          <xsl:attribute name="checked"/>
        </xsl:if>
      </INPUT>
      
      <INPUT type="text" name="Others" size="35">
       <xsl:attribute name="value">
        <xsl:choose>
         <xsl:when test="string-length(../eventdata/Event/@e_alarm_emails) > 0">
          <xsl:value-of select="../eventdata/Event/@e_alarm_emails"/>
         </xsl:when>
         <xsl:when test="string-length(/calendar/usrctx/userprefs/@ceDefaultAlarmEmail) > 0">
           <xsl:value-of select="/calendar/usrctx/userprefs/@ceDefaultAlarmEmail"/>
         </xsl:when>
         <xsl:when test="string-length(/calendar/usrctx/user/@mail) > 0">
           <xsl:value-of select="/calendar/usrctx/user/@mail"/>
         </xsl:when>
        </xsl:choose>
       </xsl:attribute>

        <xsl:attribute name="onChange">
          var f = document.forms[0];
          if (f['Others'].value.length &gt; 0) {
            f['Remind'].checked = true;
          } else {
            f['Remind'].checked = false;
          }
        </xsl:attribute>
      </INPUT>
      
      </FONT>
     </TD>
  </TR>

  <!-- TRIGGER BEFORE EVENT BEGINS -->

  <TR>
    <TD align="right" valign="baseline">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <B><xsl:text>&nbsp;</xsl:text></B>
      </FONT>
    </TD>
    <TD align="left" valign="baseline">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <INPUT type="radio" name="triggertype"  value="relative">
          <xsl:if test="../eventdata/Event/@e_alarm_absolute_trigger != 1">
            <xsl:attribute name="checked"/>
          </xsl:if>

	  <xsl:attribute name="onClick">
          var f = document.forms[0];
          if (f['Others'].value.length &gt; 0) {
            f['Remind'].checked = true;
          } else {
            f['Remind'].checked = false;
          }
        </xsl:attribute>
        </INPUT>
        <xsl:call-template  name="time_before_selector">
          <xsl:with-param name="time_offset" select="../eventdata/Event/@e_alarm_offset"/>
          <xsl:with-param name="time_units" select="../eventdata/Event/@e_alarm_units"/>
          <xsl:with-param name="before_text">在事件开始之前的</xsl:with-param>
        </xsl:call-template>
      </FONT>
    </TD>
  </TR>

  <!-- ABSOLUTE TRIGGER TIME -->
  <TR>
    <TD align="right" valign="baseline"><FONT face="{$font_name}" size="{$font_size_big_2}"><B><xsl:text>&nbsp;</xsl:text></B></FONT></TD>
    <TD align="left" valign="baseline">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
      <INPUT type="radio" name="triggertype" value="absolute">
        <xsl:if test="../eventdata/Event/@e_alarm_absolute_trigger = 1">
          <xsl:attribute name="checked"/>
        </xsl:if>
	<xsl:attribute name="onClick">
          var f = document.forms[0];
          if (f['Others'].value.length &gt; 0) {
            f['Remind'].checked = true;
          } else {
            f['Remind'].checked = false;
          }
	</xsl:attribute>
      </INPUT>
      </FONT>

      <xsl:choose>
        <xsl:when test="../eventdata/Event/@e_alarm_absolute_trigger = 1">
          <xsl:call-template  name="absolute_datetime_selector">
            <xsl:with-param name="input_prefix" select="'trig'"/>
            <xsl:with-param name="month" select="../eventdata/Event/AbsoluteAlarmTime/@month"/>
            <xsl:with-param name="day" select="../eventdata/Event/AbsoluteAlarmTime/@date"/>
            <xsl:with-param name="year" select="../eventdata/Event/AbsoluteAlarmTime/@year"/>
            <xsl:with-param name="start_hour" select="../eventdata/Event/AbsoluteAlarmTime/@hour"/>
            <xsl:with-param name="start_min" select="../eventdata/Event/AbsoluteAlarmTime/@minute"/>
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
          <xsl:choose>
          <xsl:when test="../eventdata/Event/@e_allday = '1'">
            <xsl:call-template  name="absolute_datetime_selector">
              <xsl:with-param name="input_prefix" select="'trig'"/>
              <xsl:with-param name="month" select="../eventdata/Event/StartTime/@month"/>
              <xsl:with-param name="day" select="../eventdata/Event/StartTime/@date"/>
              <xsl:with-param name="year" select="../eventdata/Event/StartTime/@year"/>
              <xsl:with-param name="start_hour" select="/calendar/usrctx/userprefs/@ceDayHead"/>
              <xsl:with-param name="start_min">00</xsl:with-param>
            </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <xsl:call-template  name="absolute_datetime_selector">
              <xsl:with-param name="input_prefix" select="'trig'"/>
              <xsl:with-param name="month" select="../eventdata/Event/StartTime/@month"/>
              <xsl:with-param name="day" select="../eventdata/Event/StartTime/@date"/>
              <xsl:with-param name="year" select="../eventdata/Event/StartTime/@year"/>
              <xsl:with-param name="start_hour" select="../eventdata/Event/StartTime/@hour"/>
              <xsl:with-param name="start_min" select="../eventdata/Event/StartTime/@minute"/>
            </xsl:call-template>
          </xsl:otherwise>
          </xsl:choose>
        </xsl:otherwise>
      </xsl:choose>
    </TD>
  </TR>

  <TR>
    <TD align="right" valign="baseline">
      <FONT face="{$font_name}" size="{$font_size_big_2}"><xsl:text>&nbsp;</xsl:text></FONT>
    </TD>
  </TR>
  <TR>
    <TD colspan="2">
      <HR size="{$font_size_big}"/>
    </TD>
  </TR>
  <TR>
    <TD colspan="2">
      <FONT face="{$font_name}" size="{$font_size_big}">
        您可以发送带有文本信息的电子邮件提醒通知。
      </FONT>
    </TD>
  </TR>
  <TR>
    <TD align="right" valign="top" nowrap="">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <B>邮件</B>
      </FONT>
    </TD>
    <TD colspan="2">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <TEXTAREA cols="42" rows="5" name="reminderMessage" wrap="virtual">
          <xsl:value-of select="../eventdata/Event/@e_alarm_description"/>
        </TEXTAREA>
      </FONT>
    </TD>
  </TR>
</TABLE>
</CENTER>
</FORM>

</BODY>
</HTML>

</xsl:template>

<xsl:template name="preview_root">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>

<BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="9" marginheight="9" onload="window.focus();">

<FORM method="post">
  <xsl:attribute name="action"><xsl:value-of select="./formdata/@action"/></xsl:attribute>
  <xsl:attribute name="name">form</xsl:attribute>
  <xsl:apply-templates select="formdata"/>
<INPUT type="hidden" name="absalarmset"><xsl:attribute name="value"><xsl:value-of select="../eventdata/Event/@e_alarm_absolute_trigger"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="firstyear"><xsl:attribute name="value"><xsl:value-of select="../eventdata/Event/AbsoluteAlarmTime/@year"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="firstmonth"><xsl:attribute name="value"><xsl:value-of select="../eventdata/Event/AbsoluteAlarmTime/@month"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="firstday"><xsl:attribute name="value"><xsl:value-of select="../eventdata/Event/AbsoluteAlarmTime/@date"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="firsthour"><xsl:attribute name="value"><xsl:value-of select="../eventdata/Event/AbsoluteAlarmTime/@hour"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="firstminute"><xsl:attribute name="value"><xsl:value-of select="../eventdata/Event/AbsoluteAlarmTime/@minute"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="secondyear"><xsl:attribute name="value"><xsl:value-of select="../eventdata/Event/StartTime/@year"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="secondmonth"><xsl:attribute name="value"><xsl:value-of select="../eventdata/Event/StartTime/@month"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="secondday"><xsl:attribute name="value"><xsl:value-of select="../eventdata/Event/StartTime/@date"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="secondhour"><xsl:attribute name="value"><xsl:value-of select="../eventdata/Event/StartTime/@hour"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="secondminute"><xsl:attribute name="value"><xsl:value-of select="../eventdata/Event/StartTime/@minute"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="isallday"><xsl:attribute name="value"><xsl:value-of select="../eventdata/Event/@e_allday"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="isprivate"><xsl:attribute name="value"><xsl:choose><xsl:when test="(../eventdata/Event/@e_Class = 'private')">1</xsl:when><xsl:otherwise>0</xsl:otherwise></xsl:choose></xsl:attribute></INPUT>
<INPUT type="hidden" name="isopaque"><xsl:attribute name="value"><xsl:choose><xsl:when test="(../eventdata/Event/@e_opaque = 'true')">1</xsl:when><xsl:otherwise>0</xsl:otherwise></xsl:choose></xsl:attribute></INPUT>
<TABLE border="0" cellpadding="3" cellspacing="1" width="100%">
<!-- Insert errors here -->
<xsl:call-template name="emit_new_event_errors"/>
  <TR>
    <TD width="1%" align="right" valign="baseline">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <B>标题</B>
      </FONT>
    </TD>
    <TD bgcolor="{$bgcolor_form_selected}" valign="baseline" width="90%">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <xsl:text>&nbsp;</xsl:text><xsl:value-of select="../eventdata/Event/@e_Summary"/>
      </FONT>
    </TD>
  </TR>
  <TR>
    <TD width="1%" align="right" valign="baseline">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <B>日期</B>
      </FONT>
    </TD>
    <TD bgcolor="{$bgcolor_form_selected}" valign="baseline">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <xsl:text>&nbsp;</xsl:text>
        <xsl:choose>
          <xsl:when test="../eventdata/Event/@e_allday='1'">
            <xsl:call-template name="date_long_no_time">
              <xsl:with-param name="date_range" select="../eventdata/Event"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <xsl:call-template name="date_long">
              <xsl:with-param name="date_range" select="../eventdata/Event"/>
            </xsl:call-template>
           </xsl:otherwise>
        </xsl:choose>
      </FONT>
    </TD>
  </TR>
  <TR>
    <TD width="1%" align="right" valign="baseline">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <B>地点</B>
      </FONT>
    </TD>
    <TD bgcolor="{$bgcolor_form_selected}" valign="baseline">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <xsl:text>&nbsp;</xsl:text><xsl:value-of select="../eventdata/Event/@e_Location"/>
      </FONT>
    </TD>
  </TR>
  <xsl:if test="string(/calendar/tabs/tab[4]) != '*off*'">
  <TR>
    <TD width="1%" align="right" valign="baseline">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <B>组织者</B>
      </FONT>
    </TD>
    <TD bgcolor="{$bgcolor_form_selected}" valign="baseline">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <xsl:text>&nbsp;</xsl:text>
        <xsl:call-template name="printCalendarName">
          <xsl:with-param name="name" select="../eventdata/Event/@e_Organizer"/>
        </xsl:call-template>
      </FONT>
    </TD>
  </TR>
    <TR>
      <TD width="1%" align="right" valign="top">
        <FONT face="{$font_name}" size="{$font_size_big_2}">
          <B>参与者</B>
        </FONT>
      </TD>
      <TD bgcolor="{$bgcolor_form_selected}" valign="baseline">
        <xsl:text>&nbsp;</xsl:text>
        <xsl:call-template name="attendee_long">
          <xsl:with-param name="event" select="../eventdata/Event"/>
        </xsl:call-template>
      </TD>
    </TR>
  </xsl:if>
  <TR>
    <TD width="1%" align="right" valign="baseline">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <B>说明</B>
      </FONT>
    </TD>
    <TD bgcolor="{$bgcolor_form_selected}" valign="baseline">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <xsl:text>&nbsp;</xsl:text><xsl:value-of select="../eventdata/Event/@e_Description"/>
      </FONT>
    </TD>
  </TR>
</TABLE>
</FORM>

</BODY>
</HTML>

</xsl:template>

<xsl:template name="button_root">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>
  <xsl:call-template name="javascript_strings"/>
  <SCRIPT SRC="js_date_checking.js">alert('NotFound!');</SCRIPT>

<BODY bgcolor="{$bgcolor_table_border}" marginwidth="0" marginheight="0">

<FORM name="form" method="post">
<TABLE width="100%" height="100%" border="0" cellpadding="0" cellspacing="0">
  <TR>
    <xsl:if test="(string-length(../eventdata/Event/@e_uid) > 0) and (../eventdata/Event/@e_deleteAccessAllowed = 'true')">
      <TD align="left" bgcolor="{$bgcolor_button}">
        <FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">
          <INPUT type="button" name="delete" value="删除" width="72">
            <xsl:attribute name="onClick">
              if (parent.frames[1].document.forms[0]['e_rid'].value != '0') {
               <xsl:value-of select="./command[@name='repeating_event_delete']"/>
              } else {
                <xsl:value-of select="./button[@name='delete']"/>
              }
            </xsl:attribute>
          </INPUT>
        </FONT>
      </TD>
    </xsl:if>
    <TD align="right" bgcolor="{$bgcolor_button}">
      <FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">
        <xsl:choose>
          <xsl:when test="../eventdata/Event/@e_writeAccessAllowed = 'true'">
            <INPUT type="button" name="ok" width="72" value="确定">
              <xsl:attribute name="onClick">
                if (parent.date_error == '1') {
                    parent.date_error = '0';
                    return;
                }
                <!-- Warn about absolute alarms if alarm is set to after the event -->
                 var f = parent.frames[1].document.forms[0];
                 var isampm = 0;
                 var isalldayevent = 0;
		 var isprivateevent = 0;
                 var isopaqueevent = 0;
                 
                 <!-- Does the time in the form have to be converted to 24 hour clock before comparison? -->
		 <xsl:if test="/calendar/usrctx/userprefs/@ceClock='12'">
                       isampm = 1;
                 </xsl:if>

		 if((f['isallday'].value == 1) || (f['allday'] &amp;&amp; f['allday'][1].checked)) {
	  		isalldayevent = 1;
    		 }
	         if((f['isprivate'].value == 1) || (f['eventPrivacy'] &amp;&amp; f['eventPrivacy'].selectedIndex == 2)) {
			isprivateevent = 1;
	         } 
	         if((f['isopaque'].value == 1) || (f['opaque_setting'] &amp;&amp; f['opaque_setting'].checked)) {
			isopaqueevent = 1;
	         } 

		 <!-- Was absolute alarm set then do comparison of time? -->
                 if ((f['absalarmset'].value == 1) || (f['triggertype'] &amp;&amp; f['triggertype'][1].checked)) {
                   if (comparetime(f, isampm, 'trig', isalldayevent) != 0) {
                    if(!confirm('此事件的提醒已被设置为事件开始之后的某个时间。单击“取消”以返回并更改时间。')) {
                         return;
                    }
                   }
                 }

                <!-- Warn about opaque allday event and change value if appropriate  -->
               if (isalldayevent &amp;&amp; isopaqueevent) {
                    if(!confirm('您正在创建一个“全天”事件，此事件将在计算可用性时使用。如果 此事件不正确，请点击“取消”返回并取消选择“空闲/忙”复选框。')) {
                           return;
                       
                    }
               }
		<!-- Warn about opaque private event -->
	        if (isprivateevent &amp;&amp; isopaqueevent) {
                    if(!confirm('您正在创建一个专用事件，此事件将在计算可用性时使用。如果此事件不正确，请点击“取消”返回并取消选择“空闲/忙”复选框。')) {
                           return;
                       
                    }
               }

                if (parent.frames[1].document.forms[0]['e_rid'].value != '0') {
                  <xsl:value-of select="./command[@name='repeating_event_store']"/>
                } else {
                  <xsl:value-of select="./button[@name='ok']"/>
                }
              </xsl:attribute>
            </INPUT>
            <INPUT type="button" name="esc" width="72" value="取消" onClick="{./button[@name='cancel']}"/>
          </xsl:when>
          <xsl:otherwise>
            <INPUT type="button" name="esc" width="72" value="关闭" onClick="{./button[@name='cancel']}"/>
          </xsl:otherwise>
        </xsl:choose>
        <INPUT type="button" name="help" width="72" value="帮助" onClick="{./button[@name='help']}"/>
      </FONT>
    </TD>
  </TR>
</TABLE>
</FORM>

</BODY>
</HTML>
</xsl:template>


</xsl:stylesheet>
