<?xml version="1.0" encoding="UTF-8" ?>

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- set the output properties -->
<xsl:output method="html" version="4" encoding="UTF-8"/>

<!-- Include main display XSL instructions -->
<xsl:include href="common_view.xsl"/>

<xsl:template match="availabilitylist">

  <xsl:variable name="borderwidth">
   <xsl:choose>
    <xsl:when test="$view = 'print'">2</xsl:when>
    <xsl:otherwise>0</xsl:otherwise>
   </xsl:choose>
  </xsl:variable>

 <TR align="center" bgcolor="#FFFFFF">
  <TD bgcolor="{$bgcolor_table_border}">
    <TABLE border="{$borderwidth}" cellpadding="2" cellspacing="1" width="100%">
      <TR align="center" bgcolor="#FFFFFF">
        <TD align="center" bgcolor="#FFFFFF" nowrap=""><FONT face="{$font_name}" size="{$font_size_big}" color="#000000">空闲</FONT></TD>
        <TD align="center" bgcolor="{$bgcolor_table_top}" background="imx/hash-1.gif" nowrap=""><FONT face="{$font_name}" size="{$font_size_big}" color="#FFFFFF">已占用</FONT></TD>
        <xsl:for-each select="./freeBusy">
          <xsl:for-each select="freeBusyBlock">
            <TD>
              <xsl:choose>
                <xsl:when test="@free!=1">
                  <xsl:attribute name="bgcolor">
                    <xsl:value-of select="$bgcolor_table_top"/>
                  </xsl:attribute>
                  <xsl:attribute name="background">imx/hash-1.gif</xsl:attribute>
                  <FONT face="{$font_name}" size="{$font_size_big}" color="#FFFFFF"><xsl:text>&nbsp;</xsl:text></FONT>
                </xsl:when>
                <xsl:otherwise>
<!-- Insert the timedate in to the command -->
<!-- also add to the end of the args... -->
                  <xsl:variable name="attendeelist">
                    <xsl:value-of select="substring-before((../../command[1]),'fillindate')"/>
                    <xsl:value-of select="./StartTime/@iso"/>
                    <xsl:value-of select="substring-before(substring-after((../../command[1]),'fillindate'), 'extraargs')"/>
                    <!-- default event organizer -->
                    <xsl:choose>
                     <xsl:when test="(string-length($usrctx/@selectedGroup) > 0) and (string-length($usrctx/@selectedCalendar) = 0)">
                       <xsl:text disable-output-escaping="yes">&amp;calid=</xsl:text><xsl:value-of select="$username"/>
                     </xsl:when>
                     <xsl:otherwise>
                       <xsl:text>extraargs</xsl:text>
                     </xsl:otherwise>
                    </xsl:choose>
                    <xsl:value-of select="substring-after((../../command[1]),'extraargs')"/>
                  </xsl:variable>   

                <xsl:if test="$view = 'print'">
                  <xsl:text>&nbsp;</xsl:text>
                </xsl:if>
                <xsl:if test="($username != 'anonymous') and ($view != 'print')">
                  <A>
                    <xsl:attribute name="href"><xsl:value-of select="$attendeelist"/></xsl:attribute> 
                    <IMG src="imx/new.gif" width="16" height="16" border="0">
                      <xsl:attribute name="alt">
                        <xsl:call-template name="available_time_message">
                          <xsl:with-param name="ftHour" select="./StartTime/@hour"/>
                          <xsl:with-param name="ftMinute" select="./StartTime/@minute"/>
                          <xsl:with-param name="timeAvail" select="@timeAvailable"/>
                        </xsl:call-template>
                      </xsl:attribute>
                    </IMG>
                  </A>
                </xsl:if>
                </xsl:otherwise>
              </xsl:choose>
            </TD>
          </xsl:for-each>
        </xsl:for-each>
      </TR>

<!-- Output times -->

      <TR bgcolor="{$bgcolor_table_cell}">
        <TD colspan="2" align="right" bgcolor="{$bgcolor_button}" nowrap="">
<!-- TODO - put in variable call to pick up CORRECT TZ abbreviation -->
           <xsl:text>&nbsp;</xsl:text>
<!--
        <FONT face="{$font_name}" size="{$font_size_big}" color="#FFFFFF">PST</FONT>
-->
        </TD>
        <xsl:for-each select="./freeBusy">
          <xsl:for-each select="freeBusyBlock">
            <TD nowrap="">
              <FONT face="{$font_name}" size="{$font_size_big}" color="#000000">
                <xsl:call-template name="formatTime">
                  <xsl:with-param name="ftHour" select="./StartTime/@hour"/>
                  <xsl:with-param name="ftMinute" select="./StartTime/@minute"/>
                </xsl:call-template>
              </FONT>
            </TD>
          </xsl:for-each>
        </xsl:for-each>
      </TR>

    <xsl:if test="$userprefs/@ceAllCalendarTZIDs = '1'">
<!-- For each additional TZ of interest, print out equivalent time rows -->
     <xsl:for-each select="./AdditionalTZs/TZ">

       <xsl:variable name="TZname">
         <xsl:value-of select="@name"/>
       </xsl:variable>

      <TR bgcolor="{$bgcolor_table_cell}">
        <TD colspan="2" align="right" bgcolor="{$bgcolor_button}" nowrap="">
        <FONT face="{$font_name}" size="{$font_size_big}" color="#FFFFFF">
        <xsl:call-template name="getDisplayNameOfTZID">
           <xsl:with-param name="tzid">
               <xsl:value-of select="@name"/>
           </xsl:with-param>
        </xsl:call-template>
        <xsl:text>&nbsp;</xsl:text>
        </FONT>
        </TD>
        <xsl:for-each select="../../freeBusy">
          <xsl:for-each select="freeBusyBlock">
            <TD nowrap="">
             <xsl:for-each select="./StartTime/ExtraTZ">
               <xsl:if test="@name=$TZname">
                 <FONT face="{$font_name}" size="{$font_size_big}" color="#000000">
                   <xsl:call-template name="formatTime">
                     <xsl:with-param name="ftHour" select="@hour"/>
                     <xsl:with-param name="ftMinute" select="@minute"/>
                   </xsl:call-template>
                 </FONT>
               </xsl:if>
             </xsl:for-each>
            </TD>
          </xsl:for-each>
        </xsl:for-each>
      </TR>
      </xsl:for-each>
    </xsl:if>
      
<!-- Output calendar -->
    <xsl:for-each select="./attendeeFreeBusy">
      <TR valign="top" bgcolor="{$bgcolor_table_mid}">
        <TD colspan="2" align="right" nowrap="" bgcolor="{$bgcolor_button}">
            <FONT face="{$font_name}" size="{$font_size_big}" color="#FFFFFF">
              <xsl:call-template name="printCalendarName">
                <xsl:with-param name="name" select="@name"/>
              </xsl:call-template>
            </FONT>
        </TD>

        <xsl:choose>
          <xsl:when test="@DWPErrNo='11001'">
            <TD colspan="10" bgcolor="{$bgcolor_table_border}"><FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">
            无法连接到后端 DWP。</FONT></TD>
          </xsl:when>
          <xsl:when test="@DWPErrNo='11000'">
            <TD colspan="10" bgcolor="{$bgcolor_table_border}"><FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">
             由于已达后端连接最大值，所以无法进行提取。</FONT></TD>   
          </xsl:when>
          <xsl:when test="@DWPErrNo='11002'">
            <TD colspan="10" bgcolor="{$bgcolor_table_border}"><FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">
            无法解析后端 DWP。</FONT></TD>
          </xsl:when>
          <xsl:when test="@DWPErrNo='11003'">
            <TD colspan="10" bgcolor="{$bgcolor_table_border}"><FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">
             自后端 DWP 提取日历时发现错误的数据。</FONT></TD>
          </xsl:when>
          <xsl:when test="@DWPErrNo='11004'">
            <TD colspan="10" bgcolor="{$bgcolor_table_border}"><FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">
             DWP 主机环境不可用。</FONT></TD>
          </xsl:when>
          <xsl:when test="@DWPErrNo='11005'">
            <TD colspan="10" bgcolor="{$bgcolor_table_border}"><FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">
             无法解析 DWP 主机。                     </FONT></TD>
          </xsl:when>
          <xsl:when 
            test="count(./freeBusy/freeBusyBlock) = 0"><TD colspan="10" bgcolor="{$bgcolor_table_border}"><FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">
            日历的保密性不允许您查看，或该日历不存在。</FONT></TD>
          </xsl:when>
          <xsl:otherwise>
          </xsl:otherwise>
        </xsl:choose>                

        <xsl:for-each select="./freeBusy">
          <xsl:for-each select="freeBusyBlock">
            <xsl:variable name="myspan" select="./@span"/>
            <xsl:if test="@free=1">
               <xsl:variable name="num32" select="floor($myspan div 32)"/>
               <xsl:variable name="temp1" select="$myspan mod 32"/>
               <xsl:variable name="num16" select="floor($temp1 div 16)"/>
               <xsl:variable name="temp2" select="$myspan mod 16"/>
               <xsl:variable name="num8" select="floor($temp2 div 8)"/>
               <xsl:variable name="num1" select="$myspan mod 8"/>
               <xsl:call-template name="MakeSlots32">
                 <xsl:with-param name="mynum" select="$num32"/>
               </xsl:call-template>
               <xsl:call-template name="MakeSlots16">
                 <xsl:with-param name="mynum" select="$num16"/>
               </xsl:call-template>
               <xsl:call-template name="MakeSlots8">
                 <xsl:with-param name="mynum" select="$num8"/>
               </xsl:call-template>
               <xsl:call-template name="MakeSlots">
                 <xsl:with-param name="mynum" select="$num1"/>
               </xsl:call-template>
            </xsl:if>
            <xsl:if test="@free=0">
            <TD colspan="{$myspan}">
               <xsl:attribute name="bgcolor">#FFFFFF</xsl:attribute>

	       <xsl:attribute name="background">
        	 <xsl:choose>
                  <xsl:when test="@free=0">imx/hash-1.gif</xsl:when>
                  <xsl:otherwise></xsl:otherwise>
                  </xsl:choose>
               </xsl:attribute>

               <xsl:choose>
                <xsl:when test="@free=0">
                  <xsl:variable name="isGroupView">true</xsl:variable>
                    <xsl:choose>
                    <xsl:when test="./ComponentGroup">
                      <!-- For Each ComponentGroup on this canvas, list appropriately -->
                      <xsl:for-each select="./ComponentGroup">
                        <xsl:call-template name="limitedComponentGroup"/>
                      </xsl:for-each>
                      </xsl:when>
                      <xsl:otherwise><xsl:text>&nbsp;</xsl:text></xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:otherwise><xsl:text>&nbsp;</xsl:text></xsl:otherwise>
              </xsl:choose>
            </TD>
            </xsl:if>
          </xsl:for-each>
        </xsl:for-each>
      </TR>
    </xsl:for-each>

    </TABLE>
    </TD>
  </TR>

</xsl:template>

<xsl:template match="panel">
  <xsl:choose>
    <xsl:when test="@name='singleDayTimeHeader'">
     <TR>
     <TD align="left">
       <xsl:call-template name="singleDayTimeHeaderTemplate"/>
     </TD>
     <TD align="right">
       <xsl:call-template name="viewtabs"/>        
     </TD>
     </TR>
    </xsl:when>

    <xsl:when test="@name='singleDayView'">
    <TR>
    <TD colspan="2">
       <TABLE border="0" cellpadding="1" cellspacing="0" width="100%">
          <xsl:apply-templates select="availabilitylist"/>
       </TABLE>
    </TD>
    </TR>
    </xsl:when>
 
    <xsl:when test="@name='miniview'">
        <xsl:apply-templates select="panel"/>
        <HR size="{$font_size_big}"/>
    </xsl:when>
 
    <xsl:when test="@name='minical'">
      <xsl:apply-templates select="minical"/>
    </xsl:when>

    <xsl:when test="@name='tasktable'">
      <xsl:call-template name="tasktable"/>
    </xsl:when>

    <xsl:otherwise>
    <TABLE>
      <xsl:apply-templates select="panel"/>
    </TABLE>
    </xsl:otherwise>
  </xsl:choose>

</xsl:template>

<xsl:template name="MakeSlots">
  <xsl:param name="mynum"/>
  <xsl:param name="myindex" select="0"/>
 
  <xsl:if test="$myindex &lt; $mynum">
  		<TD bgcolor="FFFFFF">&nbsp;</TD>
    	<xsl:call-template name="MakeSlots">
      		<xsl:with-param name="mynum" select="$mynum"/>
      		<xsl:with-param name="myindex" select="$myindex+1"/>
    	</xsl:call-template>
  </xsl:if>
</xsl:template>

<xsl:template name="MakeSlots8">
  <xsl:param name="mynum"/>
  <xsl:param name="myindex" select="0"/>
 
  <xsl:if test="$myindex &lt; $mynum">
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
    	<xsl:call-template name="MakeSlots8">
      		<xsl:with-param name="mynum" select="$mynum"/>
      		<xsl:with-param name="myindex" select="$myindex+1"/>
    	</xsl:call-template>
  </xsl:if>
</xsl:template>

<xsl:template name="MakeSlots16">
  <xsl:param name="mynum"/>
  <xsl:param name="myindex" select="0"/>
 
  <xsl:if test="$myindex &lt; $mynum">
  	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
    	<xsl:call-template name="MakeSlots16">
      		<xsl:with-param name="mynum" select="$mynum"/>
      		<xsl:with-param name="myindex" select="$myindex+1"/>
    	</xsl:call-template>
  </xsl:if>
</xsl:template>

<xsl:template name="MakeSlots32">
  <xsl:param name="mynum"/>
  <xsl:param name="myindex" select="0"/>
 
  <xsl:if test="$myindex &lt; $mynum">
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
	  <TD bgcolor="FFFFFF">&nbsp;</TD>
    	<xsl:call-template name="MakeSlots32">
      		<xsl:with-param name="mynum" select="$mynum"/>
      		<xsl:with-param name="myindex" select="$myindex+1"/>
    	</xsl:call-template>
  </xsl:if>
</xsl:template>

</xsl:stylesheet>
