<?xml version="1.0" encoding="UTF-8" ?>

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- set the output properties -->
<xsl:output method="html" version="4" encoding="UTF-8"/>

<xsl:template name="toolbar_root">
  <HTML>
    <xsl:call-template name="emit_frame_head_tag"/>
    
<!--
    <BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="0" marginheight="0">
-->
    <BODY bgcolor="{$bgcolor_background}" marginwidth="0" marginheight="0">
      <xsl:text></xsl:text>   <!--DIV style="position:absolute;z-index:1;"-->
      <FORM name="form">
        <xsl:for-each select="group">
          <xsl:if test="@name='toolbar'">
            <xsl:call-template name="toolbar"/>
          </xsl:if>
        </xsl:for-each>
      </FORM>
      <xsl:text></xsl:text>   <!--/DIV-->
      <xsl:text></xsl:text>   <!--DIV id="tabBG" style="position:absolute;z-index:0;"><IMG src="imx/tbg.gif"></DIV-->
    </BODY>
  </HTML>
</xsl:template>

<xsl:template name="toolbar">

  <xsl:call-template name="brand"/>
  <xsl:call-template name="toolbar-tabs"/>
  <xsl:call-template name="overview-toolbar-icons"/>

</xsl:template>

<xsl:template name="brand">
  <SCRIPT>
    if (document.images) {
      homepageoff = new Image();
      homepageoff.src = "imx/white_bannerdot.gif";

      documentationoff = new Image();
      documentationoff.src = "imx/white_bannerdot.gif";

      userlogoutoff = new Image();
      userlogoutoff.src = "imx/white_bannerdot.gif";

      homepageover = new Image();
      homepageover.src = "imx/red_rollover_bannerdot.gif";

      documentationover = new Image();
      documentationover.src = "imx/red_rollover_bannerdot.gif";

      userlogoutover = new Image();
      userlogoutover.src = "imx/red_rollover_bannerdot.gif";
    }
  </SCRIPT>

  <link rel="stylesheet" href="master-style.css" type="text/css"/>

  <table width="100%" border="0" cellspacing="0" cellpadding="0">
    <tr>
      <td bgcolor="#CC0000"><img src="imx/spacer.gif" width="1" height="5"/></td>
      <td bgcolor="#CC0000"><img src="imx/spacer.gif" width="1" height="5"/></td>
      <td bgcolor="#CC0000"><img src="imx/spacer.gif" width="1" height="5"/></td>
      <td bgcolor="#CC0000"><img src="imx/spacer.gif" width="1" height="5"/></td>
    </tr>
    <tr>
      <td bgcolor="#999999" width="500" align="left" valign="center"><img src="imx/SJ_CalEx_banner.gif" width="300" height="29" border="0" alt="Sun Java[tm] System Calendar Express"/></td>
      <TD nowrap="1" bgcolor="999999" align="right" valign="center"> 

        <xsl:call-template name="toolbar_welcome"/>
      </TD>

      <td bgcolor="#cccccc" width="1"></td>
      <td bgcolor="#cccccc" width="183">
        <table border="0" cellspacing="0" cellpadding="0" align="left" height="29">
          <tr>
            <td><a onMouseOver="over('homepage')" onMouseOut="out('homepage')">
              <xsl:attribute name="href">
                  <xsl:value-of select="command[@name='home']"/>
              </xsl:attribute>
              <img name="homepage" src="imx/white_bannerdot.gif" width="13" height="9" border="0"/></a></td>

            <td><a onMouseOver="over('homepage')" onMouseOut="out('homepage')">
              <xsl:attribute name="href">
                  <xsl:value-of select="command[@name='home']"/>
              </xsl:attribute>
              <span class="banner-links"><FONT size="2" face="PrimaSans BT,Verdana,sans-serif">首頁</FONT></span></a>
            </td>
           
            <td><img src="imx/spacer.gif" width="25" height="1"/></td>

            <td><a onMouseOver="over('userlogout')" onMouseOut="out('userlogout')">
                    <xsl:attribute name="href">
                      <xsl:value-of select="command[@name='logout']"/>
                    </xsl:attribute>
              <img name="userlogout" src="imx/white_bannerdot.gif" width="13" height="9" border="0"/></a>
            </td>

            <td><a onMouseOver="over('userlogout')" onMouseOut="out('userlogout')">
                   <xsl:attribute name="href">
                     <xsl:value-of select="command[@name='logout']"/>
                   </xsl:attribute>
                    <xsl:choose>
                      <xsl:when test="/calendar/usrctx/user/@name = 'anonymous'">
                        <span class="banner-links"><FONT size="2" face="PrimaSans BT,Verdana,sans-serif">登入</FONT></span>
                      </xsl:when>
                      <xsl:otherwise>
                        <span class="banner-links"><FONT size="2" face="PrimaSans BT,Verdana,sans-serif">登出</FONT></span>
                      </xsl:otherwise>
                    </xsl:choose>
                </a>
            </td>
          </tr>
          <tr>
            <td><a onMouseOver="over('documentation')" onMouseOut="out('documentation')">
              <xsl:attribute name="href">
                <xsl:value-of select="command[@name='help']"/>
              </xsl:attribute>
              <img name="documentation" src="imx/white_bannerdot.gif" width="13" height="9" border="0"/></a></td>
            <td><a onMouseOver="over('documentation')" onMouseOut="out('documentation')">
              <xsl:attribute name="href">
                <xsl:value-of select="command[@name='help']"/>
              </xsl:attribute>
              <span class="banner-links"><FONT size="2" face="PrimaSans BT,Verdana,sans-serif">輔助說明</FONT></span></a>
            </td>
            <td><xsl:text>&nbsp;</xsl:text></td>
            <td><xsl:text>&nbsp;</xsl:text></td>
            <td><xsl:text>&nbsp;</xsl:text></td>
          </tr>
        </table>
      </td>
    </tr>

  </table>

</xsl:template>

<xsl:template name="toolbar-tab_item">
  <xsl:param name="Name"/>
  <xsl:param name="Action"/>
  
  <xsl:choose>
    <xsl:when test="string($Action) = '*off*'">
    </xsl:when>

    <xsl:when test="string-length($Action) = 0">
      <TD width="1%" nowrap="" align="center" bgcolor="{$bgcolor_selected}"><FONT face="{$font_name}" size="{$font_size_big_2}" color="#000000"><B><xsl:text>&nbsp;</xsl:text><xsl:value-of select="$Name"/><xsl:text>&nbsp;</xsl:text></B></FONT></TD>
    </xsl:when>

    <xsl:otherwise>
      <TD width="1%" nowrap="" align="center" bgcolor="{$bgcolor_table_mid}"><A href="{$Action}" onMouseOver="" onMouseOut="" style="text-decoration:none;"><FONT face="{$font_name}" size="{$font_size_big_2}" color="#000000"><B><xsl:text>&nbsp;</xsl:text><xsl:value-of select="$Name"/><xsl:text>&nbsp;</xsl:text></B></FONT></A></TD>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="overview-toolbar-icons-item">
  <xsl:param name="Img"/>
  <xsl:param name="AltText"/>
  <xsl:param name="CommandName"/>
  <xsl:param name="ButtonText"/>
  <xsl:param name="LastOne"/>

  <xsl:if test="(string-length(command[@name=$CommandName]) > 0) and (string(command[@name=$CommandName]) != '*off*')">
    <TD align="center" width="5%">
      <A style="text-decoration:none;">

        <xsl:attribute name="href">
          <xsl:choose>

            <xsl:when test="$CommandName = 'new_event'">
              <xsl:value-of select="substring-before((command[@name=$CommandName]),'extraargs')"/>
              <xsl:choose>
              <xsl:when test="(string-length(/calendar/usrctx/@selectedGroup) > 0) and (string-length(/calendar/usrctx/@selectedCalendar) = 0)">
              <xsl:text disable-output-escaping="yes">&amp;calid=</xsl:text><xsl:value-of select="/calendar/usrctx/user/@name"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:text>extraargs</xsl:text>
              </xsl:otherwise>
              </xsl:choose>
              <xsl:value-of select="substring-after((command[@name=$CommandName]),'extraargs')"/>
            </xsl:when>

            <xsl:when test="$CommandName = 'new_task'">
              <xsl:value-of select="substring-before((command[@name=$CommandName]),'extraargs')"/>
              <xsl:choose>
              <xsl:when test="(string-length(/calendar/usrctx/@selectedGroup) > 0) and (string-length(/calendar/usrctx/@selectedCalendar) = 0)">
              <xsl:text disable-output-escaping="yes">&amp;calid=</xsl:text><xsl:value-of select="/calendar/usrctx/user/@name"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:text>extraargs</xsl:text>
              </xsl:otherwise>
              </xsl:choose>
              <xsl:value-of select="substring-after((command[@name=$CommandName]),'extraargs')"/>
            </xsl:when>

            <xsl:otherwise>
              <xsl:value-of select="command[@name=$CommandName]"/>
            </xsl:otherwise>

          </xsl:choose>
        </xsl:attribute>

        <xsl:if test="(/calendar/usrctx/userprefs/@ceToolImage=1)">
          <IMG src="{$Img}" width="24" height="24" border="0" alt="{$AltText}"/><BR/>
        </xsl:if>
        <xsl:if test="(/calendar/usrctx/userprefs/@ceToolText=1)">
          <FONT face="{$font_name}" size="{$font_size_big}" color="#000000"><NOBR><xsl:value-of select="$ButtonText"/></NOBR></FONT>
        </xsl:if>
      </A>
    </TD>
    <xsl:if test="$LastOne != 'true'">
      <TD align="center"><FONT face="{$font_name}" color="#666633"><B>|</B></FONT></TD>
    </xsl:if>
  </xsl:if>
</xsl:template>

<xsl:template name="toolbar-tabs">
<TABLE width="100%" border="0" cellpadding="0" cellspacing="0">
  <TR>
    <TD bgcolor="#000000"><TABLE width="100%" border="0" cellpadding="3" cellspacing="1">
      <TR bgcolor="{$bgcolor_table_mid}">
        <xsl:call-template name="toolbar-tab_item">
          <xsl:with-param name="Name"><xsl:text>&nbsp;</xsl:text>檢視<xsl:text>&nbsp;</xsl:text></xsl:with-param>
          <xsl:with-param name="Action">
                <xsl:value-of select="command[@name='calendar']"/>
          </xsl:with-param>
        </xsl:call-template>

        <xsl:if test="/calendar/usrctx/user/@name != 'anonymous'">
          <xsl:call-template name="toolbar-tab_item">
            <xsl:with-param name="Name"><xsl:text>&nbsp;</xsl:text>行事曆<xsl:text>&nbsp;</xsl:text></xsl:with-param>
            <xsl:with-param name="Action"><xsl:value-of select="command[@name='calendars']"/></xsl:with-param>
           </xsl:call-template>
          <xsl:call-template name="toolbar-tab_item">
            <xsl:with-param name="Name"><xsl:text>&nbsp;</xsl:text>群組<xsl:text>&nbsp;</xsl:text></xsl:with-param>
            <xsl:with-param name="Action"><xsl:value-of select="command[@name='calendarGroups']"/></xsl:with-param>
           </xsl:call-template>
          <xsl:call-template name="toolbar-tab_item">
            <xsl:with-param name="Name"><xsl:text>&nbsp;</xsl:text>選項<xsl:text>&nbsp;</xsl:text></xsl:with-param>
            <xsl:with-param name="Action"><xsl:value-of select="command[@name='options']"/></xsl:with-param>
          </xsl:call-template>
        </xsl:if>

        <TD align="right" bgcolor="{$bgcolor_table_top}">
          <img src="imx/spacer.gif" width="1" height="5"/>
        </TD>
      </TR>
    </TABLE>
    </TD>
  </TR>
</TABLE>
</xsl:template>

<xsl:template name="overview-toolbar-icons">
<TABLE border="0" cellpadding="3" cellspacing="1">
  <TR>
    <xsl:if test="/calendar/usrctx/user/@name != 'anonymous'">

      <xsl:call-template name="overview-toolbar-icons-item">
        <xsl:with-param name="Img">imx/event.gif</xsl:with-param><xsl:with-param name="AltText">排程會議、生日或其他事件</xsl:with-param>
        <xsl:with-param name="CommandName">new_event</xsl:with-param>
        <xsl:with-param name="ButtonText">新增事件</xsl:with-param>
        <xsl:with-param name="LastOne">False</xsl:with-param>
      </xsl:call-template>

      <xsl:call-template name="overview-toolbar-icons-item">
        <xsl:with-param name="Img">imx/task.gif</xsl:with-param><xsl:with-param name="AltText">新增項目至您的待辦事項清單</xsl:with-param>
        <xsl:with-param name="CommandName">new_task</xsl:with-param>
        <xsl:with-param name="ButtonText">新增工作</xsl:with-param>
        <xsl:with-param name="LastOne">False</xsl:with-param>
      </xsl:call-template>

    </xsl:if>

    <xsl:call-template name="overview-toolbar-icons-item">
      <xsl:with-param name="Img">imx/goto2.gif</xsl:with-param><xsl:with-param name="AltText">跳躍至新日期</xsl:with-param>
      <xsl:with-param name="CommandName">jump_to</xsl:with-param>
      <xsl:with-param name="ButtonText">跳至</xsl:with-param>
      <xsl:with-param name="LastOne">False</xsl:with-param>
    </xsl:call-template>

    <xsl:call-template name="overview-toolbar-icons-item">
      <xsl:with-param name="Img">imx/printer.gif</xsl:with-param><xsl:with-param name="AltText">開啟目前檢視適合列印的版本</xsl:with-param>
      <xsl:with-param name="CommandName">print</xsl:with-param>
      <xsl:with-param name="ButtonText">列印專用</xsl:with-param>
      <xsl:with-param name="LastOne">False</xsl:with-param>
    </xsl:call-template>

    <xsl:call-template name="overview-toolbar-icons-item">
      <xsl:with-param name="Img">imx/search.gif</xsl:with-param><xsl:with-param name="AltText">搜尋事件與工作</xsl:with-param>
      <xsl:with-param name="CommandName">search_for_components</xsl:with-param>
      <xsl:with-param name="ButtonText">搜尋</xsl:with-param>
      <xsl:with-param name="LastOne">true</xsl:with-param>
    </xsl:call-template>

    <TD align="right" width="90%"><FONT face="{$font_name}" size="{$font_size_big}" color="{$bgcolor_brand}">
    目前的行事曆：<xsl:text>  </xsl:text>
    <xsl:text>&nbsp;</xsl:text>
    <xsl:call-template name="CalendarGroupSelector"/></FONT>
    </TD>
  </TR>
</TABLE>
</xsl:template>

<xsl:template name="calendar-toolbar-icons">

<TABLE border="0" cellpadding="3" cellspacing="1">
  <TR>
    <xsl:call-template name="overview-toolbar-icons-item">
      <xsl:with-param name="Img">imx/calendar.gif</xsl:with-param><xsl:with-param name="AltText">建立新的行事曆</xsl:with-param>
      <xsl:with-param name="CommandName">new_cal</xsl:with-param>
      <xsl:with-param name="ButtonText">新增行事曆</xsl:with-param>
      <xsl:with-param name="LastOne">false</xsl:with-param>
    </xsl:call-template>

    <xsl:call-template name="overview-toolbar-icons-item">
      <xsl:with-param name="Img">imx/agenda.gif</xsl:with-param><xsl:with-param name="AltText">建立行事曆的新群組</xsl:with-param>
      <xsl:with-param name="CommandName">new_group</xsl:with-param>
      <xsl:with-param name="ButtonText">新增群組</xsl:with-param>
      <xsl:with-param name="LastOne">true</xsl:with-param>
    </xsl:call-template>

    <xsl:call-template name="overview-toolbar-icons-item">
      <xsl:with-param name="Img">imx/search.gif</xsl:with-param><xsl:with-param name="AltText">搜尋行事曆</xsl:with-param>
      <xsl:with-param name="CommandName">search_for_cals</xsl:with-param>
      <xsl:with-param name="ButtonText">訂閱</xsl:with-param>
      <xsl:with-param name="LastOne">true</xsl:with-param>
    </xsl:call-template>

    <TD align="right" width="90%"><FONT face="{$font_name}" size="{$font_size_small}" color="{$bgcolor_brand}"><xsl:text>&nbsp;</xsl:text></FONT></TD>
  </TR>
</TABLE>
</xsl:template>

</xsl:stylesheet>
