<?xml version="1.0"?>

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- set the output properties -->
<xsl:output method="html" encoding="ISO-8859-1"/>

<!-- Include main display XSL instructions -->
<xsl:include href="common.xsl"/>
<xsl:include href="i18n.xsl"/>
<xsl:include href="date_format.xsl"/>
<xsl:include href="toolbar.xsl"/>

<xsl:template match="calendar">

  <xsl:choose>
    <xsl:when test="@top='true'">

    <xsl:variable name="Frame1"><xsl:value-of select="frame[1]"/></xsl:variable>
    <xsl:variable name="Frame2"><xsl:value-of select="frame[2]"/></xsl:variable>
    <xsl:variable name="Frame3"><xsl:value-of select="frame[3]"/></xsl:variable>
    <xsl:variable name="Frame4"><xsl:value-of select="frame[4]"/></xsl:variable>

    <HTML>
    <HEAD>
<!--    <xsl:call-template name="contextJavascript"/> -->
        <xsl:call-template name="javascript_vars"/>
        <SCRIPT SRC="js_context.js">alert('NotFound');</SCRIPT>

    <TITLE><xsl:value-of select="$calendar_express_page_title"/></TITLE>
    </HEAD>
    <FRAMESET border="0" frameborder="0" rows="85,*,45">
      <FRAME name="tab" marginheight="0" marginwidth="0" scrolling="no" scrollbars="no" src="{$Frame1}"/>
      <FRAMESET border="0" frameborder="0" cols="170,*">
        <FRAME name="tabs" marginheight="0" marginwidth="0" scrolling="no" scrollbars="no">
          <xsl:attribute name="src">
            <xsl:value-of select="$Frame2"/><xsl:text disable-output-escaping="yes">&amp;</xsl:text><xsl:value-of select="/calendar/@tab"/>
          </xsl:attribute>
        </FRAME>
        <FRAME name="main" frameborder="0" src="{$Frame3}"/>
      </FRAMESET>
      <FRAME name="button" marginheight="0" marginwidth="0" scrolling="no" scrollbars="no" frameborder="0" src="{$Frame4}"/>
    </FRAMESET>
    </HTML>

    </xsl:when>

    <xsl:when test="@view='toolbar'">
      <xsl:call-template name="options_toolbar_root"/>
    </xsl:when>

    <xsl:when test="@view='tabs'">
      <xsl:for-each select="group">
        <xsl:if test="@name='tabs'">
          <xsl:call-template name="options_tabs_root"/>
        </xsl:if>
      </xsl:for-each>
    </xsl:when>

    <xsl:when test="@view='main'">
      <xsl:for-each select="group">
        <xsl:if test="@name='main'">
          <xsl:choose>
            <xsl:when test="/calendar/@tab = '2'">
              <xsl:call-template name="settings_root"/>      
            </xsl:when>
            <xsl:when test="/calendar/@tab = '3'">
              <xsl:call-template name="import_root"/>
            </xsl:when>
            <xsl:when test="/calendar/@tab = '4'">
              <xsl:call-template name="export_root"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:call-template name="appearance_root"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:if>
      </xsl:for-each>
    </xsl:when>

   <xsl:when test="@view='button'">
    <xsl:for-each select="group">
      <xsl:if test="@name='button'">
      <xsl:choose>
        <xsl:when test="/calendar/@tab = '3'">
          <xsl:call-template name="options_button_import"/>
        </xsl:when>
        <xsl:when test="/calendar/@tab = '4'">
          <xsl:call-template name="options_button_export"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:call-template name="options_button_root"/>
        </xsl:otherwise>
      </xsl:choose>
      </xsl:if>
     </xsl:for-each>
    </xsl:when>

    <xsl:otherwise>
      <html>What's this view? (options.xsl) -<xsl:value-of select="@view"/></html>
    </xsl:otherwise>

  </xsl:choose>
</xsl:template>

<!-- Output each options tab -->
<xsl:template name="tab_item">
  <xsl:param name="Index"/>
  <xsl:param name="Selected_Index"/>
  <xsl:param name="Name"/>
  <xsl:param name="Action"/>

  <xsl:choose>
    <xsl:when test="$Selected_Index!=$Index">
      <TR bgcolor="{$bgcolor_button}">
        <TD nowrap="" align="center"><FONT face="{$font_name}" size="{$font_size_big_2}" color="{$bgcolor_wend_top}"><xsl:text>&nbsp;</xsl:text><A href="{$Action}" style="text-decoration:none;"><FONT color="#FFFFFF"><xsl:value-of select="$Name"/></FONT></A><xsl:text>&nbsp;</xsl:text></FONT></TD>
      </TR>
    </xsl:when>

    <xsl:when test="$Selected_Index=$Index">
      <TR><TD nowrap="" align="center" bgcolor="{$bgcolor_form_selected}"><FONT face="{$font_name}" size="{$font_size_big_2}" color="#000000"><B><xsl:text>&nbsp;</xsl:text><xsl:value-of select="$Name"/><xsl:text>&nbsp;</xsl:text></B></FONT></TD></TR>
    </xsl:when>
  </xsl:choose>
</xsl:template>

<!-- Output all options tabs -->
<xsl:template name="options_tabs_root">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>

<BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="9" marginheight="9">

<xsl:call-template name="options_load_tabs"/>

<FORM name="form" method="post">
<TABLE border="0" cellpadding="0" cellspacing="0">
  <TR>
    <TD bgcolor="#000000"><TABLE border="0" cellpadding="2" cellspacing="1" width="140"> 
      <xsl:call-template name="tab_item">
        <xsl:with-param name="Index">1</xsl:with-param>
        <xsl:with-param name="Selected_Index">
          <xsl:value-of select="/calendar/@tab"/>
        </xsl:with-param>
        <xsl:with-param name="Name"><xsl:value-of select="$appearance_title"/></xsl:with-param>
        <xsl:with-param name="Action">
          <xsl:value-of select="./tabs/tab[1]"/>
        </xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="tab_item">
        <xsl:with-param name="Index">2</xsl:with-param>
        <xsl:with-param name="Selected_Index">
          <xsl:value-of select="/calendar/@tab"/>
        </xsl:with-param>
        <xsl:with-param name="Name"><xsl:value-of select="$settings_title"/></xsl:with-param>
        <xsl:with-param name="Action">
          <xsl:value-of select="./tabs/tab[2]"/>
        </xsl:with-param></xsl:call-template>
      <xsl:call-template name="tab_item">
        <xsl:with-param name="Index">3</xsl:with-param>
        <xsl:with-param name="Selected_Index">
          <xsl:value-of select="/calendar/@tab"/>
        </xsl:with-param>
        <xsl:with-param name="Name"><xsl:value-of select="$import_title"/></xsl:with-param>
        <xsl:with-param name="Action">
          <xsl:value-of select="./tabs/tab[3]"/>
        </xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="tab_item">
        <xsl:with-param name="Index">4</xsl:with-param>
        <xsl:with-param name="Selected_Index">
          <xsl:value-of select="/calendar/@tab"/>
        </xsl:with-param>
        <xsl:with-param name="Name"><xsl:value-of select="$export_title"/></xsl:with-param>
        <xsl:with-param name="Action">
          <xsl:value-of select="./tabs/tab[4]"/>
        </xsl:with-param>
      </xsl:call-template>
    </TABLE></TD>
  </TR>
</TABLE>
</FORM>

</BODY>
</HTML>
</xsl:template>

<!-- Output Settings options -->
<xsl:template name="settings_root">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>

<BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="9" marginheight="9">
<FORM method="post">
  <xsl:attribute name="action"><xsl:value-of select="./formdata/@action"/></xsl:attribute>
  <xsl:attribute name="name">form</xsl:attribute>
  <xsl:apply-templates select="formdata"/>
  <INPUT type="hidden" name="doNotProcess" value="0"/>
  <INPUT type="hidden" name="optionsTab" value="settings"/>

<TABLE border="0" cellpadding="3" cellspacing="1" width="100%">
<TR>
<TD>
<B>
<FONT size="{$font_size_big_3}" face="{$font_name}">
<xsl:value-of select="$settings_title"/></FONT>
</B>
<BR/>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<xsl:value-of select="$settings_msg"/>
</FONT>
<HR size="{$font_size_big}"/>
</TD>
</TR>
<TR>
<TD>
<B>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<xsl:value-of select="$default_view_title"/></FONT>
</B>
<BR/>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<xsl:value-of select="$default_view_msg"/>
</FONT>
<!-- Changing this does not affect the current view -->
  <FONT size="{$font_size_big_2}" face="{$font_name}">
  <SELECT name="ceDefaultView">
    <OPTION value="overview">
      <xsl:if test="/calendar/usrctx/userprefs/@ceDefaultView = 'overview'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      <xsl:value-of select="$overview_tab_title"/>
    </OPTION>
    <OPTION value="dayview">
      <xsl:if test="/calendar/usrctx/userprefs/@ceDefaultView = 'dayview'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      <xsl:value-of select="$day_tab_title"/>
    </OPTION>
    <OPTION value="weekview">
      <xsl:if test="/calendar/usrctx/userprefs/@ceDefaultView = 'weekview'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      <xsl:value-of select="$week_tab_title"/>
    </OPTION>
    <OPTION value="monthview">
      <xsl:if test="/calendar/usrctx/userprefs/@ceDefaultView = 'monthview'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      <xsl:value-of select="$month_tab_title"/>
    </OPTION>
    <OPTION value="yearview">
      <xsl:if test="/calendar/usrctx/userprefs/@ceDefaultView = 'yearview'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      <xsl:value-of select="$year_tab_title"/>
    </OPTION>
    <OPTION value="groupview">
      <xsl:if test="/calendar/usrctx/userprefs/@ceDefaultView = 'groupview'">
        <xsl:attribute name="selected"/>
      </xsl:if>
      <xsl:value-of select="$comparison_tab_title"/>
    </OPTION>
  </SELECT>
  </FONT>
</TD>
</TR>
<TR>
<TD>
<IMG src="imx/spacer.gif" width="1" height="1"/>
</TD>
</TR>
<TR>
<TD>
<B>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<xsl:value-of select="$default_group_title"/></FONT>
</B>
<BR/>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<xsl:value-of select="$default_group_msg"/></FONT>
<!-- Changing this does not affect the selectedGroup -->
  <FONT size="{$font_size_big_2}" face="{$font_name}">
  <SELECT name="ceDefaultAgenda">
    <OPTION value="">
      <xsl:value-of select="$no_cal_group_title"/>
    </OPTION>
    <xsl:for-each select="/calendar/usrctx/usergroup">
      <OPTION>
        <xsl:attribute name="value">
          <xsl:value-of select="./@name"/>
        </xsl:attribute>
        <xsl:if test="/calendar/usrctx/userprefs/@ceDefaultAgenda = ./@name">
          <xsl:attribute name="selected"/>
        </xsl:if>
        <xsl:value-of select="$horiz_divider"/>
        <xsl:call-template name="printCalendarName">
          <xsl:with-param name="name" select="@name"/>
        </xsl:call-template>
      </OPTION>
    </xsl:for-each>
  </SELECT>
  </FONT>
</TD>
</TR>
<TR>
<TD>
<IMG src="imx/spacer.gif" width="1" height="1"/>
</TD>
</TR>


<TR>
<TD>
<B>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<xsl:value-of select="$group_invitations_title"/></FONT>
</B>
<BR/>
</TD>
</TR>
<TR>
<TD>
<!-- Reverse Logic..  if it is 0, dont check.  If it is 1 or no value, check it -->
<INPUT type="checkbox" name="ceGroupInviteAll">
<xsl:choose>
  <xsl:when test="/calendar/usrctx/userprefs/@ceGroupInviteAll='0'"></xsl:when>
  <xsl:otherwise><xsl:attribute name="checked"/></xsl:otherwise>
</xsl:choose>
</INPUT>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<xsl:text>&nbsp;</xsl:text><xsl:value-of select="$invite_group_msg"/></FONT>
</TD>
</TR>

<TR>
<TD>
<IMG src="imx/spacer.gif" width="1" height="1"/>
</TD>
</TR>

<TR>
<TD>
<B>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<xsl:value-of select="$date_title"/></FONT>
</B>
</TD>
</TR>
<TR>
<TD>
<TABLE border="0" cellpadding="0" cellspacing="1">
<TR>
<TD>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<xsl:value-of select="$date_format_msg"/>
<SELECT name="ceDateOrder">
  <OPTION value="M/D/Y">
    <xsl:if test="$dateorder='M/D/Y'">
      <xsl:attribute name="selected"/>
    </xsl:if>
    <xsl:value-of select="$m_d_y_format_text"/>
  </OPTION>
  <OPTION value="D/M/Y">
    <xsl:if test="$dateorder='D/M/Y'">
      <xsl:attribute name="selected"/>
    </xsl:if>
    <xsl:value-of select="$d_m_y_format_text"/>
  </OPTION>
  <OPTION value="Y/M/D">
    <xsl:if test="$dateorder='Y/M/D'">
      <xsl:attribute name="selected"/>
    </xsl:if>
    <xsl:value-of select="$y_m_d_format_text"/>
  </OPTION>
</SELECT>
</FONT>
</TD>
</TR>
<TR>
<TD>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<xsl:value-of select="$date_delimiter_msg"/>&nbsp;
  <INPUT type="text" name="ceDateSeparator" size="{$font_size_big}" maxlength="1" value="{$dateseparator}"/>
</FONT>
</TD>
</TR>
</TABLE>
</TD>
</TR>
<TR>
<TD>
<IMG src="imx/spacer.gif" width="1" height="1"/>
</TD>
</TR>
<TR>
<TD>
<B>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<xsl:value-of select="$time_title"/></FONT>
</B>
</TD>
</TR>
<TR>
<TD>
<TABLE border="0" cellpadding="0" cellspacing="1">
<TR>
<TD>
<INPUT type="radio" name="ceClock" value="12"><xsl:if test="(string-length(/calendar/usrctx/userprefs/@ceClock) = 0) or (/calendar/usrctx/userprefs/@ceClock='12')"><xsl:attribute name="checked"/></xsl:if></INPUT>
</TD>
<TD>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<xsl:value-of select="$use_12_clock_msg"/></FONT>
</TD>
</TR>
<TR>
<TD>
<INPUT type="radio" name="ceClock" value="24"><xsl:if test="/calendar/usrctx/userprefs/@ceClock='24'"><xsl:attribute name="checked"/></xsl:if></INPUT>
</TD>
<TD>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<xsl:value-of select="$use_24_clock_msg"/></FONT>
</TD>
</TR>
</TABLE>
</TD>
</TR>
<TR>
<TD>
<IMG src="imx/spacer.gif" width="1" height="1"/>
</TD>
</TR>
<TR>
<TD>
<B>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<xsl:value-of select="$day_title"/></FONT>
</B>
</TD>
</TR>
<TR>
<TD>
<TABLE border="0" cellpadding="0" cellspacing="1">
<TR>
<TD>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<xsl:value-of select="$day_starts_msg"/><SELECT name="ceDayHead">
<OPTION value="0">
<xsl:if test="/calendar/usrctx/userprefs/@ceDayHead='0'"><xsl:attribute name="selected"/></xsl:if>
<xsl:call-template name="formatLongTime">
  <xsl:with-param name="Hour" select="0"/>
</xsl:call-template></OPTION>
<OPTION value="1">
<xsl:if test="/calendar/usrctx/userprefs/@ceDayHead='1'"><xsl:attribute name="selected"/></xsl:if>
<xsl:call-template name="formatLongTime">
  <xsl:with-param name="Hour" select="1"/>
</xsl:call-template></OPTION>
<OPTION value="2">
<xsl:if test="/calendar/usrctx/userprefs/@ceDayHead='2'"><xsl:attribute name="selected"/></xsl:if>
<xsl:call-template name="formatLongTime">
  <xsl:with-param name="Hour" select="2"/>
</xsl:call-template></OPTION>
<OPTION value="3">
<xsl:if test="/calendar/usrctx/userprefs/@ceDayHead='3'"><xsl:attribute name="selected"/></xsl:if>
<xsl:call-template name="formatLongTime">
  <xsl:with-param name="Hour" select="3"/>
</xsl:call-template></OPTION>
<OPTION value="4">
<xsl:if test="/calendar/usrctx/userprefs/@ceDayHead='4'"><xsl:attribute name="selected"/></xsl:if>
<xsl:call-template name="formatLongTime">
  <xsl:with-param name="Hour" select="4"/>
</xsl:call-template></OPTION>
<OPTION value="5">
<xsl:if test="/calendar/usrctx/userprefs/@ceDayHead='5'"><xsl:attribute name="selected"/></xsl:if>
<xsl:call-template name="formatLongTime">
  <xsl:with-param name="Hour" select="5"/>
</xsl:call-template></OPTION>
<OPTION value="6">
<xsl:if test="/calendar/usrctx/userprefs/@ceDayHead='6'"><xsl:attribute name="selected"/></xsl:if>
<xsl:call-template name="formatLongTime">
  <xsl:with-param name="Hour" select="6"/>
</xsl:call-template></OPTION>
<OPTION value="7">
<xsl:if test="/calendar/usrctx/userprefs/@ceDayHead='7'"><xsl:attribute name="selected"/></xsl:if>
<xsl:call-template name="formatLongTime">
  <xsl:with-param name="Hour" select="7"/>
</xsl:call-template></OPTION>
<OPTION value="8">
<xsl:if test="(string-length(/calendar/usrctx/userprefs/@ceDayHead) = 0) or (/calendar/usrctx/userprefs/@ceDayHead='8')"><xsl:attribute name="selected"/></xsl:if>
<xsl:call-template name="formatLongTime">
  <xsl:with-param name="Hour" select="8"/>
</xsl:call-template></OPTION>
<OPTION value="9">
<xsl:if test="/calendar/usrctx/userprefs/@ceDayHead='9'"><xsl:attribute name="selected"/></xsl:if>
<xsl:call-template name="formatLongTime">
  <xsl:with-param name="Hour" select="9"/>
</xsl:call-template></OPTION>
<OPTION value="10">
<xsl:if test="/calendar/usrctx/userprefs/@ceDayHead='10'"><xsl:attribute name="selected"/></xsl:if>
<xsl:call-template name="formatLongTime">
  <xsl:with-param name="Hour" select="10"/>
</xsl:call-template></OPTION>
<OPTION value="11">
<xsl:if test="/calendar/usrctx/userprefs/@ceDayHead='11'"><xsl:attribute name="selected"/></xsl:if>
<xsl:call-template name="formatLongTime">
  <xsl:with-param name="Hour" select="11"/>
</xsl:call-template></OPTION>
<OPTION value="12">
<xsl:if test="/calendar/usrctx/userprefs/@ceDayHead='12'"><xsl:attribute name="selected"/></xsl:if>
<xsl:call-template name="formatLongTime">
  <xsl:with-param name="Hour" select="12"/>
</xsl:call-template></OPTION>
<OPTION value="13">
<xsl:if test="/calendar/usrctx/userprefs/@ceDayHead='13'"><xsl:attribute name="selected"/></xsl:if>
<xsl:call-template name="formatLongTime">
  <xsl:with-param name="Hour" select="13"/>
</xsl:call-template></OPTION>
<OPTION value="14">
<xsl:if test="/calendar/usrctx/userprefs/@ceDayHead='14'"><xsl:attribute name="selected"/></xsl:if>
<xsl:call-template name="formatLongTime">
  <xsl:with-param name="Hour" select="14"/>
</xsl:call-template></OPTION>
<OPTION value="15">
<xsl:if test="/calendar/usrctx/userprefs/@ceDayHead='15'"><xsl:attribute name="selected"/></xsl:if>
<xsl:call-template name="formatLongTime">
  <xsl:with-param name="Hour" select="15"/>
</xsl:call-template></OPTION>
<OPTION value="16">
<xsl:if test="/calendar/usrctx/userprefs/@ceDayHead='16'"><xsl:attribute name="selected"/></xsl:if>
<xsl:call-template name="formatLongTime">
  <xsl:with-param name="Hour" select="16"/>
</xsl:call-template></OPTION>
<OPTION value="17">
<xsl:if test="/calendar/usrctx/userprefs/@ceDayHead='17'"><xsl:attribute name="selected"/></xsl:if>
<xsl:call-template name="formatLongTime">
  <xsl:with-param name="Hour" select="17"/>
</xsl:call-template></OPTION>
<OPTION value="18">
<xsl:if test="/calendar/usrctx/userprefs/@ceDayHead='18'"><xsl:attribute name="selected"/></xsl:if>
<xsl:call-template name="formatLongTime">
  <xsl:with-param name="Hour" select="18"/>
</xsl:call-template></OPTION>
<OPTION value="19">
<xsl:if test="/calendar/usrctx/userprefs/@ceDayHead='19'"><xsl:attribute name="selected"/></xsl:if>
<xsl:call-template name="formatLongTime">
  <xsl:with-param name="Hour" select="19"/>
</xsl:call-template></OPTION>
<OPTION value="20">
<xsl:if test="/calendar/usrctx/userprefs/@ceDayHead='20'"><xsl:attribute name="selected"/></xsl:if>
<xsl:call-template name="formatLongTime">
  <xsl:with-param name="Hour" select="20"/>
</xsl:call-template></OPTION>
<OPTION value="21">
<xsl:if test="/calendar/usrctx/userprefs/@ceDayHead='21'"><xsl:attribute name="selected"/></xsl:if>
<xsl:call-template name="formatLongTime">
  <xsl:with-param name="Hour" select="21"/>
</xsl:call-template></OPTION>
<OPTION value="22">
<xsl:if test="/calendar/usrctx/userprefs/@ceDayHead='22'"><xsl:attribute name="selected"/></xsl:if>
<xsl:call-template name="formatLongTime">
  <xsl:with-param name="Hour" select="22"/>
</xsl:call-template></OPTION>
<OPTION value="23">
<xsl:if test="/calendar/usrctx/userprefs/@ceDayHead='23'"><xsl:attribute name="selected"/></xsl:if>
<xsl:call-template name="formatLongTime">
  <xsl:with-param name="Hour" select="23"/>
</xsl:call-template></OPTION>
</SELECT>
</FONT>
</TD>
</TR>
<TR>
<TD>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<xsl:value-of select="$day_ends_msg"/><SELECT name="ceDayTail">
<OPTION value="0">
<xsl:if test="/calendar/usrctx/userprefs/@ceDayTail='0'"><xsl:attribute name="selected"/></xsl:if>
<xsl:call-template name="formatLongTime">
  <xsl:with-param name="Hour" select="0"/>
</xsl:call-template></OPTION>
<OPTION value="1">
<xsl:if test="/calendar/usrctx/userprefs/@ceDayTail='1'"><xsl:attribute name="selected"/></xsl:if>
<xsl:call-template name="formatLongTime">
  <xsl:with-param name="Hour" select="1"/>
</xsl:call-template></OPTION>
<OPTION value="2">
<xsl:if test="/calendar/usrctx/userprefs/@ceDayTail='2'"><xsl:attribute name="selected"/></xsl:if>
<xsl:call-template name="formatLongTime">
  <xsl:with-param name="Hour" select="2"/>
</xsl:call-template></OPTION>
<OPTION value="3">
<xsl:if test="/calendar/usrctx/userprefs/@ceDayTail='3'"><xsl:attribute name="selected"/></xsl:if>
<xsl:call-template name="formatLongTime">
  <xsl:with-param name="Hour" select="3"/>
</xsl:call-template></OPTION>
<OPTION value="4">
<xsl:if test="/calendar/usrctx/userprefs/@ceDayTail='4'"><xsl:attribute name="selected"/></xsl:if>
<xsl:call-template name="formatLongTime">
  <xsl:with-param name="Hour" select="4"/>
</xsl:call-template></OPTION>
<OPTION value="5">
<xsl:if test="/calendar/usrctx/userprefs/@ceDayTail='5'"><xsl:attribute name="selected"/></xsl:if>
<xsl:call-template name="formatLongTime">
  <xsl:with-param name="Hour" select="5"/>
</xsl:call-template></OPTION>
<OPTION value="6">
<xsl:if test="/calendar/usrctx/userprefs/@ceDayTail='6'"><xsl:attribute name="selected"/></xsl:if>
<xsl:call-template name="formatLongTime">
  <xsl:with-param name="Hour" select="6"/>
</xsl:call-template></OPTION>
<OPTION value="7">
<xsl:if test="/calendar/usrctx/userprefs/@ceDayTail='7'"><xsl:attribute name="selected"/></xsl:if>
<xsl:call-template name="formatLongTime">
  <xsl:with-param name="Hour" select="7"/>
</xsl:call-template></OPTION>
<OPTION value="8">
<xsl:if test="/calendar/usrctx/userprefs/@ceDayTail='8'"><xsl:attribute name="selected"/></xsl:if>
<xsl:call-template name="formatLongTime">
  <xsl:with-param name="Hour" select="8"/>
</xsl:call-template></OPTION>
<OPTION value="9">
<xsl:if test="/calendar/usrctx/userprefs/@ceDayTail='9'"><xsl:attribute name="selected"/></xsl:if>
<xsl:call-template name="formatLongTime">
  <xsl:with-param name="Hour" select="9"/>
</xsl:call-template></OPTION>
<OPTION value="10">
<xsl:if test="/calendar/usrctx/userprefs/@ceDayTail='10'"><xsl:attribute name="selected"/></xsl:if>
<xsl:call-template name="formatLongTime">
  <xsl:with-param name="Hour" select="10"/>
</xsl:call-template></OPTION>
<OPTION value="11">
<xsl:if test="/calendar/usrctx/userprefs/@ceDayTail='11'"><xsl:attribute name="selected"/></xsl:if>
<xsl:call-template name="formatLongTime">
  <xsl:with-param name="Hour" select="11"/>
</xsl:call-template></OPTION>
<OPTION value="12">
<xsl:if test="/calendar/usrctx/userprefs/@ceDayTail='12'"><xsl:attribute name="selected"/></xsl:if>
<xsl:call-template name="formatLongTime">
  <xsl:with-param name="Hour" select="12"/>
</xsl:call-template></OPTION>
<OPTION value="13">
<xsl:if test="/calendar/usrctx/userprefs/@ceDayTail='13'"><xsl:attribute name="selected"/></xsl:if>
<xsl:call-template name="formatLongTime">
  <xsl:with-param name="Hour" select="13"/>
</xsl:call-template></OPTION>
<OPTION value="14">
<xsl:if test="/calendar/usrctx/userprefs/@ceDayTail='14'"><xsl:attribute name="selected"/></xsl:if>
<xsl:call-template name="formatLongTime">
  <xsl:with-param name="Hour" select="14"/>
</xsl:call-template></OPTION>
<OPTION value="15">
<xsl:if test="/calendar/usrctx/userprefs/@ceDayTail='15'"><xsl:attribute name="selected"/></xsl:if>
<xsl:call-template name="formatLongTime">
  <xsl:with-param name="Hour" select="15"/>
</xsl:call-template></OPTION>
<OPTION value="16">
<xsl:if test="/calendar/usrctx/userprefs/@ceDayTail='16'"><xsl:attribute name="selected"/></xsl:if>
<xsl:call-template name="formatLongTime">
  <xsl:with-param name="Hour" select="16"/>
</xsl:call-template></OPTION>
<OPTION value="17">
<xsl:if test="/calendar/usrctx/userprefs/@ceDayTail='17'"><xsl:attribute name="selected"/></xsl:if>
<xsl:call-template name="formatLongTime">
  <xsl:with-param name="Hour" select="17"/>
</xsl:call-template></OPTION>
<OPTION value="18">
<xsl:if test="(string-length(/calendar/usrctx/userprefs/@ceDayTail) = 0) or (/calendar/usrctx/userprefs/@ceDayTail='18')"><xsl:attribute name="selected"/></xsl:if>
<xsl:call-template name="formatLongTime">
  <xsl:with-param name="Hour" select="18"/>
</xsl:call-template></OPTION>
<OPTION value="19">
<xsl:if test="/calendar/usrctx/userprefs/@ceDayTail='19'"><xsl:attribute name="selected"/></xsl:if>
<xsl:call-template name="formatLongTime">
  <xsl:with-param name="Hour" select="19"/>
</xsl:call-template></OPTION>
<OPTION value="20">
<xsl:if test="/calendar/usrctx/userprefs/@ceDayTail='20'"><xsl:attribute name="selected"/></xsl:if>
<xsl:call-template name="formatLongTime">
  <xsl:with-param name="Hour" select="20"/>
</xsl:call-template></OPTION>
<OPTION value="21">
<xsl:if test="/calendar/usrctx/userprefs/@ceDayTail='21'"><xsl:attribute name="selected"/></xsl:if>
<xsl:call-template name="formatLongTime">
  <xsl:with-param name="Hour" select="21"/>
</xsl:call-template></OPTION>
<OPTION value="22">
<xsl:if test="/calendar/usrctx/userprefs/@ceDayTail='22'"><xsl:attribute name="selected"/></xsl:if>
<xsl:call-template name="formatLongTime">
  <xsl:with-param name="Hour" select="22"/>
</xsl:call-template></OPTION>
<OPTION value="23">
<xsl:if test="/calendar/usrctx/userprefs/@ceDayTail='23'"><xsl:attribute name="selected"/></xsl:if>
<xsl:call-template name="formatLongTime">
  <xsl:with-param name="Hour" select="23"/>
</xsl:call-template></OPTION>
</SELECT>
</FONT>
</TD>
</TR>
<TR>
<TD>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<xsl:value-of select="$day_interval_msg"/><SELECT name="ceInterval">
<OPTION value="PT0H15M">
<xsl:if test="(/calendar/usrctx/userprefs/@ceInterval='PT0H15M') or (/calendar/usrctx/userprefs/@ceInterval='P0H15M')"><xsl:attribute name="selected"/></xsl:if>
<xsl:value-of select="$every_15_minutes_text"/></OPTION>
<OPTION value="PT0H30M">
<xsl:if test="(/calendar/usrctx/userprefs/@ceInterval='PT0H30M') or (/calendar/usrctx/userprefs/@ceInterval='P0H30M')"><xsl:attribute name="selected"/></xsl:if>
<xsl:value-of select="$every_half_hour_text"/></OPTION>
<OPTION value="PT1H0M">
<xsl:if test="(string-length(/calendar/usrctx/userprefs/@ceInterval) = 0) or (/calendar/usrctx/userprefs/@ceInterval='PT1H0M') or (/calendar/usrctx/userprefs/@ceInterval='P1H0M')"><xsl:attribute name="selected"/></xsl:if>
<xsl:value-of select="$every_hour_text"/></OPTION>
<OPTION value="PT2H0M">
<xsl:if test="(/calendar/usrctx/userprefs/@ceInterval='PT2H0M') or (/calendar/usrctx/userprefs/@ceInterval='P2H0M')"><xsl:attribute name="selected"/></xsl:if>
<xsl:value-of select="$every_2_hours_text"/></OPTION>
<OPTION value="PT4H0M">
<xsl:if test="(/calendar/usrctx/userprefs/@ceInterval='PT4H0M') or (/calendar/usrctx/userprefs/@ceInterval='PT4H0M')"><xsl:attribute name="selected"/></xsl:if>
<xsl:value-of select="$every_four_hours_text"/></OPTION>
</SELECT>
</FONT>
</TD>
</TR>
</TABLE>
</TD>
</TR>
<TR>
<TD>
<IMG src="imx/spacer.gif" width="1" height="1"/>
</TD>
</TR>
<TR>
<TD>
<B>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<xsl:value-of select="$first_dow_title"/>
</FONT>
</B>
</TD>
</TR>
<TR>
<TD>
<TABLE border="0" cellpadding="0" cellspacing="1">
<TR>
<TD>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<SELECT name="icsFirstDay">
  <OPTION value="1">
    <xsl:if test="/calendar/usrctx/userprefs/@icsFirstDay='1'">
      <xsl:attribute name="selected"/>
    </xsl:if>
    <xsl:value-of select="$sunday_title"/>
  </OPTION>
  <OPTION value="2">
    <xsl:if test="/calendar/usrctx/userprefs/@icsFirstDay='2'">
      <xsl:attribute name="selected"/>
    </xsl:if>
    <xsl:value-of select="$monday_title"/>
  </OPTION>
  <OPTION value="3">
    <xsl:if test="/calendar/usrctx/userprefs/@icsFirstDay='3'">
      <xsl:attribute name="selected"/>
    </xsl:if>
    <xsl:value-of select="$tuesday_title"/>
  </OPTION>
  <OPTION value="4">
    <xsl:if test="/calendar/usrctx/userprefs/@icsFirstDay='4'">
      <xsl:attribute name="selected"/>
    </xsl:if>
    <xsl:value-of select="$wednesday_title"/>
  </OPTION>
  <OPTION value="5">
    <xsl:if test="/calendar/usrctx/userprefs/@icsFirstDay='5'">
      <xsl:attribute name="selected"/>
    </xsl:if>
    <xsl:value-of select="$thursday_title"/>
  </OPTION>
  <OPTION value="6">
    <xsl:if test="/calendar/usrctx/userprefs/@icsFirstDay='6'">
      <xsl:attribute name="selected"/>
    </xsl:if>
    <xsl:value-of select="$friday_title"/>
  </OPTION>
  <OPTION value="7">
    <xsl:if test="/calendar/usrctx/userprefs/@icsFirstDay='7'">
      <xsl:attribute name="selected"/>
    </xsl:if>
    <xsl:value-of select="$saturday_title"/>
  </OPTION>
</SELECT>
</FONT>
</TD>
</TR>
</TABLE>
<INPUT type="checkbox" name="ceExcludeSatSun">
<xsl:if test="/calendar/usrctx/userprefs/@ceExcludeSatSun='1'"><xsl:attribute name="checked"/></xsl:if>
</INPUT>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<xsl:value-of select="$exclude_sat_sun_msg"/></FONT>
</TD>
</TR>
<TR>
<TD>
<IMG src="imx/spacer.gif" width="1" height="1"/>
</TD>
</TR>
<TR>
<TD>
<B>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<xsl:value-of select="$time_zone_title"/></FONT>
</B>
</TD>
</TR>
<TR>
<TD>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<INPUT type="hidden" name="icsTimeZone">
  <xsl:attribute name="value">
    <xsl:value-of select="/calendar/usrctx/userprefs/@icsTimeZone"/>
  </xsl:attribute>
</INPUT>
<xsl:value-of select="$default_tz_msg"/><xsl:text>&nbsp;</xsl:text>
<A>
  <xsl:attribute name="href">
    <xsl:value-of select="command[@name='change_timezone']"/>
  </xsl:attribute>
  <xsl:choose>
    <xsl:when test="string-length(/calendar/usrctx/userprefs/@icsTimeZone) > 0">
       <xsl:call-template name="getDisplayNameOfTZID">
	  <xsl:with-param name="tzid">
             <xsl:value-of select="/calendar/usrctx/userprefs/@icsTimeZone"/>
          </xsl:with-param>
       </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="$none_selected_title"/>
    </xsl:otherwise>
  </xsl:choose>
</A>
</FONT>
</TD>
</TR>

<TR>
<TD>
<INPUT type="checkbox" name="ceCalidTZID">
<xsl:if test="/calendar/usrctx/userprefs/@ceSingleCalendarTZID='1'"><xsl:attribute name="checked"/></xsl:if>
</INPUT>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<xsl:value-of select="$single_tz_use_msg"/></FONT>
</TD>
</TR>

<TR>
<TD>
<INPUT type="checkbox" name="ceAllCalidTZIDs">
<xsl:if test="/calendar/usrctx/userprefs/@ceAllCalendarTZIDs='1'"><xsl:attribute name="checked"/></xsl:if>
</INPUT>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<xsl:value-of select="$tz_timescales_msg"/></FONT>
</TD>
</TR>

<TR>
<TD>
<IMG src="imx/spacer.gif" width="1" height="1"/>
</TD>
</TR>
<TR>
<TD>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<B>
<xsl:value-of select="$event_task_reminders_title"/>
</B>
</FONT>
</TD>
</TR>
<TR>
<TD>
<FONT size="{$font_size_big_2}" face="{$font_name}">
  <INPUT type="checkbox" name="remind">
  <xsl:if test="string-length(/calendar/usrctx/userprefs/@ceDefaultAlarmStart) != 0"><xsl:attribute name="checked"/></xsl:if>
  </INPUT>
  <xsl:value-of select="$before_every_event_task_text"/>
 <INPUT type="text" name="before" size="{$font_size_big_2}" maxlength="2">
   <xsl:attribute name="value">
     <xsl:choose>
       <xsl:when test="string-length(/calendar/usrctx/userprefs/@ceDefaultAlarmStart) != 0">       
         <xsl:value-of select="substring((/calendar/usrctx/userprefs/@ceDefaultAlarmStart), 2, 2)"/>
       </xsl:when>
       <xsl:otherwise>15</xsl:otherwise>
      </xsl:choose>
   </xsl:attribute>
   <xsl:attribute name="onBlur">
       var f = document.forms[0];
       var input_num = f['before'].value;
       var checked_num = checkNumberStringInput(input_num);
       if (checked_num == '-1') {
         f['before'].value = '15';
         alert('<xsl:value-of select="$alert_valid_reminder_interval"/>');
       }
   </xsl:attribute>
  </INPUT>
 </FONT>
 <FONT size="{$font_size_big_2}" face="{$font_name}">
<SELECT name="units">
  <OPTION value="M">
     <xsl:choose>
       <xsl:when test="string-length(/calendar/usrctx/userprefs/@ceDefaultAlarmStart) != 0">
         <xsl:if test="substring((/calendar/usrctx/userprefs/@ceDefaultAlarmStart),4,1) = 'M'">
           <xsl:attribute name="selected"/>
         </xsl:if>
       </xsl:when>
       <xsl:otherwise>
         <xsl:attribute name="selected"/>
       </xsl:otherwise>
      </xsl:choose>
    <xsl:value-of select="$minutes_text"/>
  </OPTION>
  <OPTION value="H">
    <xsl:if test="substring((/calendar/usrctx/userprefs/@ceDefaultAlarmStart),4,1) = 'H'">
      <xsl:attribute name="selected"/>
    </xsl:if>
    <xsl:value-of select="$hours_text"/>
  </OPTION>
  <OPTION value="D">
    <xsl:if test="substring((/calendar/usrctx/userprefs/@ceDefaultAlarmStart),4,1) = 'D'">
      <xsl:attribute name="selected"/>
    </xsl:if>
    <xsl:value-of select="$days_text"/>
  </OPTION>
</SELECT>
<xsl:value-of select="$email_reminder_msg"/><BR/>
<B><xsl:value-of select="$note_title"/> </B> <xsl:value-of select="$reminders_tip_msg"/></FONT>
</TD>
</TR>
<TR>
<TD>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<TEXTAREA name="alarms" cols="63" rows="2" wrap="virtual">
  <xsl:choose>
    <xsl:when test="string-length(/calendar/usrctx/userprefs/@ceDefaultAlarmEmail) > 0">
      <xsl:value-of select="/calendar/usrctx/userprefs/@ceDefaultAlarmEmail"/>
    </xsl:when>
    <xsl:when test="string-length(/calendar/usrctx/user/@mail) > 0">
      <xsl:value-of select="/calendar/usrctx/user/@mail"/>
    </xsl:when>
    <xsl:otherwise>$email</xsl:otherwise>
  </xsl:choose>
</TEXTAREA>
</FONT>
</TD>
</TR>

<!-- Show notification checkbox if it is enabled in ics.conf -->
<xsl:if test="./optionsdata/@allowNotification">
<TR>
<TD>
<IMG src="imx/spacer.gif" width="1" height="1"/>
</TD>
</TR>
<TR>
<TD>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<B><xsl:value-of select="$event_notifications_title"/></B>
</FONT>
</TD>
</TR>
<TR>
<TD>
<INPUT type="checkbox" name="ceNotifyEnable">
<xsl:if test="/calendar/usrctx/userprefs/@ceNotifyEnable='1'"><xsl:attribute name="checked"/></xsl:if>
</INPUT>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<xsl:value-of select="$event_notifications_msg"/><BR/>
<B><xsl:value-of select="$note_title"/> </B><xsl:value-of select="$only_one_email_msg"/><BR/>
 <INPUT type="text" name="NotifyEmail" size="35">
       <xsl:attribute name="value">
        <xsl:choose>
         <xsl:when test="string-length(/calendar/usrctx/userprefs/@ceNotifyEmail) > 0">
           <xsl:value-of select="/calendar/usrctx/userprefs/@ceNotifyEmail"/>
         </xsl:when>
         <xsl:when test="string-length(/calendar/usrctx/user/@mail) > 0">
           <xsl:value-of select="/calendar/usrctx/user/@mail"/>
         </xsl:when>
        </xsl:choose>
       </xsl:attribute>

       <xsl:attribute name="onBlur">
          var f = document.forms[0];
          if (f['NotifyEmail'].value.length &gt; 0) {
	    if (f['NotifyEmail'].value.search(/[,;]/) &gt; -1) {
              f['ceNotifyEnable'].checked = false;
	      alert('<xsl:value-of select="$alert_only_one_email"/>');
            } else {
              f['ceNotifyEnable'].checked = true;
	    }
          } else {
            f['ceNotifyEnable'].checked = false;
          }
       </xsl:attribute>
  </INPUT>
</FONT>
</TD>
</TR>
</xsl:if>
</TABLE>

</FORM>
</BODY>
</HTML>

</xsl:template>

<!-- Output appearance options -->
<xsl:template name="appearance_root">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>

<BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="9" marginheight="9">
<FORM method="post">
  <xsl:attribute name="action"><xsl:value-of select="./formdata/@action"/></xsl:attribute>
  <xsl:attribute name="name">form</xsl:attribute>
  <xsl:apply-templates select="formdata"/>
  <INPUT type="hidden" name="doNotProcess" value="0"/>
  <INPUT type="hidden" name="optionsTab" value="appearance"/>

<TABLE border="0" cellpadding="3" cellspacing="1" width="100%">
<TR>
<TD>
<B>
<FONT size="{$font_size_big_3}" face="{$font_name}">
<xsl:value-of select="$appearance_title"/></FONT>
</B>
<BR/>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<xsl:value-of select="$appearance_msg"/></FONT>
<HR size="{$font_size_big}"/>
</TD>
</TR>
<TR>
<TD>
<B>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<xsl:value-of select="$color_scheme_title"/></FONT>
</B>
</TD>
</TR>
<TR>
<TD>
<TABLE border="0" cellpadding="0" cellspacing="1">
<TR>
<TD>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<INPUT type="radio" name="ceColorSet" value="pref_group_1">
<xsl:if test="(/calendar/usrctx/userprefs/@ceColorSet = 'pref_group_1')"><xsl:attribute name="checked"/></xsl:if>
</INPUT>
</FONT>
</TD>
<TD bgcolor="#666699">
<xsl:text>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</xsl:text></TD>
<TD bgcolor="#9999CC">
<xsl:text>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</xsl:text></TD>
<TD bgcolor="#99CCFF">
<xsl:text>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</xsl:text></TD>
<TD bgcolor="#999999">
<xsl:text>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</xsl:text></TD>
<TD bgcolor="#666666">
<xsl:text>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</xsl:text></TD>
</TR>
<TR>
<TD>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<INPUT type="radio" name="ceColorSet" value="pref_group_2">
<xsl:if test="/calendar/usrctx/userprefs/@ceColorSet = 'pref_group_2'"><xsl:attribute name="checked"/></xsl:if>
</INPUT>
</FONT>
</TD>
<TD bgcolor="#666600">
<xsl:text>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</xsl:text></TD>
<TD bgcolor="#999966">
<xsl:text>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</xsl:text></TD>
<TD bgcolor="#FFFFCC">
<xsl:text>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</xsl:text></TD>
<TD bgcolor="#CC9966">
<xsl:text>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</xsl:text></TD>
<TD bgcolor="#666633">
<xsl:text>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</xsl:text></TD>
</TR>
<TR>
<TD>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<INPUT type="radio" name="ceColorSet" value="pref_group_3">
<xsl:if test="/calendar/usrctx/userprefs/@ceColorSet = 'pref_group_3'"><xsl:attribute name="checked"/></xsl:if>
</INPUT>
</FONT>
</TD>
<TD bgcolor="#666699">
<xsl:text>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</xsl:text></TD>
<TD bgcolor="#CC99CC">
<xsl:text>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</xsl:text></TD>
<TD bgcolor="#FFCCFF">
<xsl:text>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</xsl:text></TD>
<TD bgcolor="#996699">
<xsl:text>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</xsl:text></TD>
<TD bgcolor="#660066">
<xsl:text>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</xsl:text></TD>
</TR>
<TR>
<TD>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<INPUT type="radio" name="ceColorSet" value="pref_group_4">
<xsl:if test="/calendar/usrctx/userprefs/@ceColorSet = 'pref_group_4'"><xsl:attribute name="checked"/></xsl:if>
</INPUT>
</FONT>
</TD>
<TD bgcolor="#006600">
<xsl:text>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</xsl:text></TD>
<TD bgcolor="#669966">
<xsl:text>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</xsl:text></TD>
<TD bgcolor="#99CC99">
<xsl:text>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</xsl:text></TD>
<TD bgcolor="#66CC66">
<xsl:text>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</xsl:text></TD>
<TD bgcolor="#339933">
<xsl:text>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</xsl:text></TD>
</TR>
<TR>
<TD>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<INPUT type="radio" name="ceColorSet" value="pref_group_7">
<xsl:if test="/calendar/usrctx/userprefs/@ceColorSet = 'pref_group_7'"><xsl:attribute name="checked"/></xsl:if>
</INPUT>
</FONT>
</TD>
<TD bgcolor="#999999">
<xsl:text>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</xsl:text></TD>
<TD bgcolor="#B2B2B2">
<xsl:text>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</xsl:text></TD>
<TD bgcolor="#666666">
<xsl:text>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</xsl:text></TD>
<TD bgcolor="#999999">
<xsl:text>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</xsl:text></TD>
<TD bgcolor="#FFFFFF">
<xsl:text>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</xsl:text></TD>
</TR>
</TABLE>
</TD>
</TR>
<TR>
<TD>
<IMG src="imx/spacer.gif" width="1" height="1"/>
</TD>
</TR>
<TR>
<TD>
<B>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<xsl:value-of select="$toolbar_title"/></FONT>
</B>
</TD>
</TR>
<TR>
<TD>
<TABLE border="0" cellpadding="0" cellspacing="1">
<TR>
<TD>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<INPUT type="radio" name="ceTool">
<xsl:if test="((/calendar/usrctx/userprefs/@ceToolText='1') and (/calendar/usrctx/userprefs/@ceToolImage='1')) or ((string-length(/calendar/usrctx/userprefs/@ceToolText) = 0) and (string-length(/calendar/usrctx/userprefs/@ceToolImage) = 0))"><xsl:attribute name="checked"/></xsl:if>
</INPUT>
</FONT>
</TD>
<TD>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<xsl:value-of select="$icons_and_text_msg"/></FONT>
</TD>
</TR>
<TR>
<TD>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<INPUT type="radio" name="ceTool" value="ceToolImage">
<xsl:if test="(/calendar/usrctx/userprefs/@ceToolText='0') and (/calendar/usrctx/userprefs/@ceToolImage='1')"><xsl:attribute name="checked"/></xsl:if>
</INPUT>
</FONT>
</TD>
<TD>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<xsl:value-of select="$icons_only_msg"/></FONT>
</TD>
</TR>
<TR>
<TD>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<INPUT type="radio" name="ceTool" value="ceToolText">
<xsl:if test="(/calendar/usrctx/userprefs/@ceToolText='1') and (/calendar/usrctx/userprefs/@ceToolImage='0')"><xsl:attribute name="checked"/></xsl:if>
</INPUT>
</FONT>
</TD>
<TD>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<xsl:value-of select="$text_only_msg"/></FONT>
</TD>
</TR>
</TABLE>
</TD>
</TR>
<TR>
<TD>
<IMG src="imx/spacer.gif" width="1" height="1"/>
</TD>
</TR>
<TR>
<TD>
<B>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<xsl:value-of select="$display_font_title"/></FONT>
</B>
</TD>
</TR>
<TR>
<TD>
<TABLE border="0" cellpadding="0" cellspacing="1">
<TR>
<TD valign="baseline">
<FONT size="{$font_size_big_2}" face="{$font_name}">
<FONT size="{$font_size_big_2}" face="{$font_name}">
<xsl:value-of select="$face_title"/></FONT>
<BR/>
<SELECT name="ceFontFace">
<OPTION value="PrimaSans BT,Verdana,sans-serif">
<xsl:if test="(string-length(/calendar/usrctx/userprefs/@ceFontFace) = 0) or (contains((/calendar/usrctx/userprefs/@ceFontFace), 'sans-serif'))"><xsl:attribute name="selected"/></xsl:if>
<xsl:value-of select="$sans_serif_title"/></OPTION>
<OPTION value="Times New Roman,Times,serif">
<xsl:if test="contains((/calendar/usrctx/userprefs/@ceFontFace), ',serif')"><xsl:attribute name="selected"/></xsl:if>
<xsl:value-of select="$serif_title"/></OPTION>
<OPTION value="Courier New,Courier,mono">
<xsl:if test="contains((/calendar/usrctx/userprefs/@ceFontFace), 'mono')"><xsl:attribute name="selected"/></xsl:if>
<xsl:value-of select="$mono_title"/></OPTION>
</SELECT>
</FONT>
</TD>
<TD valign="baseline">
<FONT size="{$font_size_big_2}" face="{$font_name}">
</FONT>
</TD>
<TD valign="baseline">
<FONT size="{$font_size_big_2}" face="{$font_name}">
<FONT size="{$font_size_big_2}" face="{$font_name}">
<xsl:value-of select="$size_title"/></FONT>
<BR/>
<SELECT name="ceFontSizeDelta">
<OPTION value="pref_font_size_group_1">
<xsl:if test="/calendar/usrctx/userprefs/@ceFontSizeDelta='pref_font_size_group_1'"><xsl:attribute name="selected"/></xsl:if>
<xsl:value-of select="$larger_title"/></OPTION>
<OPTION value="pref_font_size_group_2">
<xsl:if test="/calendar/usrctx/userprefs/@ceFontSizeDelta = 'pref_font_size_group_2'"><xsl:attribute name="selected"/></xsl:if>
<xsl:value-of select="$default_title"/></OPTION>
<OPTION value="pref_font_size_group_3">
<xsl:if test="/calendar/usrctx/userprefs/@ceFontSizeDelta='pref_font_size_group_3'"><xsl:attribute name="selected"/></xsl:if>
<xsl:value-of select="$smaller_title"/></OPTION>
</SELECT>
</FONT>
</TD>
</TR>
</TABLE>
</TD>
</TR>
</TABLE>


</FORM>
</BODY>
</HTML>

</xsl:template>

<!-- Output import frame -->
<xsl:template name="import_root">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>
  <xsl:call-template name="javascript_strings"/>
  <SCRIPT SRC="js_date_checking.js">alert('NotFound!');</SCRIPT>

<BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="9" marginheight="9">
<FORM method="post">
  <xsl:attribute name="action"><xsl:value-of select="./formdata/@action"/></xsl:attribute>
  <xsl:attribute name="enctype">multipart/form-data</xsl:attribute>
  <xsl:attribute name="name">importForm</xsl:attribute>
  <xsl:attribute name="method">post</xsl:attribute>
  <xsl:apply-templates select="formdata"/>
  <INPUT type="hidden" name="doNotProcess" value="0"/>
  <INPUT type="hidden" name="formName" value="importForm"/>

<TABLE border="0" cellpadding="3" cellspacing="1">
<TR>
<TD>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<B><xsl:value-of select="$event_destination_title"/></B>
</FONT>
</TD>
</TR>
<TR>
<TD>
<xsl:if test="./optionsdata/@sessionExpired = '1'"><xsl:call-template name="outputErrorString"><xsl:with-param name="ErrorString"><xsl:value-of select="$session_expired_msg"/></xsl:with-param></xsl:call-template></xsl:if>
<xsl:if test="./optionsdata/@noValidCalendar = '1'"><xsl:call-template name="outputErrorString"><xsl:with-param name="ErrorString"><xsl:value-of select="$need_valid_calendar_msg"/></xsl:with-param></xsl:call-template></xsl:if>
<NOBR>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<FONT size="{$font_size_big}" face="{$font_name}">
<xsl:value-of select="$add_events_to_text"/><xsl:text>&nbsp;</xsl:text>
</FONT>
<nbsp/>
<!-- This break has to be here or the pulldown menu disappears when it contains names that -->
<!-- would require scrollbars. Netscape only but on all platforms -->
<br/>
<SELECT name="calendar">
<OPTION><xsl:value-of select="$select_calendar_title"/></OPTION>
<xsl:for-each select="/calendar/usrctx/calendarList/calID">
<OPTION value="{@name}">-&nbsp;
  <xsl:call-template name="printCalendarName">
    <xsl:with-param name="name" select="./@name"/>
    <xsl:with-param name="printname" select="./@printableName"/>
  </xsl:call-template>
</OPTION>
</xsl:for-each>
</SELECT>
</FONT>
</NOBR>
</TD>
</TR>
<TR>
<TD>
<HR size="{$font_size_big}" noshade=""/></TD></TR><TR>
<TD><FONT size="{$font_size_big_2}" face="{$font_name}">
<NOBR><B><NOBR><xsl:value-of select="$import_format_title"/><xsl:text>&nbsp;</xsl:text></NOBR></B></NOBR>

<SELECT name="format"><OPTION value="text/calendar"><xsl:value-of select="$ical_title"/></OPTION><OPTION value="text/xml"><xsl:value-of select="$xml_title"/></OPTION></SELECT></FONT></TD></TR>
<TR><TD>
<xsl:choose>
    <xsl:when test="./optionsdata/@sourceFileError = '1'">
	<xsl:call-template name="outputErrorString">
	    <xsl:with-param name="ErrorString"><xsl:value-of select="$source_file_invalid_error"/></xsl:with-param>
	</xsl:call-template>
    </xsl:when>
    <xsl:when test="./optionsdata/@sourceFileError = '2'">
	<xsl:call-template name="outputErrorString">
	    <xsl:with-param name="ErrorString"><xsl:value-of select="$format_file_mismatch_error"/></xsl:with-param>
	</xsl:call-template>
    </xsl:when>
    <xsl:when test="./optionsdata/@sourceFileError = '3'">
	<xsl:call-template name="outputErrorString">
	    <xsl:with-param name="ErrorString"><xsl:value-of select="$successful_import_msg"/></xsl:with-param>
	</xsl:call-template>
    </xsl:when>
</xsl:choose>
<FONT size="{$font_size_big_2}" face="{$font_name}"><B><NOBR><xsl:value-of select="$source_file_title"/>&nbsp;</NOBR></B>

<FONT size="{$font_size_big_2}" face="{$font_name}">
<INPUT type="file" name="file" size="30"/>
</FONT>
<UL>
<LI>
<xsl:call-template name="click_browse_instruct"/>
</LI>
</UL>
</FONT>
</TD>
</TR>
<TR>
<TD>
<HR size="{$font_size_big}" noshade=""/>
</TD>
</TR>
<TR>
<TD>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<B>
<xsl:value-of select="$date_range_title"/>
</B>
</FONT>
</TD>
</TR>
<TR>
<TD>
<INPUT type="radio" name="dr" value="all" checked=""/>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<xsl:text>&nbsp;</xsl:text><xsl:value-of select="$import_all_msg"/></FONT>
</TD>
</TR>
<TR>
<TD>
<xsl:if test="./optionsdata/@dateRangeError = '1'"><xsl:call-template name="outputErrorString"><xsl:with-param name="ErrorString"><xsl:value-of select="$invalid_date_range_error"/></xsl:with-param></xsl:call-template></xsl:if>
<INPUT type="radio" name="dr" value="range"/>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<xsl:call-template name="importExportDateRangeInput"/>
</FONT></TD></TR>
<TR><TD>&nbsp;</TD></TR>
<TR><TD>&nbsp;</TD></TR>
<TR>
<TD colspan="3">
<INPUT type="button" name="ok" width="82" value="{$import_title}">
  <xsl:attribute name="onClick">
    var f=document.forms[0]; 
    f['i_tabswitch'].value=<xsl:value-of select="/calendar/@tab"/>;
    var x=document.forms[0].submit();
  </xsl:attribute>
</INPUT>
</TD></TR>

</TABLE></FORM>

</BODY>

</HTML>

</xsl:template>

<!-- Output export frame -->
<xsl:template name="export_root">
<HTML>
<!--  <xsl:call-template name="javascriptNormalize"/> -->
  <xsl:call-template name="emit_frame_head_tag"/>
  <xsl:call-template name="javascript_strings"/>
  <SCRIPT SRC="js_date_checking.js">alert('NotFound!');</SCRIPT>
  <SCRIPT SRC="js_normalize.js">alert('NotFound!');</SCRIPT>

<BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="9" marginheight="9">
<FORM method="post">
  <xsl:attribute name="action"><xsl:value-of select="./formdata/@action"/></xsl:attribute>
  <xsl:attribute name="name">exportForm</xsl:attribute>
  <xsl:apply-templates select="formdata"/>
  <INPUT type="hidden" name="doNotProcess" value="0"/>
  <INPUT type="hidden" name="formName" value="exportForm"/>

<TABLE border="0" cellpadding="3" cellspacing="1">
<TR>
<TD>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<B>
<xsl:value-of select="$calendars_title"/></B>
</FONT>
</TD>
<TD>
<xsl:text>&nbsp;</xsl:text></TD>
<TD>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<B>
<xsl:value-of select="$calendars_to_export_title"/></B>
</FONT>
</TD>
</TR>
<TR>
<TD valign="top">
<FONT size="{$font_size_big_2}" face="{$font_name}">
<SELECT size="{$font_size_biggest}" multiple="" name="export_other">
  <xsl:attribute name="onChange">
    var dialog = 'Export';
    return parent.MoveCursorOnFocus(dialog,this.options, this.selectedIndex, this);
  </xsl:attribute>
  <xsl:attribute name="onFocus">
    var dialog = 'Export';
    return parent.MoveCursorOnFocus(dialog,this.options, this.selectedIndex, this);
  </xsl:attribute>
<xsl:for-each select="/calendar/usrctx/calendarList/calID">
<OPTION value="{@name}">
  <xsl:call-template name="printCalendarName">
    <xsl:with-param name="name" select="./@name"/>
  </xsl:call-template>
</OPTION>
</xsl:for-each>
<!-- To ensure the width of the field, add a blank, no value spacer item (30 underbars since &nbsp doesn't work) -->
<!-- The value must be set to "" or the value is automatically set to the display name -->
<OPTION value="">______________________________</OPTION>
</SELECT>
</FONT>
</TD>
<TD width="1%">
<FONT size="{$font_size_big}" face="{$font_name}">
<INPUT type="button" name="export_add_cal_button" width="24" value="{$addarrow_title}">
<xsl:attribute name="onClick">
  var f = document.forms[0];
  var find_form = f;

  if(find_form['export_other'].options[find_form['export_other'].options.length - 1].selected)
  {
    alert('<xsl:value-of select="$alert_selected_blank_choice"/>');
    return;
  }

  if (f['myaction'])
  {
    f['doNotProcess'].value=1;
    f['myaction'].value = 'export_add_cal';
    void f.submit();
  }
</xsl:attribute>
</INPUT>
<BR/>
<BR/>
<INPUT type="button" name="export_remove_cal_button" width="24" value="{$leftarrowremove_title}">
<xsl:attribute name="onClick">
  var f = document.forms[0];
  var find_form = f;

  if(find_form['export_includes'].options[find_form['export_includes'].options.length - 1].selected)
  {
    alert('<xsl:value-of select="$alert_selected_blank_choice"/>');
    return;
  }

  if (f['myaction'])
  {
    f['doNotProcess'].value=1;
    f['myaction'].value = 'export_remove_cal';
    void f.submit();
  }
</xsl:attribute>
</INPUT>
</FONT>
</TD>
<TD>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<SELECT size="{$font_size_biggest}" multiple="" name="export_includes">
  <xsl:attribute name="onChange">
    var dialog = 'Export';
    return parent.MoveCursorOnFocus(dialog,this.options, this.selectedIndex, this);
  </xsl:attribute>
  <xsl:attribute name="onFocus">
    var dialog = 'Export';
    return parent.MoveCursorOnFocus(dialog,this.options, this.selectedIndex, this);
  </xsl:attribute>
   <xsl:for-each select="./exportdata/exportcal">
      <OPTION value="{@calid}">
        <xsl:call-template name="printCalendarName">
          <xsl:with-param name="name" select="./@calid"/>
        </xsl:call-template>
      </OPTION>
   </xsl:for-each>
<!-- To ensure the width of the field, add a blank, no value spacer item (30 underbars since &nbsp doesn't work) -->
<!-- The value must be set to "" or the value is automatically set to the display name -->
   <OPTION value="">______________________________</OPTION>
</SELECT>
</FONT>
</TD>
</TR>
<TR>
<TD colspan="3">
<FONT size="{$font_size_big_2}" face="{$font_name}">
<B>
<xsl:value-of select="$date_range_title"/></B>

</FONT>
</TD>
</TR>
<TR>
<TD colspan="3">
<INPUT type="radio" name="dr" value="all" checked=""/>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<xsl:value-of select="$export_all_msg"/></FONT>
</TD>
</TR>
<TR>
<TD colspan="3">
<xsl:if test="./optionsdata/@dateRangeError = '1'"><xsl:call-template name="outputErrorString"><xsl:with-param name="ErrorString"><xsl:value-of select="$invalid_date_range_error"/></xsl:with-param></xsl:call-template></xsl:if>
<INPUT type="radio" name="dr" value="range"/>
<FONT size="{$font_size_big_2}" face="{$font_name}">
<xsl:call-template name="importExportDateRangeInput"/>
</FONT>
</TD>
</TR>
<TR>
<TD colspan="3">
<HR size="{$font_size_big}" noshade=""/>
</TD>
</TR>
<TR>
<TD colspan="3">
<FONT size="{$font_size_big_2}" face="{$font_name}">
<B>
<xsl:value-of select="$export_format_title"/></B>
</FONT>
</TD>
</TR>
<TR>
<TD colspan="3">
<FONT size="{$font_size_big_2}" face="{$font_name}">
<SELECT name="content-out">
<OPTION value="text/calendar">
<xsl:value-of select="$ical_title"/></OPTION>
<OPTION value="text/xml">
<xsl:value-of select="$xml_title"/></OPTION>
</SELECT>
&nbsp;&nbsp;
<INPUT type="checkbox" name="outlook"/>
  <xsl:value-of select="$outlook_title"/>
</FONT>
</TD>
</TR>
<TR><TD>
<xsl:if test="./optionsdata/@sessionExpired = '1'"><xsl:call-template name="outputErrorString"><xsl:with-param name="ErrorString"><xsl:value-of select="$session_expired_msg"/></xsl:with-param></xsl:call-template></xsl:if>
<xsl:if test="./optionsdata/@noValidCalendar = '1'"><xsl:call-template name="outputErrorString"><xsl:with-param name="ErrorString"><xsl:value-of select="$need_valid_calendar_msg"/></xsl:with-param></xsl:call-template></xsl:if>
</TD></TR>
<TR><TD>&nbsp;</TD></TR>
<TR><TD>&nbsp;</TD></TR>
<TR>
<TD colspan="3">
<FONT face="{$font_name}" size="{$font_size_big_2}">
<INPUT type="button" name="ok" width="82" value="{$export_title}">
  <xsl:attribute name="onClick">
    var f=document.forms[0]; 
    f['i_tabswitch'].value=<xsl:value-of select="/calendar/@tab"/>;
    var x=document.forms[0].submit();
  </xsl:attribute>
</INPUT>
</FONT>
</TD>
</TR>
</TABLE>

</FORM>
</BODY>
</HTML>

</xsl:template>

<!-- Output basic set of Options buttons ("Save Changes") -->
<xsl:template name="options_button_root">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>

<BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="0" marginheight="0">

<FORM name="form" method="post">
<TABLE width="100%" height="100%" border="0" cellpadding="0" cellspacing="0">
  <TR>
    <TD align="right" bgcolor="{$bgcolor_button}">
      <FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">
      <INPUT type="button" name="ok" value="{$save_changes_title}" width="72">
        <xsl:attribute name="onClick">
          
          var f = parent.frames[2].document.forms[0];
          var skipcheck = false;
          
          if (f['ceDayHead'])
          {
            var startdaytime = f['ceDayHead'].options[f['ceDayHead'].selectedIndex].value;
            var enddaytime = f['ceDayTail'].options[f['ceDayTail'].selectedIndex].value;       
          } else
            skipcheck = true;
		  
          if ( skipcheck || (checkStartEndTime(startdaytime, enddaytime, '<xsl:value-of select="$need_valid_end_start_msg"/>')) == true)
         {
              f['doNotProcess'].value=0;
              f['myaction'].value = 'saveprefs';
              f['i_tabswitch'].value=<xsl:value-of select="/calendar/@tab"/>; 
              var x=parent.frames[2].document.forms[0].submit();
          }
        </xsl:attribute>
      </INPUT><xsl:text>&nbsp;&nbsp;</xsl:text>
      </FONT>
    </TD>
  </TR>
</TABLE>
</FORM>

</BODY>
</HTML>
</xsl:template>

<!-- Output Import buttons ("Import" and "Help") -->
<xsl:template name="options_button_import">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>

<BODY bgcolor="{$bgcolor_background}" marginwidth="0" marginheight="0">

<FORM name="form" method="post">
<TABLE width="100%" height="100%" border="0" cellpadding="0" cellspacing="0">
  <TR>
    <TD align="right" bgcolor="{$bgcolor_button}">
      <FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">
      <INPUT type="button" name="help" value="{$help_title}" onClick="{./button[@name='helpimport']}" width="72"/>
      </FONT>
    </TD>
  </TR>
</TABLE>
</FORM>

</BODY>
</HTML>
</xsl:template>

<!-- Output Export buttons ("Export" and "Help") -->
<xsl:template name="options_button_export">
<HTML>
<HEAD>
</HEAD>

<BODY bgcolor="{$bgcolor_background}" marginwidth="0" marginheight="0">

<FORM name="form" method="post">
<TABLE width="100%" height="100%" border="0" cellpadding="0" cellspacing="0">
  <TR>
    <TD align="right" bgcolor="{$bgcolor_button}">
      <FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">
      <INPUT type="button" name="help" value="{$help_title}" onClick="{./button[@name='helpexport']}" width="72"/>
      </FONT>
    </TD>
  </TR>
</TABLE>
</FORM>

</BODY>
</HTML>
</xsl:template>

<!-- Output Javascript that switches main frame to another tab -->
<xsl:template name="options_load_tabs">
<script>
function loadtab(i, u, newView)
{
  var url = u + '&amp;tab=' + i;
  parent.window.location.href = url;
}
</script>
</xsl:template>

<!-- Output the toolbar for the Options view -->
<xsl:template name="options_toolbar_root">
  <html>
  <xsl:call-template name="emit_frame_head_tag"/>

  <body bgcolor="{$bgcolor_background}" marginwidth="0" marginheight="0">
  <xsl:text></xsl:text><!--DIV style="position:absolute;z-index:1;"-->
  <form name="form">
    <xsl:for-each select="group">
      <xsl:if test="@name='toolbar'">
        <xsl:call-template name="brand"/>
        <xsl:call-template name="toolbar-tabs"/>
      </xsl:if>
    </xsl:for-each>
  </form>
  <xsl:text></xsl:text><!--/DIV-->
  <xsl:text></xsl:text><!--DIV id="tabBG" style="position:absolute;z-index:0;"><IMG src="imx/tbg.gif"></DIV-->
  </body>
  </html>
</xsl:template>

</xsl:stylesheet>
